#include <vcl>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <limits.h>
#include <time.h>
#include <math.h>

int *cria_vetor(int n);
void libera_vetor(int *vetor);
void constroi_solucao_aleatoria(int *v, int n);
void imprime_solucao(int *v, int n);
float funcao (float w);
int calcula_n(float p, float xmin, float xmax);
int bin_int(int *v, int n);
float converte_real(int *v, int r, int n, float xmin, float xmax);
float calcula_fo(float y);
void troca_bit(int *v, int j);
double randomico(double min, double max);
void atualiza_melhor_solucao(int *v, int *v_star, int n);
void imprime_solucao(int *v, int n);
void inicializa_vetor(int *vetor, int n);

void SA(int n,
        int r,
        int *v,
        float *fo,
        double alfa,
        double temperatura_inicial,
        double temperatura_final,
        int SAmax,
        float xmin,
        float xmax);

int calcula_n(float p, float xmin, float xmax);

int menu_principal(void);



//---------------------------------------------------------------------------

#pragma argsused
int main
(int argc, char **argv)
{
  int n;           // tamanho do vetor
  int b;           // valor decimal de v
  int d;           //valor decimal de um vetor binario qq
  int *v;          // vetor solucao corrente
  float s;          // valor x da funao
  float fo;          // funcao objetivo corrente
  float p;           //precisao de bits
  int int_maximo;    // maior inteiro com vetor de n bits
  int choice;

  float xmin=-2;          // valor minimo de x do intervalo
  float xmax=2;          // valor maximo de x do intervalo


  float delta;                 // variacao de energia
  float temperatura_inicial;// temperatura inicial de partida do sistema
  float temperatura_final;  // temperatura de congelamento do sistema
  float alfa;               // taxa de resfriamento
  int SAmax;                 // numero maximo de iteracoes em uma dada temperatura


  srand((int)time(NULL)); //  srand((unsigned) time(NULL)); // pega a hora do relogio como semente

  p = 0.00006;            //entrar com a precisao

  n = calcula_n(p,xmin,xmax);
  v = cria_vetor(n);
  for (int j=0; j<n; j++)   v[j] = 1;

  int_maximo = bin_int(v,n);

  fo = -INT_MAX;

  do {
    choice = menu_principal();
    switch (choice) {
    case 1: /* Geracao de uma solucao inicial */

             constroi_solucao_aleatoria(v, n);
             printf("Solucao aleatoria: v = ");
             imprime_solucao(v,n);
             s=converte_real(v,int_maximo,n,xmin,xmax);
             fo=calcula_fo(s);
             printf("valor de x = %2f \n",s);
             printf("funcao objetivo = %3f \n",fo);
	     break;

    case 2: /* Simulated Annealing */
          if (fo != -INT_MAX) {
            alfa = 0.97;
            temperatura_inicial = 100;
            temperatura_final = 0.1;
            SAmax = n/2;
            SA(n,int_maximo,v,&fo,alfa,temperatura_inicial,temperatura_final,SAmax, xmin, xmax);
          }
          else {
            printf("\n ----- Gere uma solucao inicial -------\n");
            getchar();
          }
          break;

    default:
          break;
    }
  } while (choice != 0);

  libera_vetor(v);

} /* fim do programa principal */

//---------------------------------------------------------------------------


/* cria memoria para um vetor de n posicoes */
int *cria_vetor(int n)
{
  int *vetor;

  vetor = (int *) malloc(n*sizeof(int));
  if (!vetor){
    printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}

void imprime_solucao(int *v, int n)
{
   printf("[");
   for (int j=0; j <= n-2; j++)
     printf("%1d ",v[j]);
   printf("%1d",v[n-1]);
   printf("]\n");
}

/*calcula n por meio da precisao p*/
int calcula_n(float p,float xmin,float xmax)
{
    int n;
    float s;

    s=(log(xmax-xmin)-log(p))/log(2);
    n=ceil(s);
    return n;
 }


 /*converte binario para inteiro base dez*/
int bin_int(int *v, int n)
{
  int d=0;
  int j=0;
  while (j != n)
  {
     if (v[j] == 1)
       d = d + pow(2,n-j-1);
     j++;
 }
 return d;
}


/* constroi uma solucao inicial aleatoria */
void constroi_solucao_aleatoria(int *v, int n)
{
    for (int j=0; j<n; j++) v[j] = random(2);
}


/* Gera numero aleatorio entre min e max */
double randomico(double min, double max)
{
  if (min == max) return min;
  return ((double) (rand()%10000/10000.0)*(max-min) + min);
}


/* converte vetor v binario para a representacao em real */
float converte_real(int *v,int int_maximo, int n,float xmin, float xmax )
{
  int b;

  b = bin_int(v,n);
  return xmin-((xmin-xmax)*b)/int_maximo;
}


float funcao (float w)
{
  float aux;
  if (w==0)
     aux=1;
  else
     aux=sin(w*M_PI)/(w*M_PI);
  return aux;
}


/* calcula a funcao objetivo */
float calcula_fo(float y)
{
  return 0.4 + funcao(4*y)+1.1*funcao(4*y+2)+0.8*funcao(6*y-2)+0.7*funcao(6*y-4);
}


/* troca bit */
void troca_bit(int *v, int j)
{
    if (v[j])
      v[j] = 0;
    else
      v[j] = 1;
}


/* libera memoria de um vetor */
void libera_vetor(int *vetor)
{
  free(vetor);
}


/* atualiza a melhor solucao */
void atualiza_melhor_solucao(int *v_star, int *v, int n)
{
   for (int j=0; j<n; j++) v_star[j] = v[j];
}


/* inicializa vetor */
void inicializa_vetor(int *vetor, int tam)
{
    for (int j=0; j<tam; j++) vetor[j] = 0;
}



/* Menu principal */
int menu_principal(void)
{
  int escolha;

  do {
    printf("\n************************************************* \n");
    printf("         1. Gere solucao inicial \n");
    printf("         2. Simulated Annealing \n");
    printf("         0. Sair \n");
    printf("         Escolha: ");
    scanf("%d",&escolha);
  } while (escolha < 0 || escolha > 2);
  return escolha;
}


//---------------------------------------------------------------------------


void SA(int n,
        int int_maximo,
        int *v,
        float *fo,
        double alfa,
        double temperatura_inicial,
        double temperatura_final,
        int SAmax,
        float xmin,
        float xmax)
{
    double x;              // numero aleatorio entre ZERO e UM
    double temperatura;    // temperatura corrente
    int iter;              // numero de iteracoes na temperatura corrente
    int num_mudancas_temp; // numero de mudancas de temperatura
    int posicao_escolhida;
    float delta;           // variacao de energia
    float fo_star;
    int *v_star;
    float s, slinha, smax;
    v_star = cria_vetor(n);
    inicializa_vetor(v_star,n);
    atualiza_melhor_solucao(v_star, v, n);
    fo_star = *fo;
    temperatura = temperatura_inicial;
    num_mudancas_temp = 0;
    s=converte_real(v,int_maximo,n,xmin,xmax);
    printf("Solucao inicial: fo corrente = %f   valor de fo = %2f \n",*fo,s);

	/* enquanto o sistema nao congelar faca */
    while (temperatura > temperatura_final) {
       iter = 0;
	  /* enquanto o equilibrio termico nao for atingido faca */
       while (iter < SAmax){
          iter++;
	  	/* escolha um vizinho qualquer */
    	  posicao_escolhida = random(n);
          s=converte_real(v,int_maximo,n,xmin,xmax);
       	  troca_bit(v, posicao_escolhida);
          slinha=converte_real(v,int_maximo,n,xmin,xmax);

	  	/* calcule a variacao de energia */
          delta =calcula_fo(slinha)-calcula_fo(s) ;
    //	  printf("variacao de energia = %3f \n",delta);

	  	/* se houver melhora, aceite o vizinho */
	  if (delta > 0){
	     (*fo) += delta;
              s=slinha;
//             printf("Solucao de melhor: fo corrente = %f   valor de x = %2f \n",*fo,s);


             if (*fo > fo_star){
	  	atualiza_melhor_solucao(v_star, v, n);
		fo_star = *fo;
                smax = s;
//	        printf("****************************** fo_star = %3f \n",fo_star);

             }
	  }
	  else {
	      /* se houver piora, aceite o vizinho com uma determinada
                 probabilidade */
	      x = randomico(0,1);
              if (x < exp(delta/temperatura)){
	       	 (*fo) += delta;
                 s=slinha;
//                 printf("Solucao de piora: fo corrente = %f   valor de x = %2f \n",*fo,y);

              }
	      else {
               	/* Se o vizinho nao foi aceito, desfaca o movimento */
                 troca_bit(v, posicao_escolhida);
              }
	  }
        }
		/* decresca a temperatura */
        temperatura *= alfa;
//        printf("Temperatura atual = %10.3f\n", temperatura);
        num_mudancas_temp += 1;
    }

    printf("********* Melhor Solucao obtida pelo SA ************** \n");
    printf("valor de x = %2f \n",smax);
    printf("funcao objetivo = %3f \n",fo_star);
    printf("Num. de solucoes analisadas = %ld \n",num_mudancas_temp*SAmax);

    printf("****************************************************** \n");
    atualiza_melhor_solucao(v, v_star, n);
    (*fo) = fo_star;
    libera_vetor(v_star);
    getchar();
}


