#include <stdio.h>
#include <string.h>
#include <math.h>
#include <limits.h>
#include <time.h>
#include "Util.h"
#include "Construcao.h"
#include "Arquivos.h"
#include "Descida.h"
#include "MultiStart.h"

float MultiStart (int n, int *s, float **d, int itermax)
{
  float f_star, fo;
  int *s_star;

  s_star = cria_vetor(n);
  constroi_solucao_gulosa_vizinho_mais_proximo(n,s_star,d);
  f_star = calcula_fo(n,s_star,d);
  for (int i = 1; i <= itermax; i++){
    constroi_solucao_aleatoria(n,s,d);
    fo = descida(n,s,d);
    if (fo < f_star){
      atualiza_vetor(s_star, s, n);
      f_star = fo;
    }
  }
  atualiza_vetor(s, s_star, n);
  libera_vetor(s_star);
  return f_star;
}























