#include "Util.h"
#include <stdio.h>
#include <stdlib.h>
#include "Descida.h"
#include <time.h>
#include "Construcao.h"
#include "Arquivos.h"


float MS(int n, int *s, float **d, int iter_max)
{
  float f_star, fo;
  clock_t inicio_CPU, fim_CPU;
  int *s_star;

  s_star = cria_vetor(n);
  atualiza_vetor(s_star, s, n);
  fo = f_star = calcula_fo(n, s, d);
  limpa_arquivo("MS.txt");
  inicio_CPU = fim_CPU = clock();
  imprime_fo("MS.txt", (fim_CPU - inicio_CPU)/CLK_TCK,f_star,0);

  for (int i = 1; i < iter_max; i++){
    constroi_solucao(n,s,d);
    embaralha_vetor(s,n);
    fo = calcula_fo(n,s,d);
    fo = descida(n,s,d);
    if (fo < f_star){
      f_star = fo;
      atualiza_vetor(s_star, s, n);
    }
  }

  fim_CPU = clock();
  imprime_fo("MS.txt", (fim_CPU - inicio_CPU)/CLK_TCK,f_star,0);
  libera_vetor(s_star);
  return f_star;
}


