/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UUtil                            Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar mtodos comuns a todo o sistema.
* Descrio................: Esta unit no contm "implementao" de classes
*                            pois alguns dos mtodos no podem pertencer a
*                            nenhuma.
* Obs......................: O arquivo .h dessa unit NO foi modificado.
* Dependncias.............:
*     1) UTar_Jorn
*******************************************************************************/

#pragma hdrstop

#include "UUtil.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
//------------------------------------------------------------------------------

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "Grids.hpp"
#include "math.h"

#include "UTar_Jorn.h"
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: OrdenaListaTamTarefa
- Objetivo...: Mtodo utilizado para ordenar a lista pelo tamanho das tarefas.
- Retorno....: Nmero inteiro (usado para ordenar uma lista de tarefas);
- Parmetros.:
     1) Item1 -> Objeto do tipo TTarefa.
     2) Item2 -> Objeto do tipo TTarefa.
============================================================================= */
int __fastcall OrdenaListaTamTarefa(void * Item1, void * Item2)
{
 TTarefa *T1 = (TTarefa *)Item1;
 TTarefa *T2 = (TTarefa *)Item2;

 if ((T1->HFim - T1->HInicio) < (T2->HFim - T2->HInicio))
   return -1;
 else if ((T1->HFim - T1->HInicio) == (T2->HFim - T2->HInicio))
   return 0;
 else
   return 1;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: OrdenaListaHIni
- Objetivo...: Mtodo utilizado para ordenar a lista pelo horrio inicial.
- Retorno....: Nmero inteiro (usado para ordenar uma lista de tarefas);
- Parmetros.:
     1) Item1 -> Objeto do tipo TTarefa.
     2) Item2 -> Objeto do tipo TTarefa.
============================================================================= */
int __fastcall OrdenaListaHIni(void * Item1, void * Item2)
{
 TTarefa *T1 = (TTarefa *)Item1;
 TTarefa *T2 = (TTarefa *)Item2;

 if (T1->HInicio < T2->HInicio)
   return -1;
 else if (T1->HInicio == T2->HInicio)
   return 0;
 else
   return 1;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LimparGrid
- Objetivo...: Limpar o grid recebido.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) G -> StringGrid que ser limpo.
============================================================================= */
void LimparGrid(TStringGrid *G)
{
 int i,j;

 i = j = 0;
 while (i < G->RowCount)
  {
   while (j < G->ColCount)
    {
     G->Cells[j][i] = "";
     j++;
    }
   j=0;
   i++;
  }
 G->RowCount = 2;
 G->FixedRows = 1;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: MinuteToStr
- Objetivo...: Converter um valor em minutos para string (formatado 00:00).
- Retorno....: Horrio (String);
- Parmetros.:
     1) T -> Tempo em minutos.
============================================================================= */
String MinuteToStr(int T)
{
 div_t Aux;
 String Tempo, Hor, Min;

 Aux = div(0,1);
 Tempo = "";
 Hor = "";
 Min = "";

 Aux = div(T, 60);

 Hor = IntToStr(Aux.quot);
 if (Hor.Length() == 1)
  Hor = "0" + Hor;

 Min = IntToStr(Aux.rem);
 if (Min.Length() == 1)
  Min = "0" + Min;

 Tempo = Hor + ":" + Min;

 return Tempo;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: StrToMinute
- Objetivo...: Converter um valor string (00:00) em minutos (int).
- Retorno....: Horrio (int);
- Parmetros.:
     1) T -> Tempo (string).
============================================================================= */
int StrToMinute(String T)
{
 int Tempo, Hor, Min;
 String TAux = "";

 int i = 1;
 while (T[i] != ':')
  {
   TAux = TAux + T[i];
   i++;
  }

 Hor = 60 * StrToInt(TAux);
 TAux = T.SubString(i+1, T.Length());
 Min = StrToInt(TAux);

 Tempo = Hor + Min;

 return Tempo;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CompararGrupo
- Objetivo...: Retornar se a linha 1  do mesmo grupo que a linha 2.
- Retorno....: true/false.
- Parmetros.:
     1) Linha1 -> Uma linha qualquer.
     2) Linha2 -> Uma linha qualquer.
============================================================================= */
bool CompararGrupo(String Linha1, String Linha2)
{
 char Aux1, Aux2;

 Aux1 = Linha1[Linha1.Length()];
 Aux2 = Linha2[Linha2.Length()];

 if (Aux1 == Aux2)
  return true;
 else
  return false;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: getLinha
- Objetivo...: Retornar a linha sem o grupo.
- Retorno....: Linha sem o seu grupo (String).
- Parmetros.:
     1) Linha -> Linha com o seu grupo.
============================================================================= */
String getLinha(String Linha)
{
 String Aux;
 int i = 1;
 while (Linha[i] != '.')
  {
   Aux = Aux + Linha[i];
   i++;
  }

 return Aux;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: AnoBissexto
- Objetivo...: Retornar se o ano recebido  bi-sexto ou no.
- Retorno....: true/false.
- Parmetros.:
     1) Ano -> Qualquer ano.
============================================================================= */
bool AnoBissexto(int Ano)
{
 return ( (fmod(Ano,4) == 0) && ((fmod(Ano,100) != 0) || (fmod(Ano,400) == 0)) );
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: NumeroDeDiasNoMes
- Objetivo...: Retornar o nmero de dias do ms recebido.
- Retorno....: N de dias que o ms recebido possui (int).
- Parmetros.:
     1) Ano -> Qualquer ano (usado para verificar se  bissexto).
     2) Mes -> Qualquer ms.
============================================================================= */
int NumeroDeDiasNoMes(int Ano, int Mes)
{
 int NDias = 0;

 if ( (Mes == 1) || (Mes == 3) || (Mes == 5) || (Mes == 7) || (Mes == 8) || (Mes == 10) || (Mes == 12) )
  NDias = 31;
 else if (Mes == 2)
  NDias = 28;
 else
  NDias = 30;

 if ( (Mes == 2) && (AnoBissexto(Ano)) )
  NDias++;

 return NDias;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: getMes
- Objetivo...: Retornar o nome do ms recebido.
- Retorno....: Mome do ms (String).
- Parmetros.:
     1) Mes -> Qualquer ms (int).
============================================================================= */
String getMes(int Mes)
{
 String Nome;

 if (Mes == 1)
  Nome = "Janeiro";
 else if (Mes == 2)
  Nome = "Fevereiro";
 else if (Mes == 3)
  Nome = "Maro";
 else if (Mes == 4)
  Nome = "Abril";
 else if (Mes == 5)
  Nome = "Maio";
 else if (Mes == 6)
  Nome = "Junho";
 else if (Mes == 7)
  Nome = "Julho";
 else if (Mes == 8)
  Nome = "Agosto";
 else if (Mes == 9)
  Nome = "Setembro";
 else if (Mes == 10)
  Nome = "Outubro";
 else if (Mes == 11)
  Nome = "Novembro";
 else
  Nome = "Dezembro";

 return Nome;
}
//------------------------------------------------------------------------------

//------------------------------------ FIM -----------------------------------\\
