/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UTripulacoes                       Tipo.......: .h
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar estruturas referentes s tripulaes.
* Descrio................: Esta unit contm a "declarao" de uma classe
*                            (TTripulacao) referente aos atributos comuns para
*                            as tripulaes de ambas as escalas, de uma outra
*                            (TTripED) referente aos atributos das tripulaes
*                            para a escala diria e de uma outra (TTripEM)
*                            referente aos atributos das tripulaes para a
*                            escala mensal.
* Obs......................: O arquivo .cpp dessa unit possui a implementao de
*                            tudo que foi declarado aqui.
* Dependncias.............:
*     1) UEstruturaMes
*     2) UParPpt
*     3) UPesos
*******************************************************************************/

#ifndef UTripulacoesH
#define UTripulacoesH

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "classes.hpp"

#include "UEstruturaMes.h"
#include "UParPpt.h"
#include "UPesos.h"
//------------------------------------------------------------------------------


/* =============================================================================
- Classe.....: TTripulacao
- Objetivo...: Possui os atributos e mtodos referentes s tripulaes.
============================================================================= */
class TTripulacao{
  public:
    int TmpTTrabalho;     // Tempo total de trabalho (minutos).
    int TmpEJornadas;     // Tempo entre jornadas (minutos).
    long int FncObjetivo; // Funo objetivo.

    TTripulacao();
};
//------------------------------------------------------------------------------


/* =============================================================================
- Classe.....: TTripED
- Objetivo...: Possui os atributos e mtodos referentes s tripulaes para a
               escala diria.
============================================================================= */
class TTripED : public TTripulacao{
  private:
    void CalcTmpTTrabalho();
    void CalcTmpEJornadas();

    void CalcFolAcuTotal();
    void CalcHExtra(TParPptED *);
    void CalcTmpOcioso(TParPptED *);
    void CalcTmpSobreposicao(TParPptED *);
    void CalcNTarefas();
    void CalcNTPProibidas(TParPptED *);
    void CalcNTPPermitidas(TParPptED *);
    void CalcNTVeiculos();
    void CalcDPegada(TParPptED *);
    void InserirTarVirtual(TParPptED *);
    void CalcNTLinhas();

  public:
    int FolAcuTotal;        // Folga acumulada total (minutos).
    int HExtra;             // Hora extra (minutos).
    int TmpOcioso;          // Tempo ocioso (minutos).
    int TmpSobreposicao;    // Tempo de sobreposio (minutos).
    int NTarefas;           // Nmero de tarefas.
    int NDPegadas;          // Nmero de duplas pegadas.
    int NTPProibidas;       // Nmero de trocas de ponto proibidas.
    int NTPPermitidas;      // Nmero de trocas de ponto permitidas.
    int NTLProibidas;       // Nmero de trocas de linha proibidas.
    int NTLPermitidas;      // Nmero de trocas de linha permitidas.
    int NTVeiculos;         // Nmero de trocas de veculos.
    int MaiorIntEntTarefas; // Maior intervalo entre tarefas (minutos).
    int TVirtual;           // Horrio de trmino da tarefa virtual (caso exista).
    TList *LstTarefas;      // Lista de tarefas.

    TTripED();
    void CalcFncObjetivo(TParPptED *, TPesosED *);
    void EfetuarCalcTrip(TParPptED *, TPesosED *);
    void Free();
};
//------------------------------------------------------------------------------


/* =============================================================================
- Classe.....: TTripEM
- Objetivo...: Possui os atributos e mtodos referentes s tripulaes para a
               escala mensal.
============================================================================= */
class TTripEM : public TTripulacao{
  private:
    void CalcTmpEJornadas(TEstruturaMes *, TParPptEM *);
    void CalcNumJornDif();
    void CalcNumTrocaTipPeg(TEstruturaMes *);
    void CalcNumTroPerTrab(TEstruturaMes *, TParPptEM *);

  public:
    int NumJornDif;     // Nmero de jornadas diferentes.
    int NumTrocaTipPeg; // Nmero de trocas de tipo de pegada.
    int NumTroPerTrab;  // Nmero de troca de perodo de trabalho.
    TList *LstDias;     // Lista de dias.

    TTripEM();
    void CalcTmpTTrabalho(TEstruturaMes *);
    void CalcFncObjetivo(int, TParPptEM *, TPesosEM *);
    void EfetuarCalcTrip(int, TEstruturaMes *, TParPptEM *, TPesosEM *);
    void Free();
};
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#endif
// ----------------------------------- FIM ---------------------------------- \\
