/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UTripulacoes                     Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar estruturas referentes s tripulaes.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TTripulacao) referente aos atributos comuns para
*                            as tripulaes de ambas as escalas, de uma outra
*                            (TTripED) referente aos atributos das tripulaes
*                            para a escala diria e de uma outra (TTripEM)
*                            referente aos atributos das tripulaes para a
*                            escala mensal.
* Obs......................: O arquivo .h dessa unit possui a declarao de
*                            tudo que foi implementado aqui.
* Dependncias.............:
*     1) UTar_Jorn
*     2) UUtil
*******************************************************************************/

#pragma hdrstop

#include "UTripulacoes.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
//------------------------------------------------------------------------------

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UTar_Jorn.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#define max(a, b)  (((a) > (b)) ? (a) : (b))

//------------------------------------------------------------------------------


                        // ----- CLASSE TTripulacao ----- \\

/* =============================================================================
- Mtodo.....: TTripulacao
- Objetivo...: Criar e inicializar o objeto TTripulacao.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TTripulacao::TTripulacao()
{
 TmpTTrabalho = 0;
 TmpEJornadas = 0;
 FncObjetivo  = 0;
}
//------------------------------------------------------------------------------


                        // ----- CLASSE TTripED ----- \\

/* =============================================================================
- Mtodo.....: TTripED
- Objetivo...: Criar e inicializar o objeto TTripED.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TTripED::TTripED()
{
 FolAcuTotal        = 0;
 HExtra             = 0;
 TmpOcioso          = 0;
 TmpSobreposicao    = 0;
 NTarefas           = 0;
 NDPegadas          = 0;
 NTPProibidas       = 0;
 NTPPermitidas      = 0;
 NTLProibidas       = 0;
 NTLPermitidas      = 0;
 NTVeiculos         = 0;
 MaiorIntEntTarefas = 0;
 TVirtual           = 0;
 LstTarefas = new TList();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcTmpTTrabalho
- Objetivo...: Calcular o valor do tempo total de trabalho da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TTripED::CalcTmpTTrabalho()
{
 TTarefa *T1,*T2;
 this->TmpTTrabalho = 0;

 if (this->LstTarefas->Count != 0)
  {
   T1 = (TTarefa *)this->LstTarefas->First();
   T2 = (TTarefa *)this->LstTarefas->Last();
   this->TmpTTrabalho = (T2->HFim - T1->HInicio) - this->MaiorIntEntTarefas;
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcTmpEJornadas
- Objetivo...: Calcular o valor do tempo entre jornadas da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TTripED::CalcTmpEJornadas()
{
 TTarefa *T1,*T2;
 this->TmpEJornadas = 0;

 if (this->LstTarefas->Count != 0)
  {
   T1 = (TTarefa *)this->LstTarefas->First();
   T2 = (TTarefa *)this->LstTarefas->Last();

   if ((1440 - T2->HFim) + (T1->HInicio) > 0)
    this->TmpEJornadas = (1440 - T2->HFim) + (T1->HInicio);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcFolAcuTotal
- Objetivo...: Calcular o valor da folga acumulada total da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TTripED::CalcFolAcuTotal()
{
 TTarefa *T;
 this->FolAcuTotal = 0;

 for (int i=0; i < this->LstTarefas->Count; i++)
  {
   T = (TTarefa *)this->LstTarefas->Items[i];
   this->FolAcuTotal = this->FolAcuTotal + T->FolAcu;
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcHExtra
- Objetivo...: Calcular o valor da hora extra da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) PED -> Objeto que contm os parmetros para a escala diria.
============================================================================= */
void TTripED::CalcHExtra(TParPptED *PED)
{
 this->HExtra = 0;

 if (this->NDPegadas == 0)  //No  Dupla Pegada
  {
   if (this->TmpTTrabalho > (PED->TmpNormalTrab + PED->IntTotRepAli))
    this->HExtra = this->TmpTTrabalho - (PED->TmpNormalTrab + PED->IntTotRepAli);
  }
 else
  if (this->TmpTTrabalho > PED->TmpNormalTrab)
   this->HExtra = this->TmpTTrabalho - PED->TmpNormalTrab;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcTmpOcioso
- Objetivo...: Calcular o valor do tempo ocioso da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) PED -> Objeto que contm os parmetros para a escala diria.
============================================================================= */
void TTripED::CalcTmpOcioso(TParPptED *PED)
{
 TTarefa *T1,*T2;
 this->TmpOcioso = 0;

 for (int i=0; i < this->LstTarefas->Count; i++)
  {
   if (this->LstTarefas->Items[i] != this->LstTarefas->Last())
    {
     T1 = (TTarefa *)this->LstTarefas->Items[i];
     T2 = (TTarefa *)this->LstTarefas->Items[i+1];

     if ((T2->HInicio - T1->HFim) > 0)
     this->TmpOcioso = this->TmpOcioso + (T2->HInicio - T1->HFim);
    }
  }

 if (this->NDPegadas == 0)  //No  Dupla Pegada
  this->TmpOcioso = this->TmpOcioso + this->FolAcuTotal +
                    max (0, (PED->TmpNormalTrab + PED->IntTotRepAli) - this->TmpTTrabalho);
 else
  this->TmpOcioso = this->TmpOcioso + this->FolAcuTotal - MaiorIntEntTarefas +
                    max (0, PED->TmpNormalTrab - this->TmpTTrabalho);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcTmpSobreposicao
- Objetivo...: Calcular o valor do tempo de sobreposio da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) PED -> Objeto que contm os parmetros para a escala diria.
============================================================================= */
void TTripED::CalcTmpSobreposicao(TParPptED *PED)
{
 TTarefa *T1,*T2;
 int Aux;
 this->TmpSobreposicao = 0;

 for (int i=0; i < this->LstTarefas->Count; i++)
  {
   if (this->LstTarefas->Items[i] != this->LstTarefas->Last())
    {
     T1 = (TTarefa *)this->LstTarefas->Items[i];
     T2 = (TTarefa *)this->LstTarefas->Items[i+1];

     if (T2->HInicio < T1->HFim)
      {
       this->TmpSobreposicao = this->TmpSobreposicao + (T1->HFim - T2->HInicio);

       if (T1->NumVeic != T2->NumVeic)
        this->TmpSobreposicao = this->TmpSobreposicao + PED->TmpTrocaTrip;
      }
     else
      if (T1->NumVeic != T2->NumVeic)
       this->TmpSobreposicao = this->TmpSobreposicao + max(0, PED->TmpTrocaTrip - (T2->HInicio - T1->HFim));
    }
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcNTarefas
- Objetivo...: Calcular o nmero de tarefas da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TTripED::CalcNTarefas()
{
 this->NTarefas = this->LstTarefas->Count;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcNTPProibidas
- Objetivo...: Calcular o nmero de trocas de ponto proibidas da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) PED -> Objeto que contm os parmetros para a escala diria.
============================================================================= */
void TTripED::CalcNTPProibidas(TParPptED *PED)
{
 bool AchouMInt = false;
 TTarefa *T1,*T2;
 this->NTPProibidas = 0;

 if (this->LstTarefas->Count == 2)
  {
   T1 = (TTarefa *)this->LstTarefas->Items[0];
   T2 = (TTarefa *)this->LstTarefas->Items[1];
   if ( this->MaiorIntEntTarefas <= PED->TmpDPegada && T1->PFim != T2->PIni )
    this->NTPProibidas++;
  }
 else
  for (int i=0; i < this->LstTarefas->Count; i++)
   {
    if (this->LstTarefas->Items[i] != this->LstTarefas->Last())
     {
      T1 = (TTarefa *)this->LstTarefas->Items[i];
      T2 = (TTarefa *)this->LstTarefas->Items[i+1];

      if (T1->PFim != T2->PIni)
       {
        if ((T2->HInicio - T1->HFim) != this->MaiorIntEntTarefas)
         this->NTPProibidas++;
        else
         if ( (this->MaiorIntEntTarefas > PED->TmpDPegada) && (!AchouMInt) )
          AchouMInt = true;
         else
          this->NTPProibidas++;
       }
     }
   }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcNTPPermitidas
- Objetivo...: Calcular o nmero de trocas de ponto permitidas da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) PED -> Objeto que contm os parmetros para a escala diria.
============================================================================= */
void TTripED::CalcNTPPermitidas(TParPptED *PED)
{
 bool AchouMInt = false;
 TTarefa *T1,*T2;
 this->NTPPermitidas = 0;

 if (this->LstTarefas->Count == 2)
  {
   T1 = (TTarefa *)this->LstTarefas->Items[0];
   T2 = (TTarefa *)this->LstTarefas->Items[1];
   if ((this->MaiorIntEntTarefas > PED->TmpDPegada) && (T1->PFim != T2->PIni))
    this->NTPPermitidas++;
  }
 else
  for (int i=0; i < this->LstTarefas->Count; i++)
   {
    if (this->LstTarefas->Items[i] != this->LstTarefas->Last())
     {
      T1 = (TTarefa *)this->LstTarefas->Items[i];
      T2 = (TTarefa *)this->LstTarefas->Items[i+1];

      if (((T2->HInicio - T1->HFim) == this->MaiorIntEntTarefas) && (this->MaiorIntEntTarefas > PED->TmpDPegada))
       {
        if ((!AchouMInt) && (T1->PFim != T2->PIni))
         {
          this->NTPPermitidas++;
          AchouMInt = true;
         }
       }
     }
   }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcNTVeiculos
- Objetivo...: Calcular o nmero de trocas de veculos da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TTripED::CalcNTVeiculos()
{
 TTarefa *T1,*T2;
 this->NTVeiculos = 0;

 for (int i=0; i < this->LstTarefas->Count; i++)
  {
   if (this->LstTarefas->Items[i] != this->LstTarefas->Last())
    {
     T1 = (TTarefa *)this->LstTarefas->Items[i];
     T2 = (TTarefa *)this->LstTarefas->Items[i+1];

     if (T2->NumVeic != T1->NumVeic)
      this->NTVeiculos++;
    }
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcDPegada
- Objetivo...: Calcular se existe dupla pegada e o tempo desta (MaiorIntEntTarefas).
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) PED -> Objeto que contm os parmetros para a escala diria.
============================================================================= */
void TTripED::CalcDPegada(TParPptED *PED)
{
 TTarefa *T1,*T2;
 this->NDPegadas = 0;
 this->MaiorIntEntTarefas = 0;

 for (int i=0; i < this->LstTarefas->Count; i++)
  {
   if (this->LstTarefas->Items[i] != this->LstTarefas->Last())
    {
     T1 = (TTarefa *)this->LstTarefas->Items[i];
     T2 = (TTarefa *)this->LstTarefas->Items[i+1];
     if (((T2->HInicio - T1->HFim) > this->MaiorIntEntTarefas) && ((T2->HInicio - T1->HFim) > PED->TmpDPegada))
      {
       NDPegadas = 1;
       this->MaiorIntEntTarefas = (T2->HInicio - T1->HFim);
      }
    }
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: InserirTarVirtual
- Objetivo...: Inserir a tarefa virtual (caso seja necessrio) para a tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) PED -> Objeto que contm os parmetros para a escala diria.
============================================================================= */
void TTripED::InserirTarVirtual(TParPptED *PED)
{
 TTarefa *T1, *T2, *TF;
 bool TemIntMin = false;

 this->TVirtual = 0;

 if (this->NDPegadas == 0)
  {
   if (this->TmpTTrabalho > PED->TmpNormalTrab)
    {
     if (this->LstTarefas->Count != 0)
      {
       for (int i=0; i < this->LstTarefas->Count; i++)
        {
         if (this->LstTarefas->Items[i] != this->LstTarefas->Last())
          {
           T1 = (TTarefa *)this->LstTarefas->Items[i];
           T2 = (TTarefa *)this->LstTarefas->Items[i+1];

           if ((T2->HInicio - T1->HFim) >= PED->SubIntContRA)
            TemIntMin = true;
          }
        }// for

       TF = (TTarefa *)this->LstTarefas->Last();

       if (!TemIntMin)
        {
         if (this->TmpOcioso >= PED->IntTotRepAli)
          {
           this->TVirtual = TF->HFim + PED->SubIntContRA;
           this->TmpOcioso = this->TmpOcioso - PED->IntTotRepAli;
           this->TmpTTrabalho = this->TmpTTrabalho + (TVirtual - TF->HFim);
          }
         else
          {
           this->TmpOcioso = this->TmpOcioso + PED->SubIntContRA;
           this->TVirtual = TF->HFim + PED->SubIntContRA + max(0, PED->IntTotRepAli - this->TmpOcioso);
           this->TmpTTrabalho = this->TmpTTrabalho + (TVirtual - TF->HFim);
           this->TmpOcioso = max(0, this->TmpOcioso - PED->IntTotRepAli);
          }
        }
       else // if (TemIntMin)
        {
         if (this->TmpOcioso >= PED->IntTotRepAli)
          {
           this->TmpOcioso = this->TmpOcioso - PED->IntTotRepAli;
          }
         else
          {
           this->TVirtual = TF->HFim + PED->IntTotRepAli - this->TmpOcioso;
           this->TmpOcioso = 0;
           this->TmpTTrabalho = this->TmpTTrabalho + (TVirtual - TF->HFim);
          }
        }// else
      }// if (this->LstTarefas->Count != 0)
    }// if (this->TmpTTrabalho > PED->TmpNormalTrab)
   else
    {
     this->TmpTTrabalho = this->TmpTTrabalho + PED->IntTotRepAli;
     this->TmpOcioso = this->TmpOcioso - PED->IntTotRepAli;
    }
  }// if (this->NDPegadas == 0)
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcNTLinhas
- Objetivo...: Calcular o nmero de trocas de linhas permitidas e proibidas.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TTripED::CalcNTLinhas()
{
 TTarefa *T1,*T2;
 this->NTLPermitidas = 0;
 this->NTLProibidas = 0;

 for (int i=0; i < this->LstTarefas->Count; i++)
  {
   if (this->LstTarefas->Items[i] != this->LstTarefas->Last())
    {
     T1 = (TTarefa *)this->LstTarefas->Items[i];
     T2 = (TTarefa *)this->LstTarefas->Items[i+1];

     if (T2->LinIni != T1->LinFin)
      {
       if (CompararGrupo(T1->LinFin, T2->LinIni))
        this->NTLPermitidas++;
       else
        this->NTLProibidas++;
      }
    }
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcFncObjetivo
- Objetivo...: Calcular o valor da funo objetivo da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) ParED -> Objeto que contm os parmetros para a escala diria.
     2) PED   -> Objeto que contm os pesos para a escala diria.
============================================================================= */
void TTripED::CalcFncObjetivo(TParPptED *ParED, TPesosED *PED)
{
 int FaltaTmpEJor = 0;

 if (NTarefas != 0)
  FaltaTmpEJor = max(0, ParED->TmpMinEntJorn - this->TmpEJornadas);

 FncObjetivo = (PED->PTOcioso * this->TmpOcioso +
                PED->PHExtra * this->HExtra +
                PED->PTTTrabalho * max(0, TmpTTrabalho - ParED->TmpMaxTrab) +
                PED->PTSobreposicao * this->TmpSobreposicao +
                PED->PTPProibidas * this->NTPProibidas +
                PED->PTPPermitidas * this->NTPPermitidas +
                PED->PTVeiculos * this->NTVeiculos +
                PED->PTEJornadas * FaltaTmpEJor +
                PED->PTLProibidas * this->NTLProibidas +
                PED->PTLPermitidas * this->NTLPermitidas);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: EfetuarCalcTrip
- Objetivo...: Efetuar todos os clculos da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) ParED -> Objeto que contm os parmetros para a escala diria.
     2) PED   -> Objeto que contm os pesos para a escala diria.
============================================================================= */
void TTripED::EfetuarCalcTrip(TParPptED *ParED, TPesosED *PED)
{
 CalcNTarefas();
 FolAcuTotal = 0;
 HExtra = 0;
 TmpTTrabalho = 0;
 TmpOcioso = 0;
 TmpSobreposicao = 0;
 TmpEJornadas = 0;
 NDPegadas = 0;
 NTPProibidas = 0;
 NTPPermitidas = 0;
 NTVeiculos = 0;
 NTLProibidas = 0;
 NTLPermitidas = 0;
 MaiorIntEntTarefas = 0;
 FncObjetivo = 0;
 TVirtual = 0;

 if (this->NTarefas != 0)
  {
   CalcDPegada(ParED); // Tambm calcula o tempo da dupla pegada (MaiorIntEntTarefas)
   CalcFolAcuTotal();
   CalcTmpSobreposicao(ParED);
   CalcTmpEJornadas();
   CalcNTVeiculos();
   CalcTmpTTrabalho();       // Parcial...
   CalcTmpOcioso(ParED);     // Parcial...
   InserirTarVirtual(ParED); // Contempla o Tempo Ocioso e o Tempo Total de Trabalho
   CalcHExtra(ParED);
   CalcNTPProibidas(ParED);
   CalcNTPPermitidas(ParED);
   CalcNTLinhas();
   CalcFncObjetivo(ParED, PED);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Free
- Objetivo...: Destuir o objeto TTripED.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TTripED::Free()
{
 TTarefa *T;
 for (int i = 0; i < this->LstTarefas->Count; i++)
  {
   T = (TTarefa *)this->LstTarefas->Items[i];
   T->Free();
  }
 delete(this->LstTarefas);
 delete(this);
}
//------------------------------------------------------------------------------


                        // ----- CLASSE TTripEM ----- \\

/* =============================================================================
- Mtodo.....: TTripEM
- Objetivo...: Criar e inicializar o objeto TTripEM.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TTripEM::TTripEM()
{
 NumJornDif     = 0;
 NumTrocaTipPeg = 0;
 NumTroPerTrab  = 0;
 LstDias = new TList();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcTmpTTrabalho
- Objetivo...: Calcular o tempo de trabalho da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) EM -> Objeto que contm as listas de jornadas.
============================================================================= */
void TTripEM::CalcTmpTTrabalho(TEstruturaMes *EM)
{
 TDias *D;
 TJornada *J;
 this->TmpTTrabalho = 0;

 for (int i = 0; i < this->LstDias->Count; i++)
  {
   D = (TDias *)this->LstDias->Items[i];
   if (D->Numero != -1)
    {
     if (D->Tipo == 'U')
      J = (TJornada *)EM->LstJornDU->Items[D->Numero];
     else if (D->Tipo == 'S')
      J = (TJornada *)EM->LstJornSab->Items[D->Numero];
     else
      J = (TJornada *)EM->LstJornDF->Items[D->Numero];

     this->TmpTTrabalho = this->TmpTTrabalho + (D->Qtd * J->TmpTrab);
    }
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcTmpEntreJorn
- Objetivo...: Calcular o tempo entre as jornadas.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) EM -> Objeto que contm as listas de jornadas.
     2) PEM -> Objeto que contm os parmetros para a escala mensal.
============================================================================= */
void TTripEM::CalcTmpEJornadas(TEstruturaMes *EM, TParPptEM *PEM)
{
 TDias *D1, *D2;
 TJornada *J1, *J2;
 this->TmpEJornadas = 0;

 for (int i = 0; i < this->LstDias->Count; i++)
  {
   if (this->LstDias->Items[i] != this->LstDias->Last())
    {
     D1 = (TDias *)this->LstDias->Items[i];
     D2 = (TDias *)this->LstDias->Items[i+1];
     if ( (D1->Numero != -1) && (D2->Numero != -1) )
      {
       if (D1->Tipo == 'U')
        J1 = (TJornada *)EM->LstJornDU->Items[D1->Numero];
       else if (D1->Tipo == 'S')
        J1 = (TJornada *)EM->LstJornSab->Items[D1->Numero];
       else
        J1 = (TJornada *)EM->LstJornDF->Items[D1->Numero];

       if (D2->Tipo == 'U')
        J2 = (TJornada *)EM->LstJornDU->Items[D2->Numero];
       else if (D2->Tipo == 'S')
        J2 = (TJornada *)EM->LstJornSab->Items[D2->Numero];
       else
        J2 = (TJornada *)EM->LstJornDF->Items[D2->Numero];

       if ((1440 - J1->HFim) + (J2->HInicio) > 0)
         this->TmpEJornadas = this->TmpEJornadas + max(0, PEM->TmpMinEntJorn - ((1440 - J1->HFim) + J2->HInicio));
       else
         this->TmpEJornadas = this->TmpEJornadas + PEM->TmpMinEntJorn;
      }
    }
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcNumJornDif
- Objetivo...: Calcular o nmero de jornadas diferentes.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TTripEM::CalcNumJornDif()
{
 TDias *D;
 this->NumJornDif = 0;
 bool Achou;
 int Aux = 0;
 String Num = "";

 TList *LstAux = new TList(); 
 LstAux->Add((void *)-1);

 for (int i = 0; i < this->LstDias->Count; i++)
  {
   D = (TDias *)this->LstDias->Items[i];
   Achou = false;
   if (D->Numero != -1)
    {
     if (D->Tipo == 'U')
      Num = "-1" + IntToStr(D->Numero);
     else if (D->Tipo == 'S')
      Num = "-2" + IntToStr(D->Numero);
     else
      Num = "-3" + IntToStr(D->Numero);

     for (int j = 1; j < LstAux->Count; j++)
      {
       Aux = (int)LstAux->Items[j];
       if (Num == Aux)
        Achou = true;
      }
     if (!Achou)
      LstAux->Add((void *)StrToInt(Num));
    }
  }

 this->NumJornDif = LstAux->Count;
 delete(LstAux);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcNumTrocaTipPeg
- Objetivo...: Calcular o nmero de trocas de tipo de pegada.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) EM -> Objeto que contm as listas de jornadas para dias teis.
============================================================================= */
void TTripEM::CalcNumTrocaTipPeg(TEstruturaMes *EM)
{
 TDias *D;
 TJornada *J;
 char Tipo;
 this->NumTrocaTipPeg = 0;

 int j = 0;
 do
  {
   D = (TDias *)this->LstDias->Items[j];
   j++;
  }while (D->Tipo != 'U');
 J = (TJornada *)EM->LstJornDU->Items[D->Numero];
 Tipo = J->Tipo;

 for (int i = 0; i < this->LstDias->Count; i++)
  {
   D = (TDias *)this->LstDias->Items[i];
   if (D->Tipo == 'U')
    {
     J = (TJornada *)EM->LstJornDU->Items[D->Numero];
     if (J->Tipo != Tipo)
      {
       Tipo = J->Tipo;
       this->NumTrocaTipPeg++;
      }
    }
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcNumTroPerTrab
- Objetivo...: Calcular o nmero de trocas de perodo de trabalho.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) EM  -> Objeto que contm as listas de jornadas.
     2) PEM -> Objeto que contm os parmetros para a escala mensal.
============================================================================= */
void TTripEM::CalcNumTroPerTrab(TEstruturaMes *EM, TParPptEM *PEM)
{
 TDias *D1, *D2;
 TJornada *J1, *J2;
 int Aux;
 this->NumTroPerTrab = 0;

 for (int i = 0; i < this->LstDias->Count; i++)
  {
   if (this->LstDias->Items[i] != this->LstDias->Last())
    {
     D1 = (TDias *)this->LstDias->Items[i];
     if (D1->Numero != -1)
      {
       Aux = i;
       do
        {
         Aux++;
         D2 = (TDias *)this->LstDias->Items[Aux];
        }while (D2->Numero == -1);

       if (D1->Tipo == 'U')
        J1 = (TJornada *)EM->LstJornDU->Items[D1->Numero];
       else if (D1->Tipo == 'S')
        J1 = (TJornada *)EM->LstJornSab->Items[D1->Numero];
       else
        J1 = (TJornada *)EM->LstJornDF->Items[D1->Numero];

       if (D2->Tipo == 'U')
        J2 = (TJornada *)EM->LstJornDU->Items[D2->Numero];
       else if (D2->Tipo == 'S')
        J2 = (TJornada *)EM->LstJornSab->Items[D2->Numero];
       else
        J2 = (TJornada *)EM->LstJornDF->Items[D2->Numero];

       if ( (J1->HInicio < PEM->HorLTPTrab) && (J2->HInicio >= PEM->HorLTPTrab) ||
            (J1->HInicio >= PEM->HorLTPTrab) && (J2->HInicio < PEM->HorLTPTrab) )
         this->NumTroPerTrab++;
      }
    }
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcFncObjetivo
- Objetivo...: Calcular o valor da funo objetivo da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) TMT   -> Tempo mdio de trabalho na escala mensal.
     2) ParEM -> Objeto que contm os parmetros para a escala mensal.
     3) PEM   -> Objeto que contm os pesos para a escala mensal.
============================================================================= */
void TTripEM::CalcFncObjetivo(int TMT, TParPptEM *ParEM, TPesosEM *PEM)
{
 int DifTMT = TMT - this->TmpTTrabalho;
 if (DifTMT < 0)
  DifTMT = DifTMT * (-1);
 int DTMT = max(0, DifTMT - ParEM->DifTMT);

 this->FncObjetivo = (PEM->PNJorD * this->NumJornDif +
                      PEM->PNTTPeg * this->NumTrocaTipPeg +
                      PEM->PTEJornadas * this->TmpEJornadas +
                      PEM->PTMedioTrab * DTMT +
                      PEM->PNTPTrab * this->NumTroPerTrab);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: EfetuarCalcTrip
- Objetivo...: Efetuar todos os clculos da tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) TMT   -> Tempo mdio de trabalho na escala mensal.
     1) EM    -> Objeto que contm as listas de jornadas.
     2) ParEM -> Objeto que contm os parmetros para a escala mensal.
     3) PEM   -> Objeto que contm os pesos para a escala mensal.
============================================================================= */
void TTripEM::EfetuarCalcTrip(int TMT, TEstruturaMes *EM, TParPptEM *ParEM, TPesosEM *PEM)
{
 CalcTmpEJornadas(EM, ParEM);
 CalcNumJornDif();
 CalcNumTrocaTipPeg(EM);
 CalcNumTroPerTrab(EM, ParEM);
 CalcFncObjetivo(TMT, ParEM, PEM);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Free
- Objetivo...: Destuir o objeto TTripEM.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TTripEM::Free()
{
 for (int i = 0; i < this->LstDias->Count; i++)
  delete(this->LstDias->Items[i]);
 delete(this->LstDias);
 delete(this);
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
