/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UTar_Jorn                          Tipo.......: .h
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Representar as tarefas e as jornadas.
* Descrio................: Esta unit contm a "declarao" de uma classe
*                            (TTar_Jorn) referente aos atributos comuns entre
*                            tarefas e jornadas, uma outra (TTarefa) referente
*                            s tarefas, outra (TJornada) referente s jornadas
*                            e outra referente a jornadas de uma tripulao.
* Obs......................: O arquivo .cpp dessa unit possui a implementao de
*                            tudo que foi declarado aqui.
* Dependncias.............: <--- NENHUMA --->
*******************************************************************************/

#ifndef UTar_JornH
#define UTar_JornH

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "system.hpp"
//------------------------------------------------------------------------------

/* =============================================================================
- Classe.....: TTar_Jorn
- Objetivo...: Possui os atributos e mtodos comuns entre tarefas e jornadas.
============================================================================= */
class TTar_Jorn{
  public:
    int HInicio;   // Horrio de incio.
    int HFim;      // Horrio de trmino.
    String LinIni; // Linha inicial.
    String LinFin; // Linha Final.

    void PreencherAtributos(int, int, String, String);
    void Free();
};
//------------------------------------------------------------------------------

/* =============================================================================
- Classe.....: TTarefa
- Objetivo...: Possui os atributos e mtodos referentes s tarefas.
============================================================================= */
class TTarefa : public TTar_Jorn{
  public:
    int NumVeic; // Nmero do veculo.
    int PIni;    // Ponto inicial.
    int PFim;    // Ponto final.
    int FolAcu;  // Folga acumulada.

    void PreencherAtributos(int, int, String, String, int, int, int, int);
};
//------------------------------------------------------------------------------

/* =============================================================================
- Classe.....: TJornada
- Objetivo...: Possui os atributos e mtodos referentes s jornadas.
============================================================================= */
class TJornada : public TTar_Jorn{
  public:
    char Tipo;   // Tipo da jornada (dia til, sbado ou domingo e feriado).
    int TmpTrab; // Tempo de trabalho (minutos).
    int HExtra;  // Hora extra (minutos).
    int VeiIni;  // Veculo inicial da jornada.
    int VeiFin;  // Veculo final da jornada.
    int Ocio;    // Ociosidade total durante a jornada.

    void PreencherAtributos(int, int, String, String, char, int, int, int, int, int);
};
//------------------------------------------------------------------------------

/* =============================================================================
- Classe.....: TTar_Trip
- Objetivo...: Possui os atributos e mtodos referentes s tarefas de uma
               tripulao.
============================================================================= */
class TTar_Trip : public TTarefa{
  public:
    int NumTrip; // Nmero da tripulao.
    int NumTar;  // Nmero da tarefa.

    void PreencherAtributos(int, int, String, String, int, int, int, int, int, int);
};
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#endif
// ----------------------------------- FIM ---------------------------------- \\
