/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UTar_Jorn                        Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Representar as tarefas e as jornadas.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TTar_Jorn) referente aos atributos comuns entre
*                            tarefas e jornadas, uma outra (TTarefa) referente
*                            s tarefas, outra (TJornada) referente s jornadas
*                            e outra referente a jornadas de uma tripulao.
* Obs......................: O arquivo .h dessa unit possui a declarao de
*                            tudo que foi implementado aqui.
* Dependncias.............: <--- NENHUMA --->
*******************************************************************************/

#pragma hdrstop

#include "UTar_Jorn.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
//------------------------------------------------------------------------------


                        // ----- CLASSE TTar_Jorn ----- \\

/* =============================================================================
- Mtodo.....: PreencherAtributos
- Objetivo...: Preencher os valores do objeto com os valores recebidos.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) HI -> Horrio de incio.
   2) HF -> Horrio de trmino.
   3) LI -> Linha inicial.
   4) LF -> Linha final.
============================================================================= */
void TTar_Jorn::PreencherAtributos(int HI, int HF, String LI, String LF)
{
 HInicio = HI;
 HFim    = HF;
 LinIni  = LI;
 LinFin  = LF;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Free
- Objetivo...: Destuir o objeto TTar_Jorn (ou filho).
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TTar_Jorn::Free()
{
 delete(this);
}
//------------------------------------------------------------------------------


                        // ----- CLASSE TTarefa ----- \\

/* =============================================================================
- Mtodo.....: PreencherAtributos
- Objetivo...: Preencher os valores do objeto com os valores recebidos.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) HI -> Horrio de incio.
   2) HF -> Horrio de trmino.
   3) LI -> Linha inicial.
   4) LF -> Linha final.
   5) NV -> Nmero do veculo.
   6) PI -> Ponto inicial.
   7) PF -> Ponto final.
   8) FA -> Folga acumulada.
============================================================================= */
void TTarefa::PreencherAtributos(int HI, int HF, String LI, String LF, int NV,
                                 int PI, int PF, int FA)
{
 TTar_Jorn::PreencherAtributos(HI, HF, LI, LF);
 NumVeic = NV;
 PIni    = PI;
 PFim    = PF;
 FolAcu  = FA;
}
//------------------------------------------------------------------------------


                        // ----- CLASSE TJornada ----- \\

/* =============================================================================
- Mtodo.....: PreencherAtributos
- Objetivo...: Preencher os valores do objeto com os valores recebidos.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) HI -> Horrio de incio.
   2) HF -> Horrio de trmino.
   3) LI -> Linha inicial.
   4) LF -> Linha final.
   5) T  -> Tipo de jornada.
   6) TT -> Tempo trabalhado.
   7) HE -> Hora extra.
   8) VI -> Veculo inicial.
   9) VF -> Veculo final.
  10) O  -> Ociosidade.
============================================================================= */
void TJornada::PreencherAtributos(int HI, int HF, String LI, String LF, char T,
                                  int TT, int HE, int VI, int VF, int O)
{
 TTar_Jorn::PreencherAtributos(HI, HF, LI, LF);
 Tipo    = T;
 TmpTrab = TT;
 HExtra  = HE;
 VeiIni  = VI;
 VeiFin  = VF;
 Ocio    = O;
}
//------------------------------------------------------------------------------


                        // ----- CLASSE TTar_Trip ----- \\

/* =============================================================================
- Mtodo.....: PreencherAtributos
- Objetivo...: Preencher os valores do objeto com os valores recebidos.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) HI   -> Horrio de incio.
   2) HF   -> Horrio de trmino.
   3) LI   -> Linha inicial.
   4) LF   -> Linha final.
   5) NV   -> Nmero do veculo.
   6) PI   -> Ponto inicial.
   7) PF   -> Ponto final.
   8) FA   -> Folga acumulada.
   9) NT   -> Nmero da tripulao.
  10) NTar -> Nmero da tarefa.
============================================================================= */
void TTar_Trip::PreencherAtributos(int HI, int HF, String LI, String LF, int NV,
                                   int PI, int PF, int FA, int NT, int NTar)
{
 TTarefa::PreencherAtributos(HI, HF, LI, LF, NV, PI, PF, FA);
 NumTrip = NT;
 NumTar  = NTar;
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\