/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: USistema                           Tipo.......: .h
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar uma estrutura para controlar o sistema.
* Descrio................: Esta unit contm a "declarao" de uma classe
*                            (TSistema) referente ao sistema.
* Obs......................: O arquivo .cpp dessa unit possui a implementao de
*                            tudo que foi declarado aqui.
* Dependncias.............: <--- NENHUMA --->
*******************************************************************************/

#ifndef USistemaH
#define USistemaH

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "vcl.h"
//------------------------------------------------------------------------------

/* =============================================================================
- Classe.....: TSistema
- Objetivo...: Possui os atributos e mtodos referentes ao sistema.
============================================================================= */
class TSistema{
  private:
    void SelecionarArquivo(char);

  public:
    TColor CFundoTPrinc; // Cor do fundo da tela principal.
    TColor CCCTabelas;   // Cor das clulas comuns das tabelas.
    TColor CCFTabelas;   // Cor das clulas fixas das tabelas.
    TColor CFTabelas;    // Cor da fonte das tabelas.

    TSistema();
    void PreencherAtributos(TColor, TColor, TColor, TColor);
    bool ValoresValidos();
    void LerPadrao();
    void LerDefault();
    void GravarPadrao();
    void Free();
};
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#endif
// ----------------------------------- FIM ---------------------------------- \\
