/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: USistema                         Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar uma estrutura para controlar o sistema.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TSistema) referente ao sistema.
* Obs......................: O arquivo .h dessa unit possui a declarao de
*                            tudo que foi implementado aqui.
* Dependncias.............: <--- NENHUMA --->
*******************************************************************************/

#pragma hdrstop

#include "USistema.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
//------------------------------------------------------------------------------

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "stdio.h"
#include "vcl.h"
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: TSistema
- Objetivo...: Criar e inicializar o objeto TSistema.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TSistema::TSistema()
{
 this->LerPadrao();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherAtributos
- Objetivo...: Preencher os valores do objeto com os valores recebidos.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) CFTP -> Cor do fundo da tela principal.
   2) CCCT -> Cor das clulas comuns das tabelas.
   3) CCFT -> Cor das clulas fixas das tabelas.
   4) CFT  -> Cor da fonte das tabelas.
============================================================================= */
void TSistema::PreencherAtributos(TColor CFTP, TColor CCCT, TColor CCFT, TColor CFT)
{
 CFundoTPrinc = CFTP;
 CCCTabelas   = CCCT;
 CCFTabelas   = CCFT;
 CFTabelas    = CFT;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ValoresValidos
- Objetivo...: Verificar os valores do objeto.
- Retorno....: true/false (bool)
- Parmetros.: <-- Nenhum -->
============================================================================= */
bool TSistema::ValoresValidos()
{
 if ( (this->CCCTabelas == this->CCFTabelas) || (this->CCCTabelas == this->CFTabelas) ||
      (this->CCFTabelas == this->CFTabelas) )
  return false;
 else
  return true;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: SelecionarArquivo
- Objetivo...: Ler os valores do objeto a partir do arquivo correto.
- Retorno....: <-- Nenhum -->
- Parmetros.: Tipo -> 'D'- Default   |  'P'- Padro.
============================================================================= */
void TSistema::SelecionarArquivo(char Tipo)
{
 String Diretorio, Msg;
 if (Tipo == 'P')
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\PPT.par";
   Msg = "O arquivo 'PPT.par' no pode ser aberto!";
  }
 else
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\PPT.dft";
   Msg = "O arquivo 'PPT.dft' no pode ser aberto!";
  }

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "r");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg(Msg, mtError, TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   char P[100];
   char *Par = "PPT";
   char CFTP[20];
   char CCCT[20];
   char CCFT[20];
   char CFT[20];

   do
    {
     fscanf(Arq, "%s", &P);
    }while (strncmp(Par, P, 4));

    fscanf(Arq, "%s%s%s%s", &CFTP, &CCCT, &CCFT, &CFT);

    this->PreencherAtributos(StringToColor(CFTP), StringToColor(CCCT),
                             StringToColor(CCFT), StringToColor(CFT));
  }

 fclose(Arq);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LerPadrao
- Objetivo...: Ler os valores do objeto a partir do arquivo PPT.par.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TSistema::LerPadrao()
{
 SelecionarArquivo('P');
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LerPadrao
- Objetivo...: Ler os valores do objeto a partir do arquivo PPT.dft.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TSistema::LerDefault()
{
 SelecionarArquivo('D');
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: GravarPadrao
- Objetivo...: Gravar os valores do objeto no arquivo PPT.par.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TSistema::GravarPadrao()
{
 String Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\PPT.par";

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "w");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg("O arquivo 'PPT.par' no pode ser aberto!", mtError,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   fprintf(Arq, "%s\t%s\t%s\t%s\t%s", "PPT", ColorToString(this->CFundoTPrinc),
           ColorToString(this->CCCTabelas), ColorToString(this->CCFTabelas),
           ColorToString(this->CFTabelas));
  }

 fclose(Arq);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Free
- Objetivo...: Destuir o objeto TSistema.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TSistema::Free()
{
 delete(this);
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
