/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: USimAnn                            Tipo.......: .h
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar estruturas referentes ao Simulated Annealing.
* Descrio................: Esta unit contm a "declarao" de uma classe
*                            (TSimAnn) referente ao "mtodo" Simulated Annealing.
* Obs......................: O arquivo .cpp dessa unit possui a implementao de
*                            tudo que foi declarado aqui.
* Dependncias.............:
*     1) UEscDiaria
*     2) UEscMensal
*     3) UParPpt
*     4) UPesos
*     5) UEstruturaMes
*******************************************************************************/

#ifndef USimAnnH
#define USimAnnH

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "system.hpp"

#include "UEscDiaria.h"
#include "UEscMensal.h"
#include "UParPpt.h"
#include "UPesos.h"
#include "UEstruturaMes.h"
//------------------------------------------------------------------------------


/* =============================================================================
- Classe.....: TSimAnn
- Objetivo...: Possui os atributos e mtodos referentes ao "Simulated Annealing".
============================================================================= */
class TSimAnn{
  private:
    bool CriterioDeParada(TDateTime, double);
    int EscolherTripRem(TEscDiaria *);
    int EscolherTripAdic(TEscDiaria *, int);
    int EscolherTarefaRem(TEscDiaria *, int);
    int EscolherTrip1Troca(TEscMensal *);
    int EscolherTrip2Troca(TEscMensal *, int);
    int EscolherJornTroca(TEscMensal *, int, int);
    void SelecionarArquivo(char);

  public:
    int NumMaxIte;       // Nmero mximo de iteraes.
    double TxResf;       // Taxa de resfriamento.
    double TprInic;      // Temperatura inicial.
    double TprCong;      // Temperatura de congelamento.
    int TmpMaxProc;      // Tempo mximo de processamento.
    bool CPtprCong;      // Critrio de parada por temperatura de congelamento.
    bool CPtmMaxProc;    // Critrio de parada por tempo mximo de processamento.

    TDateTime TempoExec; // Tempo de execuo do Simulated Annealing.
    Extended TempAtual;  // Temperatura corrente do SA;
    int Status;          // Indica o estatus da execuo (0 -> concluda ou 1 -> interrompida).
    bool PodeReaquecer;  // Indica se o SA pode ser reaquecido ou no.

    TSimAnn();
    void PreencherAtributos(int, double, double, double, int, bool, bool);
    bool ValoresValidos();
    void EstadoInicial();
    void Reaquecer(double);
    void ExecutarED(TParPptED *, TPesosED *);
    void ExecutarEM(TEstruturaMes *, TParPptEM *, TPesosEM *);
    void LerPadrao();
    void LerDefault();
    void GravarPadrao();
    void Free();
};
//------------------------------------------------------------------------------

#endif
// ----------------------------------- FIM ---------------------------------- \\
