/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UResultados                        Tipo.......: .h
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar estruturas referentes aos resultados obtidos.
* Descrio................: Esta unit contm a "declarao" de uma classe
*                            (TResultado) referente aos atributos comuns para
*                            as ambas os resultados, de uma outra (TResultadoED)
*                            referente aos resultados da escala diria e de uma
*                            outra (TResultadoEM) referente aos resultados da
*                            escala mensal.
* Obs......................: O arquivo .cpp dessa unit possui a implementao de
*                            tudo que foi declarado aqui.
* Dependncias.............:
*     1) UEscDiaria
*     2) UEscMensal
*     3) UParPpt
*     4) USimAnn
*     5) UEstruturaMes
*******************************************************************************/

#ifndef UResultadosH
#define UResultadosH

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "system.hpp"

#include "UEscDiaria.h"
#include "UEscMensal.h"
#include "UParPpt.h"
#include "USimAnn.h"
#include "UEstruturaMes.h"
//------------------------------------------------------------------------------


/* =============================================================================
- Classe.....: TResultado
- Objetivo...: Possui os atributos e mtodos comuns aos resultados das escalas
               diria e mensal.
============================================================================= */
class TResultado{
  public:
    bool Valido;         // Indica se o resultado  vlido ou no.
    int NTrip;           // Nmero de tripulaes.
    int TmpTT;           // Tempo total de trabalho (minutos).
    int FTEJorn;         // Falta no tempo entre jornadas (< Tempo mn. entre jornadas).
    TDateTime TempoExec; // Tempo de execuo do SA.
    long int FncObj;     // Funo objetivo total.

    TResultado();
    void Free();
};
//------------------------------------------------------------------------------


/* =============================================================================
- Classe.....: TResultadoED
- Objetivo...: Possui os atributos e mtodos referentes ao resultado da escala
               diria.
============================================================================= */
class TResultadoED : public TResultado{
  private:
    void VerificarValidade(TEscDiaria *);

  public:
    int HExtra; // Total de horas extras (minutos).
    int TmpOc;  // Tempo ocioso total(minutos).
    int NTar;   // Nmero de tarefas.
    int NDP;    // Nmero total de duplas pegadas.
    int TmpSob; // Tempo total de sobreposio.
    int NTPPro; // N de trocas de pontos proibidas.
    int NTPPer; // N de trocas de pontos permitidas.
    int NTVei;  // N de trocas de veculos.
    int HExc;   // Total do tempo de trabalho que supera o tempo mx. de trabalho.
    int NTLPro; // N de trocas de linhas proibidas.
    int NTLPer; // N de trocas de linhas permitidas.

    TResultadoED();
    void CalcularResultado(TEscDiaria *, TParPptED *, TSimAnn *);
    void GravarResultado(TEscDiaria *, TParPptED *, TPesosED *, TSimAnn *, String);
};
//------------------------------------------------------------------------------


/* =============================================================================
- Classe.....: TResultadoEM
- Objetivo...: Possui os atributos e mtodos referentes ao resultado da escala
               mensal.
============================================================================= */
class TResultadoEM : public TResultado{
  private:
    void VerificarValidade(TEscMensal *, TParPptEM *);

  public:
    int NTrTipPeg;    // Nmero total de trocas de tipo de pegada.
    int NJorn;        // Nmero de jornadas.
    int TmpMedioTrab; // Tempo mdio de trabalho.
    int NTroPerTrab;  // Nmero total de trocas de perodo de trabalho.
    int DifMaxTMT;    // Maior diferena do tempo mdio de trabalho.
    int NJornDif;     // Nmero total de jornadas diferentes.

    TResultadoEM();
    void CalcularResultado(TEscMensal *, TParPptEM *, TSimAnn *);
    void GravarResultado(TParPptEM *, TPesosEM *, TSimAnn *, String);
};
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#endif
// ----------------------------------- FIM ---------------------------------- \\
