/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UResultado                       Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar estruturas referentes aos resultados obtidos.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TResultado) referente aos atributos comuns para
*                            as ambas os resultados, de uma outra (TResultadoED)
*                            referente aos resultados da escala diria e de uma
*                            outra (TResultadoEM) referente aos resultados da
*                            escala mensal.
* Obs......................: O arquivo .h dessa unit possui a declarao de
*                            tudo que foi implementado aqui.
* Dependncias.............:
*     1) UTripulacoes
*     2) UUtil
*******************************************************************************/

#pragma hdrstop

#include "UResultados.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
//------------------------------------------------------------------------------

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "stdio.h"
#include "vcl.h"

#include "UTripulacoes.h"
#include "UUtil.cpp"
//------------------------------------------------------------------------------

#define max(a, b)  (((a) > (b)) ? (a) : (b))

//------------------------------------------------------------------------------


                        // ----- CLASSE TResultado ----- \\

/* =============================================================================
- Mtodo.....: TResultado
- Objetivo...: Criar e inicializar o objeto TResultado.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TResultado::TResultado()
{
 Valido    = false;
 NTrip     = 0;
 TmpTT     = 0;
 TempoExec = 0;
 FncObj    = 0;
 FTEJorn   = 0;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Free
- Objetivo...: Destuir o objeto TResultado (ou filho).
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TResultado::Free()
{
 delete(this);
}
//------------------------------------------------------------------------------


                        // ----- CLASSE TResultadoED ----- \\

/* =============================================================================
- Mtodo.....: TResultadoED
- Objetivo...: Criar e inicializar o objeto TResultadoED.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TResultadoED::TResultadoED()
{
 TResultado::TResultado();
 HExtra    = 0;
 TmpOc  = 0;
 NTar   = 0;
 NDP    = 0;
 TmpSob = 0;
 NTPPro = 0;
 NTPPer = 0;
 NTVei  = 0;
 HExc   = 0;
 NTLPro = 0;
 NTLPer = 0;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: VerificarValidade
- Objetivo...: Verificar se o resultado obtido  vlido ou no.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) ED -> Objeto que contm a escala diria obtida.
============================================================================= */
void TResultadoED::VerificarValidade(TEscDiaria *ED)
{
 this->Valido = false;
 ED->Valida   = false;

 if ( (this->FTEJorn == 0) && (this->TmpSob == 0) && (this->NTPPro == 0) &&
      (this->NTLPro == 0) && (this->HExc == 0) )
   {
    if ( (ED->Tipo == 'U') || (this->NDP == 0) )
     {
      this->Valido = true;
      ED->Valida   = true;
     }
   }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcularResultado
- Objetivo...: Calcular o resultado obtido para a escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) ED  -> Objeto que contm a escala diria obtida.
     2) PED -> Objeto que contm os parmetros para a escala diria.
     3) SA  -> Objeto que contm os parmetros do Simulated Annealing.
============================================================================= */
void TResultadoED::CalcularResultado(TEscDiaria *ED, TParPptED *PED, TSimAnn *SA)
{
 TTripED *T;

 for(int i = 0; i < ED->LstTripulacoes->Count; i++)
  {
   T = (TTripED *)ED->LstTripulacoes->Items[i];

   if (T->NTarefas != 0)
    NTrip++;

   HExtra = HExtra + T->HExtra;
   TmpTT  = TmpTT  + T->TmpTTrabalho;

   if (T->NTarefas != 0)
    FTEJorn = FTEJorn + max(0, PED->TmpMinEntJorn - T->TmpEJornadas);

   TmpOc  = TmpOc  + T->TmpOcioso;
   NTar   = NTar   + T->NTarefas;
   NDP    = NDP    + T->NDPegadas;
   TmpSob = TmpSob + T->TmpSobreposicao;
   NTPPro = NTPPro + T->NTPProibidas;
   NTPPer = NTPPer + T->NTPPermitidas;
   NTVei  = NTVei  + T->NTVeiculos;
   HExc   = HExc   + max(0, T->TmpTTrabalho - PED->TmpMaxTrab);
   NTLPro = NTLPro + T->NTLProibidas;
   NTLPer = NTLPer + T->NTLPermitidas;
  }
 TempoExec = SA->TempoExec;
 FncObj    = ED->FncObjTotal;

 this->VerificarValidade(ED);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: GravarResultado
- Objetivo...: Gravar o resultado obtido (escala diria) nos arquivos
               "ResDU.txt" ou "ResDF.txt" ou "ResSab.txt".
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) ED  -> Objeto que contm os a escala diria.
     2) PED -> Objeto que contm os parmetros para a escala diria.
     3) P   -> Objeto que contm os pesos para a escala diria.
     4) SA  -> Objeto que contm os parmetros do Simulated Annealing.
     5) Dir -> Diretrio de destino do arquivo gravado.
============================================================================= */
void TResultadoED::GravarResultado(TEscDiaria * ED, TParPptED *PED, TPesosED *P,
                                   TSimAnn *SA, String Dir)
{
 String Diretorio, Tipo, Arquivo;
 if (ED->Tipo == 'U')
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Resultados\\ResDU.txt";
   Tipo = "Dias teis";
   Arquivo = "ResDU.txt";
  }
 else if (ED->Tipo == 'D')
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Resultados\\ResDF.txt";
   Tipo = "Domingos e feriados";
   Arquivo = "ResDF.txt";
  }
 else
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Resultados\\ResSab.txt";
   Tipo = "Sbados";
   Arquivo = "ResSab.txt";
  }
 if (Dir == "")
  Dir = Diretorio;

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "w");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg("O arquivo "+ Arquivo + " no pode ser aberto!",
              mtError, TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   String CTC = "false";
   String CTM = "false";

   if (SA->CPtprCong)
    CTC = "true";
   if (SA->CPtmMaxProc)
    CTM = "true";

   char separador1[60] =
   "===========================================================";
   char separador2[60] =
   "-----------------------------------------------------------";

   fprintf(Arq, "\n\t\t%s%s\n\n\n", "ESCALA DIRIA - ", Tipo);

   fprintf(Arq,"%s\n\t\t%s\n%s\n%s%d\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s\n\n\n",
           separador1,"Simulated Annealing",separador1,
           "N mximo de iteraes.......: ",SA->NumMaxIte,
           "Taxa de resfriamento.........: ",FloatToStr(SA->TxResf),
           "Temperatura inicial..........: ",FloatToStr(SA->TprInic),
           "Temperatura de congelamento..: ",FloatToStr(SA->TprCong),
           "Tempo mximo de processamento: ",MinuteToStr(SA->TmpMaxProc),
           "Crit. de parada (TC).........: ",CTC,
           "Crit. de parada (TMP)........: ",CTM,
           separador2);

   fprintf(Arq, "%s\n\t\t%s\n%s\n%s%d\n%s%d\n%s%d\n%s%d\n%s%d\n%s%d\n%s%d\n%s%d\n%s%d\n%s%d\n%s%d\n%s%d\n%s\n\n\n",
           separador1,"Penalizaes",separador1,
           "Para falta de tempo entre jornadas.........: ",P->PTEJornadas,
           "Para o nmero de tripulaes...............: ",P->PNumTrip,
           "Para o tempo ocioso........................: ",P->PTOcioso,
           "Para o tempo total de trabalho.............: ",P->PTTTrabalho,
           "Para as horas extras.......................: ",P->PHExtra,
           "Para o tempo de sobreposio...............: ",P->PTSobreposicao,
           "Para o n de trocas de ponto proibidas.....: ",P->PTPProibidas,
           "Para o n de trocas de ponto permitidas....: ",P->PTPPermitidas,
           "Para o n de trocas de linha proibidas.....: ",P->PTLProibidas,
           "Para o n de trocas de linha permitidas....: ",P->PTLPermitidas,
           "Para o n de trocas de veculos............: ",P->PTVeiculos,
           "Para o n mx. de tripulaes com d. pegada: ",P->PNMaxTripDP,
           separador2);

   fprintf(Arq, "%s\n\t\t%s\n%s\n%s%d\n%s%s\n%s%s\n%s%d\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s\n\n\n",
           separador1,"Parmetros do PPT",separador1,
           "Nmero de tripulaes...............................: ",PED->NTrip,
           "Tempo mn. entre jornadas...........................: ",MinuteToStr(PED->TmpMinEntJorn),
           "Tempo de troca de tripulao........................: ",MinuteToStr(PED->TmpTrocaTrip),
           "N mximo de tripulaes com d. pegada..............: ",PED->NMaxTripDP,
           "Intervalo total para repouso e/ou alimentao.......: ",MinuteToStr(PED->IntTotRepAli),
           "Sub-intervalo contnuo para repouso e/ou alimentao: ",MinuteToStr(PED->SubIntContRA),
           "Tempo mximo de trabalho............................: ",MinuteToStr(PED->TmpMaxTrab),
           "Tempo normal de trabalho............................: ",MinuteToStr(PED->TmpNormalTrab),
           "Tempo que indica dupla pegada.......................: ",MinuteToStr(PED->TmpDPegada),
           separador2);

   fprintf(Arq,"%s\n\t%s\n%s\n%s%d\n%s%d\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%d\n%s%d\n%s%d\n%s%d\n%s%d\n%s%d\n%s%d\n%s%s\n%s",
           separador1,"Resultado encontrado para a escala diria",separador1,
           "Nmero de tripulaes............: ", this->NTrip,
           "Nmero de tarefas................: ", this->NTar,
           "Tempo total trabalhado...........: ", MinuteToStr(this->TmpTT),
           "Tempo que falta entre as jornadas: ", MinuteToStr(this->FTEJorn),
           "Tempo total de sobreposio......: ", MinuteToStr(this->TmpSob),
           "Horas excedentes.................: ", MinuteToStr(this->HExc),
           "Hora extra total.................: ", MinuteToStr(this->HExtra),
           "Tempo ocioso total...............: ", MinuteToStr(this->TmpOc),
           "N de tripulaes com d. pegada..: ", this->NDP,
           "N de trocas de veculos.........: ", this->NTVei,
           "N de trocas de ponto proibidas..: ", this->NTPPro,
           "N de trocas de ponto permitidas.: ", this->NTPPer,
           "N de trocas de linha proibidas..: ", this->NTLPro,
           "N de trocas de linha permitidas.: ", this->NTLPer,
           "Funo objetivo total............: ", this->FncObj,
           "Tempo de execuo do SA..........: ", this->TempoExec.TimeString(),
           separador2);
  }

 fclose(Arq);

 char *DDestino = new char[ Dir.Length() + 1 ];
 strcpy(DDestino, Dir.c_str());
 char *DOrigem = new char[ Diretorio.Length() + 1 ];
 strcpy(DOrigem, Diretorio.c_str());

 CopyFile(DOrigem, DDestino, false);
}
//------------------------------------------------------------------------------


                        // ----- CLASSE TResultadoEM ----- \\

/* =============================================================================
- Mtodo.....: TResultadoEM
- Objetivo...: Criar e inicializar o objeto TResultadoEM.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TResultadoEM::TResultadoEM()
{
 TResultado::TResultado();
 NTrTipPeg    = 0;
 NJorn        = 0;
 TmpMedioTrab = 0;
 NTroPerTrab  = 0;
 DifMaxTMT    = 0;
 NJornDif     = 0;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: VerificarValidade
- Objetivo...: Verificar se o resultado obtido  vlido ou no.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) EM  -> Objeto que contm a escala mensal obtida.
     2) PEM -> Objeto que contm os parmetros para a escala mensal.
============================================================================= */
void TResultadoEM::VerificarValidade(TEscMensal *EM, TParPptEM *ParEM)
{
 this->Valido = true;
 EM->Valida   = true;

 TTripEM *TM;
 TDias *D;
 int ExcDifTMT;
 int DTMT;

 if (this->FTEJorn != 0)
  {
   this->Valido = false;
   EM->Valida   = false;
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcularResultado
- Objetivo...: Calcular o resultado obtido para a escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) EM  -> Objeto que contm a escala mensal obtida.
     2) PEM -> Objeto que contm os parmetros para a escala mensal.
     3) SA  -> Objeto que contm os parmetros do Simulated Annealing.
============================================================================= */
void TResultadoEM::CalcularResultado(TEscMensal *EM, TParPptEM *PEM, TSimAnn *SA)
{
 TTripEM *TM;
 TDias *D;
 int DTMT;

 for(int i = 0; i < EM->LstTripulacoes->Count; i++)
  {
   TM = (TTripEM *)EM->LstTripulacoes->Items[i];
   NTrip++;
   TmpTT       = TmpTT       + TM->TmpTTrabalho;
   FTEJorn     = FTEJorn     + TM->TmpEJornadas;
   NTrTipPeg   = NTrTipPeg   + TM->NumTrocaTipPeg;
   NTroPerTrab = NTroPerTrab + TM->NumTroPerTrab;
   NJornDif    = NJornDif    + TM->NumJornDif;

   DTMT = EM->TmpMedioTrab - TM->TmpTTrabalho;
   if (DTMT < 0)
    DTMT = DTMT * (-1);
   if (DifMaxTMT < DTMT)
    DifMaxTMT = DTMT;

   for (int j = 0; j < TM->LstDias->Count; j++)
    {
     D = (TDias *)TM->LstDias->Items[j];
     if (D->Numero != -1)
      NJorn = NJorn + D->Qtd;
    }
  }

 TmpMedioTrab = EM->TmpMedioTrab;
 TempoExec    = SA->TempoExec;
 FncObj       = EM->FncObjTotal;

 this->VerificarValidade(EM, PEM);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: GravarResultado
- Objetivo...: Gravar o resultado obtido (escala mensal) no arquivo "ResEM.txt".
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) PEM -> Objeto que contm os parmetros para a escala mensal.
     2) P   -> Objeto que contm os pesos para a escala mensal.
     3) SA  -> Objeto que contm os parmetros do Simulated Annealing.
     4) Dir -> Diretrio de destino do arquivo gravado.
============================================================================= */
void TResultadoEM::GravarResultado(TParPptEM *PEM, TPesosEM *P, TSimAnn *SA,
                                   String Dir)
{
 String Diretorio = ExtractFilePath(Application->ExeName) + "\\Resultados\\ResEM.txt";
 if (Dir == "")
  Dir = Diretorio;

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "w");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg("O arquivo ResEM.txt no pode ser aberto!", mtError,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   String CTC = "false";
   String CTM = "false";

   if (SA->CPtprCong)
    CTC = "true";
   if (SA->CPtmMaxProc)
    CTM = "true";

   char separador1[60] =
   "===========================================================";
   char separador2[60] =
   "-----------------------------------------------------------";

   fprintf(Arq, "\n\t\t\t%s\n\n\n", "ESCALA MENSAL");

   fprintf(Arq,"%s\n\t\t%s\n%s\n%s%d\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s\n\n\n",
           separador1,"Simulated Annealing",separador1,
           "N mximo de iteraes.......: ",SA->NumMaxIte,
           "Taxa de resfriamento.........: ",FloatToStr(SA->TxResf),
           "Temperatura inicial..........: ",FloatToStr(SA->TprInic),
           "Temperatura de congelamento..: ",FloatToStr(SA->TprCong),
           "Tempo mximo de processamento: ",MinuteToStr(SA->TmpMaxProc),
           "Crit. de parada (TC).........: ",CTC,
           "Crit. de parada (TMP)........: ",CTM,
           separador2);

   fprintf(Arq, "%s\n\t\t%s\n%s\n%s%d\n%s%d\n%s%d\n%s%d\n%s%d\n%s\n\n\n",
           separador1,"Penalizaes",separador1,
           "Para falta de tempo entre jornadas........: ",P->PTEJornadas,
           "Para o tempo mdio trabalhado.............: ",P->PTMedioTrab,
           "Para o n de jornadas diferentes..........: ",P->PNJorD,
           "Para o n de trocas de tipo de pegada.....: ",P->PNTTPeg,
           "Para o n de trocas de perodo de trabalho: ",P->PNTPTrab,
           separador2);

   fprintf(Arq, "%s\n\t\t%s\n%s\n%s%s\n%s%s\n%s%s\n%s\n\n\n",
           separador1,"Parmetros do PPT",separador1,
           "Tempo mn. entre jornadas....................: ",MinuteToStr(PEM->TmpMinEntJorn),
           "Maior diferena do tempo mdio de trabalho...: ",MinuteToStr(PEM->DifTMT),
           "Horrio limite para troca do per. de trabalho: ",MinuteToStr(PEM->HorLTPTrab),
           separador2);

   fprintf(Arq,"%s\n\t%s\n%s\n%s%d\n%s%d\n%s%s\n%s%s\n%s%s\n%s%s\n%s%d\n%s%d\n%s%d\n%s%d\n%s%s\n%s",
           separador1,"Resultado encontrado para a escala mensal",separador1,
           "Nmero de tripulaes.....................: ", this->NTrip,
           "N de jornadas............................: ", this->NJorn,
           "Tempo total trabalhado....................: ", MinuteToStr(this->TmpTT),
           "Tempo que falta entre as jornadas.........: ", MinuteToStr(this->FTEJorn),
           "Tempo mdio de trabalho...................: ", MinuteToStr(this->TmpMedioTrab),
           "Maior diferena do tempo mdio de trabalho: ", MinuteToStr(this->DifMaxTMT),
           "Nmero total de jornadas diferentes.......: ", this->NJornDif,
           "N total de trocas de tipo de pegada......: ", this->NTrTipPeg,
           "N total de trocas do per. de trabalho....: ", this->NTroPerTrab,
           "Funo objetivo total.....................: ", this->FncObj,
           "Tempo de execuo do SA...................: ", this->TempoExec.TimeString(),
           separador2);
  }

 fclose(Arq);

 char *DDestino = new char[ Dir.Length() + 1 ];
 strcpy(DDestino, Dir.c_str());
 char *DOrigem = new char[ Diretorio.Length() + 1 ];
 strcpy(DOrigem, Diretorio.c_str());

 CopyFile(DOrigem, DDestino, false);
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
