/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UProgVei                         Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Representar a programao de veculos.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TProgVei) referente  programao de veculos.
* Obs......................: O arquivo .h dessa unit possui a declarao de
*                            tudo que foi implementado aqui.
* Dependncias.............:
*     1) UTar_Jorn
*     2) UTripulacoes
*     3) UUtil
*******************************************************************************/

#pragma hdrstop

#include "UProgVei.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
//------------------------------------------------------------------------------

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "stdio.h"

#include "UTar_Jorn.h"
#include "UTripulacoes.h"
#include "UUtil.cpp"
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: TProgVei
- Objetivo...: Construtor; Criar a lista de tarefas.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TProgVei::TProgVei()
{
 LstTarefas = new TList();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: IniciarLinhas
- Objetivo...: Adicionar todas as linhas da escala diria recebida ao mesmo grupo.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) ED -> Objeto que representa uma escala diria.
============================================================================= */
void TProgVei::IniciarLinhas(TEscDiaria **ED)
{
 TTarefa *T;
 TTripED *Trip;
 TEscDiaria *E = *ED;

 for (int i = 0; i < E->LstTripulacoes->Count; i++)
  {
   Trip = (TTripED *)E->LstTripulacoes->Items[i];
   for (int j = 0; j < Trip->LstTarefas->Count; j++)
    {
     T = (TTarefa *)Trip->LstTarefas->Items[j];
     T->LinIni = T->LinIni + ".0";
     T->LinFin = T->LinFin + ".0";
    }
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: GetLinhas
- Objetivo...: Retornar todas as linhas contidas na escala diria recebida.
- Retorno....: Lista com as linhas (String).
- Parmetros.:
     1) ED -> Objeto que representa uma escala diria.
============================================================================= */
TStringList *TProgVei::GetLinhas(TEscDiaria *ED)
{
 TTarefa *T;
 TTripED *Trip;
 String Linha;
 bool EstaCadastrada = false;

 TStringList *Lst = new TStringList();

 for (int i = 0; i < ED->LstTripulacoes->Count; i++)
  {
   Trip = (TTripED *)ED->LstTripulacoes->Items[i];
   for (int j = 0; j < Trip->LstTarefas->Count; j++)
    {
     T = (TTarefa *)Trip->LstTarefas->Items[j];

     EstaCadastrada = false;
     for (int k = 0; k < Lst->Count; k++)
      {
       Linha = Lst->Strings[k];
       if (getLinha(T->LinIni) == Linha)
        EstaCadastrada = true;
      }
     if (!EstaCadastrada)
      Lst->Add(getLinha(T->LinIni));

     EstaCadastrada = false;
     for (int k = 0; k < Lst->Count; k++)
      {
       Linha = Lst->Strings[k];
       if (getLinha(T->LinFin) == Linha)
        EstaCadastrada = true;
      }
     if (!EstaCadastrada)
      Lst->Add(getLinha(T->LinFin));
    }
  }
 return Lst;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: AdicionarGrupo
- Objetivo...: Adicionar os grupos s linhas da lista de tarefas recebida.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) ED        -> Objeto que representa uma escala diria.
     2) LstLinhas -> Lista com linhas (String).
     3) Grupo     -> Grupo das linhas da lista (int).
============================================================================= */
void TProgVei::AdicionarGrupo(TEscDiaria **ED, TStringList *LstLinhas, int Grupo)
{
 String Linha;
 TTarefa *T;
 TTripED *Trip;
 TEscDiaria *E = *ED;

 for (int i = 0; i < LstLinhas->Count; i++)
  {
   Linha = LstLinhas->Strings[i];
   for (int j = 0; j < E->LstTripulacoes->Count; j++)
    {
     Trip = (TTripED *)E->LstTripulacoes->Items[j];
     for (int k = 0; k < Trip->LstTarefas->Count; k++)
      {
       T = (TTarefa *)Trip->LstTarefas->Items[k];
       if (getLinha(T->LinIni) == Linha)
        {
         T->LinIni = getLinha(T->LinIni);
         T->LinIni = T->LinIni + "." + IntToStr(Grupo);
        }
       if (getLinha(T->LinFin) == Linha)
        {
         T->LinFin = getLinha(T->LinFin);
         T->LinFin = T->LinFin + "." + IntToStr(Grupo);
        }
      }
    }
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CriarLstTarefas
- Objetivo...: Criar o arquivo .tsk a partir do .vei e retornar uma lista com as
               tarefas do arquivo .vei.
- Retorno....: Lista de tarefas (TList).
- Parmetros.:
     1) PED  -> Objeto que contm os parmetros para a escala diria.
     2) Path -> Diretrio do arquivo que contm a programao de veculos.
============================================================================= */
void TProgVei::CriarLstTarefas(TParPptED *PED, String Path)
{
 int j;
 int aux1 = 0;
 int aux2 = 0;
 char aux_char[6] = "Linha";
 char aux_char1[76] =
 "----------------------------------------------------------------------------";
 char aux_char2[4] = "FIM";
 char line[150];
 char line1[150];
 char line2[150];
 int numvia, ponini, ponfim, horini, minini, horfim;
 int minfim, viamor, temter, linha;
 int temini, temfim, folacu;
 int pontoinicial, pontofinal, tempoinicial, tempofinal, folgaacumulada;
 int linhainicial, linhafinal;

 char *FilePath = new char[ Path.Length() + 1 ];
 strcpy(FilePath, Path.c_str());

 FILE *pv;
 pv = fopen(FilePath, "r");
 delete(FilePath);

 if(!pv)
  {
   Beep();
   MessageDlg("O arquivo da programao de veculos (.vei) no pode ser aberto!",
              mtError, TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   j = 0;
   do
    {
     do
      {
       fscanf(pv,"%s",&line);
      }while(strncmp(line, aux_char,7));
     fscanf(pv,"%s",&line);
     j++;
     do
      {
       folacu = 0;
       fscanf(pv, "%d\t%d\t%d:%d\t%d\t%d:%d\t%d\t%d\t%d", &numvia, &ponini,
              &horini, &minini, &ponfim, &horfim, &minfim, &viamor, &temter,
              &linha);
       pontoinicial = ponini;

       if(pontoinicial == 0)
        aux1 = ponfim;
       else
        aux1 = ponini;

       temini = horini*60 + minini;
       tempoinicial = temini;
       linhainicial = linha;

       temfim = horfim*60 + minfim;


       if(temter < PED->TmpTrocaTrip || pontoinicial != ponfim)
        {
         do
          {
           if(temter == -1)
            temter = aux2;

           folacu = folacu + temter;
           fgets(line1, 150 , pv);
           fscanf(pv, "%d\t%d\t%d:%d\t%d\t%d:%d\t%d\t%d\t%d", &numvia, &ponini,
                  &horini, &minini, &ponfim, &horfim, &minfim, &viamor, &temter,
                  &linha);

           temfim = horfim*60 + minfim;

           if(temter >= PED->TmpTrocaTrip && ponfim != aux1)
            {
             aux2 = temter;
             temter = -1;
            }
           if(numvia == 0)
            {
             temter = PED->TmpTrocaTrip;
             fscanf(pv,"%s",&line1);
             fscanf(pv,"%s",&line1);
            }
          }while(temter < PED->TmpTrocaTrip);
        }// if
       pontofinal = ponfim;
       tempofinal = temfim;
       linhafinal = linha;
       folgaacumulada = folacu;

       TTarefa *T = new TTarefa();

       T->PreencherAtributos(tempoinicial, tempofinal, IntToStr(linhainicial),
                             IntToStr(linhafinal), j, pontoinicial, pontofinal,
                             folgaacumulada);
       this->LstTarefas->Add(T);

       fgets(line, 150 , pv);
      }while(strncmp(line1, aux_char1,7));
     fscanf(pv,"%s",&line2);
    }while(strncmp(line2, aux_char2,5));
  }

 fclose(pv);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Free
- Objetivo...: Destuir o objeto TProgVei e suas listas de tarefas e de linhas.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TProgVei::Free()
{
 for (int i = 0; i < this->LstTarefas->Count; i++)
  delete(this->LstTarefas->Items[i]);
 delete(this->LstTarefas);
 delete(this);
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
