/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UPesos                             Tipo.......: .h
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Representar as penalizaes.
* Descrio................: Esta unit contm a "declarao" de uma classe
*                            (TPesos) referente aos pesos comuns para ambas as
*                            escalas, de uma outra (TPesosED) referente aos pesos
*                            para a escala diria e de uma outra (TPesosEM)
*                            referente aos pesos da escala mensal.
* Obs......................: O arquivo .cpp dessa unit possui a implementao de
*                            tudo que foi declarado aqui.
* Dependncias.............: <--- NENHUMA --->
*******************************************************************************/

#ifndef UPesosH
#define UPesosH

/* =============================================================================
- Classe.....: TPesos
- Objetivo...: Possui os atributos e mtodos referentes s penalizaes (Pesos)
               comuns s escalas diria e mensal.
============================================================================= */
class TPesos{
  public:
    int PTEJornadas; // Peso para falta de tempo entre jornadas.

    TPesos();
    void PreencherAtributos(int);
    void Free();
};
//------------------------------------------------------------------------------

/* =============================================================================
- Classe.....: TPesosED
- Objetivo...: Possui os atributos e mtodos referentes s penalizaes (Pesos)
               da escala diria.
============================================================================= */
class TPesosED : public TPesos{
  private:
    void SelecionarArquivo(char);

  public:
    int PNumTrip;       // Peso para o nmero de tripulaes.
    int PTOcioso;       // Peso para tempo ocioso.
    int PTTTrabalho;    // Peso para excesso no tempo total de trabalho.
    int PHExtra;        // Peso para hora extra.
    int PTSobreposicao; // Peso para tempo de sobreposio.
    int PTPProibidas;   // Peso para trocas de ponto proibidas.
    int PTPPermitidas;  // Peso para trocas de ponto permitidas.
    int PTLProibidas;   // Peso para trocas de linha proibidas.
    int PTLPermitidas;  // Peso para trocas de linha permitidas.
    int PTVeiculos;     // Peso para trocas de veculos.
    int PNMaxTripDP;    // Peso para excesso de tripulaes com duplas pegadas.

    TPesosED();
    void PreencherAtributos(int, int, int, int, int, int, int, int, int, int, int, int);
    bool ValoresValidos();
    void LerPadrao();
    void LerDefault();
    void GravarPadrao();
};
//------------------------------------------------------------------------------


/* =============================================================================
- Classe.....: TPesosEM
- Objetivo...: Possui os atributos e mtodos referentes s penalizaes (Pesos)
               da escala mensal.
============================================================================= */
class TPesosEM : public TPesos{
  private:
    void SelecionarArquivo(char);

  public:
    int PTMedioTrab; // Peso para o excesso na diferena do tempo mdio de trabalho.
    int PNJorD;      // Peso para o nmero de jornadas diferentes.
    int PNTTPeg;     // Peso para o nmero de trocas de tipos de pegada.
    int PNTPTrab;    // Peso para o nmero de trocas de perodo de trabalho.

    TPesosEM();
    void PreencherAtributos(int, int, int, int, int);
    bool ValoresValidos();
    void LerPadrao();
    void LerDefault();
    void GravarPadrao();
};
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#endif
// ----------------------------------- FIM ---------------------------------- \\
