/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UPesos                           Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Representar as penalizaes.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TPesos) referente aos pesos comuns para ambas as
*                            escalas, de uma outra (TPesosED) referente aos pesos
*                            para a escala diria e de uma outra (TPesosEM)
*                            referente aos pesos da escala mensal.
* Obs......................: O arquivo .h dessa unit possui a declarao de
*                            tudo que foi implementado aqui.
* Dependncias.............: <--- NENHUMA --->
*******************************************************************************/

#pragma hdrstop

#include "UPesos.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
//------------------------------------------------------------------------------

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "stdio.h"
#include "vcl.h"
//------------------------------------------------------------------------------


                        // ----- CLASSE TPesos ----- \\

/* =============================================================================
- Mtodo.....: TPesos
- Objetivo...: Criar e inicializar o objeto TPesos.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TPesos::TPesos()
{
 PTEJornadas = 0;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherAtributos
- Objetivo...: Preencher os valores do objeto com os valores recebidos.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) TEJ -> Peso para a falta no tempo entre jornadas.
============================================================================= */
void TPesos::PreencherAtributos(int TEJ)
{
 PTEJornadas = TEJ;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Free
- Objetivo...: Destuir o objeto TPesos (ou filho).
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TPesos::Free()
{
 delete(this);
}
//------------------------------------------------------------------------------


                        // ----- CLASSE TPesosED ----- \\

/* =============================================================================
- Mtodo.....: TPesosED
- Objetivo...: Criar e inicializar o objeto TPesosED.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TPesosED::TPesosED()
{
 TPesos::TPesos();
 PNumTrip       = 0;
 PTOcioso       = 0;
 PTTTrabalho    = 0;
 PHExtra        = 0;
 PTSobreposicao = 0;
 PTPProibidas   = 0;
 PTPPermitidas  = 0;
 PTLProibidas   = 0;
 PTLPermitidas  = 0;
 PTVeiculos     = 0;
 PNMaxTripDP    = 0;

 this->LerPadrao();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherAtributos
- Objetivo...: Preencher os valores do objeto com os valores recebidos.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) TEJ   -> Peso para a falta no tempo entre jornadas.
   2) NT    -> Peso para o nmero de tripulaes.
   3) TO    -> Peso para o tempo ocioso.
   4) TTT   -> Peso para excesso no tempo total de trabalho.
   5) HE    -> Peso para hora extra.
   6) TS    -> Peso para tempo de sobreposio.
   7) TPPro -> Peso para trocas de ponto proibidas.
   8) TPPer -> Peso para trocas de ponto permitidas.
   9) TLPro -> Peso para trocas de linha proibidas.
  10) TLPer -> Peso para trocas de linha permitidas.
  11) NTV   -> Peso para trocas de veculos.
  12) NTDP  -> Peso para excesso de tripulaes com duplas pegadas.
============================================================================= */
void TPesosED::PreencherAtributos(int TEJ, int NT, int TO, int TTT, int HE,
                                  int TS, int TPPro, int TPPer, int TLPro,
                                  int TLPer, int NTV, int NTDP)
{
 TPesos::PreencherAtributos(TEJ);
 PNumTrip       = NT;
 PTOcioso       = TO;
 PTTTrabalho    = TTT;
 PHExtra        = HE;
 PTSobreposicao = TS;
 PTPProibidas   = TPPro;
 PTPPermitidas  = TPPer;
 PTLProibidas   = TLPro;
 PTLPermitidas  = TLPer;
 PTVeiculos     = NTV;
 PNMaxTripDP    = NTDP;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ValoresValidos
- Objetivo...: Verificar os valores do objeto.
- Retorno....: true/false (bool)
- Parmetros.: <-- Nenhum -->
============================================================================= */
bool TPesosED::ValoresValidos()
{
 if ( ((TPesos *)PTEJornadas >= 0) && (this->PNumTrip >= 0) && (this->PTOcioso >= 0) &&
      (this->PTTTrabalho >= 0) && (this->PHExtra >= 0) && (this->PTSobreposicao >= 0) &&
      (this->PTPProibidas >= 0) && (this->PTPPermitidas >= 0) && (this->PTLProibidas >= 0) &&
      (this->PTLPermitidas >= 0) && (this->PTVeiculos >= 0) && (this->PNMaxTripDP >= 0) )
   return true;
 else
   return false;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: SelecionarArquivo
- Objetivo...: Ler os valores do objeto a partir do arquivo correto.
- Retorno....: <-- Nenhum -->
- Parmetros.: Tipo -> 'D'- Default   |  'P'- Padro.
============================================================================= */
void TPesosED::SelecionarArquivo(char Tipo)
{
 String Diretorio, Msg;
 if (Tipo == 'P')
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\Pesos_ED.par";
   Msg = "O arquivo 'Pesos_ED.par' no pode ser aberto!";
  }
 else
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\PPT.dft";
   Msg = "O arquivo 'PPT.dft' no pode ser aberto!";
  }

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "r");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg(Msg, mtError, TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   char P[100];
   char *Par = "PED";

   do
    {
     fscanf(Arq, "%s", &P);
    }while (strncmp(Par, P, 4));

   fscanf(Arq, "%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d", &this->PTEJornadas,
          &this->PNumTrip, &this->PTOcioso, &this->PTTTrabalho, &this->PHExtra,
          &this->PTSobreposicao, &this->PTPProibidas, &this->PTPPermitidas,
          &this->PTLProibidas, &this->PTLPermitidas, &this->PTVeiculos,
          &this->PNMaxTripDP);
  }

 fclose(Arq);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LerPadrao
- Objetivo...: Ler os valores do objeto a partir do arquivo Pesos_ED.par.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TPesosED::LerPadrao()
{
 SelecionarArquivo('P');
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LerPadrao
- Objetivo...: Ler os valores do objeto a partir do arquivo PPT.dft.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TPesosED::LerDefault()
{
 SelecionarArquivo('D');
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: GravarPadrao
- Objetivo...: Gravar os valores do objeto no arquivo Pesos_ED.par.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TPesosED::GravarPadrao()
{
 String Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\Pesos_ED.par";

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "w");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg("O arquivo Pesos_ED.par no pode ser aberto!", mtError,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   fprintf(Arq, "%s\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d", "PED",
           this->PTEJornadas, this->PNumTrip, this->PTOcioso, this->PTTTrabalho,
           this->PHExtra, this->PTSobreposicao, this->PTPProibidas, this->PTPPermitidas,
           this->PTLProibidas, this->PTLPermitidas, this->PTVeiculos, this->PNMaxTripDP);
  }

 fclose(Arq);
}
//------------------------------------------------------------------------------


                        // ----- CLASSE TPesosEM ----- \\

/* =============================================================================
- Mtodo.....: TPesosEM
- Objetivo...: Criar e inicializar o objeto TPesosEM.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TPesosEM::TPesosEM()
{
 TPesos::TPesos();
 PTMedioTrab = 0;
 PNJorD      = 0;
 PNTTPeg     = 0;
 PNTPTrab    = 0;

 this->LerPadrao();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherAtributos
- Objetivo...: Preencher os valores do objeto com os valores recebidos.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) TEJ   -> Peso para a falta no tempo entre jornadas.
   2) TMT   -> Peso para o excesso na diferena do tempo mdio de trabalho.
   3) NJ    -> Peso para o nmero de jornadas diferentes.
   4) TTP   -> Peso para o nmero de trocas de tipos de pegada.
   5) TPT   -> Peso para o nmero de trocas de perodo de trabalho.
============================================================================= */
void TPesosEM::PreencherAtributos(int TEJ, int TMT, int NJ, int TTP, int TPT)
{
 TPesos::PreencherAtributos(TEJ);
 PTMedioTrab = TMT;
 PNJorD      = NJ;
 PNTTPeg     = TTP;
 PNTPTrab    = TPT;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ValoresValidos
- Objetivo...: Verificar os valores do objeto.
- Retorno....: true/false (bool)
- Parmetros.: <-- Nenhum -->
============================================================================= */
bool TPesosEM::ValoresValidos()
{
 if ( ((TPesos *)PTEJornadas >= 0) && (this->PTMedioTrab >= 0) &&
       (this->PNJorD >= 0) && (this->PNTTPeg >= 0) && (this->PNTPTrab >= 0) )
   return true;
 else
   return false;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: SelecionarArquivo
- Objetivo...: Ler os valores do objeto a partir do arquivo correto.
- Retorno....: <-- Nenhum -->
- Parmetros.: Tipo -> 'D'- Default   |  'P'- Padro.
============================================================================= */
void TPesosEM::SelecionarArquivo(char Tipo)
{
 String Diretorio, Msg;
 if (Tipo == 'P')
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\Pesos_EM.par";
   Msg = "O arquivo 'Pesos_EM.par' no pode ser aberto!";
  }
 else
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\PPT.dft";
   Msg = "O arquivo 'PPT.dft' no pode ser aberto!";
  }

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "r");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg(Msg, mtError, TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   char P[100];
   char *Par = "PEM";

   do
    {
     fscanf(Arq, "%s", &P);
    }while (strncmp(Par, P, 4));

    fscanf(Arq, "%d\t%d\t%d\t%d\t%d", &this->PTEJornadas, &this->PTMedioTrab,
           &this->PNJorD, &this->PNTTPeg, &this->PNTPTrab);
  }

 fclose(Arq);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LerPadrao
- Objetivo...: Ler os valores do objeto a partir do arquivo Pesos_EM.par.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TPesosEM::LerPadrao()
{
 SelecionarArquivo('P');
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LerPadrao
- Objetivo...: Ler os valores do objeto a partir do arquivo PPT.dft.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TPesosEM::LerDefault()
{
 SelecionarArquivo('D');
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: GravarPadrao
- Objetivo...: Gravar os valores do objeto no arquivo Pesos_EM.par.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TPesosEM::GravarPadrao()
{
 String Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\Pesos_EM.par";

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "w");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg("O arquivo 'Pesos_EM.par' no pode ser aberto!", mtError,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   fprintf(Arq, "%s\t%d\t%d\t%d\t%d\t%d", "PEM", this->PTEJornadas, this->PTMedioTrab,
           this->PNJorD, this->PNTTPeg, this->PNTPTrab);
  }

 fclose(Arq);
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
