/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UParPpt                            Tipo.......: .h
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Representar os parmetros da programao da
*                            tripulao.
* Descrio................: Esta unit contm a "declarao" de uma classe
*                            (TParPpt) referente aos parmetros comuns para
*                            ambas as escalas, de uma outra (TParPptED) referente
*                            aos parmetros para a escala diria e de uma outra
*                            (TParPptEM) referente aos parmetros da escala mensal.
* Obs......................: O arquivo .cpp dessa unit possui a implementao de
*                            tudo que foi declarado aqui.
* Dependncias.............: <--- NENHUMA --->
*******************************************************************************/

#ifndef UParPptH
#define UParPptH

/* =============================================================================
- Classe.....: TParPpt
- Objetivo...: Possui os atributos e mtodos comuns referentes aos parmetros
               das escalas diria e mensal.
============================================================================= */
class TParPpt{
  public:
    int TmpMinEntJorn; // Tempo mnimo entre as jornadas.

    TParPpt();
    void PreencherAtributos(int);
    void Free();
};
//------------------------------------------------------------------------------


/* =============================================================================
- Classe.....: TParPptED
- Objetivo...: Possui os atributos e mtodos referentes aos parmetros da escala
               diria das tripulaes.
============================================================================= */
class TParPptED : public TParPpt{
  private:
    void SelecionarArquivo(char);

  public:
    int NTrip;         // Nmero de tripulaes.
    int TmpTrocaTrip;  // Tempo de troca de tripulao (min).
    int NMaxTripDP;    // Nmero mximo de tripulaes com duplas pegadas.
    int IntTotRepAli;  // Intervalo total para repouso e/ou alimentao (min).
    int SubIntContRA;  // Sub-intervalo contnuo para repouso e/ou alimentao (min).
    int TmpMaxTrab;    // Tempo mximo trabalhado por dia.
    int TmpNormalTrab; // Tempo normal de trabalho (sem os intervalos).
    int TmpDPegada;    // Tempo que indica dupla pegada.

    TParPptED();
    void PreencherAtributos(int, int, int, int, int, int, int, int, int);
    bool ValoresValidos();
    void LerPadrao();
    void LerDefault();
    void GravarPadrao();
};
//------------------------------------------------------------------------------


/* =============================================================================
- Classe.....: TParPptEM
- Objetivo...: Possui os atributos e mtodos referentes aos parmetros da escala
               mensal das tripulaes.
============================================================================= */
class TParPptEM : public TParPpt{
  private:
    void SelecionarArquivo(char);

  public:
    int DifTMT;     // Diferena mxima do tempo mdio de trabalho.
    int HorLTPTrab; // Horrio limite para troca do perodo de trabalho.

    TParPptEM();
    void PreencherAtributos(int, int, int);
    bool ValoresValidos();
    void LerPadrao();
    void LerDefault();
    void GravarPadrao();
};
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#endif
// ----------------------------------- FIM ---------------------------------- \\
