/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UParPpt                          Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Representar os parmetros da programao da
*                            tripulao.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TParPpt) referente aos parmetros comuns para
*                            ambas as escalas, de uma outra (TParPptED) referente
*                            aos parmetros para a escala diria e de uma outra
*                            (TParPptEM) referente aos parmetros da escala mensal.
* Obs......................: O arquivo .h dessa unit possui a declarao de
*                            tudo que foi implementado aqui.
* Dependncias.............: <--- NENHUMA --->
*******************************************************************************/

#pragma hdrstop

#include "UParPpt.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
//------------------------------------------------------------------------------

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "vcl.h"
#include "stdio.h"
//------------------------------------------------------------------------------


                        // ----- CLASSE TParPpt ----- \\

/* =============================================================================
- Mtodo.....: TParPpt
- Objetivo...: Criar e inicializar o objeto TParPpt.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TParPpt::TParPpt()
{
 TmpMinEntJorn = 0;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherAtributos
- Objetivo...: Preencher os valores do objeto com os valores recebidos.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) TMEJ -> Tempo mnimo entre jornadas.
============================================================================= */
void TParPpt::PreencherAtributos(int TMEJ)
{
 TmpMinEntJorn = TMEJ;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Free
- Objetivo...: Destuir o objeto TParPpt (ou filho).
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TParPpt::Free()
{
 delete(this);
}
//------------------------------------------------------------------------------


                        // ----- CLASSE TParPptED ----- \\

/* =============================================================================
- Mtodo.....: TParPptED
- Objetivo...: Criar e inicializar o objeto TParPptED.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TParPptED::TParPptED()
{
 TParPpt::TParPpt();
 NTrip         = 0;
 TmpTrocaTrip  = 0;
 NMaxTripDP    = 0;
 IntTotRepAli  = 0;
 SubIntContRA  = 0;
 TmpMaxTrab    = 0;
 TmpNormalTrab = 0;
 TmpDPegada    = 0;

 this->LerPadrao();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherAtributos
- Objetivo...: Preencher os valores do objeto com os valores recebidos.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) TMEJ -> Tempo mnimo entre jornadas.
   2) NT   -> Nmero de tripulaes.
   3) TTT  -> Tempo de troca de tripulao (min).
   4) NMDP -> Nmero mximo de tripulaes com duplas pegadas.
   5) IRA  -> Intervalo total para repouso e/ou alimentao (min).
   6) SRA  -> Sub-intervalo contnuo para repouso e/ou alimentao (min).
   7) TMT  -> Tempo mximo trabalhado por dia.
   8) TNT  -> Tempo normal trabalhado por dia.
   9) TDP  -> Tempo que indica dupla pegada.
============================================================================= */
void TParPptED::PreencherAtributos(int TMEJ, int NT, int TTT, int NMDP, int IRA,
                                   int SRA, int TMT, int TNT, int TDP)
{
 TParPpt::PreencherAtributos(TMEJ);
 NTrip         = NT;
 TmpTrocaTrip  = TTT;
 NMaxTripDP    = NMDP;
 IntTotRepAli  = IRA;
 SubIntContRA  = SRA;
 TmpMaxTrab    = TMT;
 TmpNormalTrab = TNT;
 TmpDPegada    = TDP;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ValoresValidos
- Objetivo...: Verificar os valores do objeto.
- Retorno....: true/false (bool)
- Parmetros.: <-- Nenhum -->
============================================================================= */
bool TParPptED::ValoresValidos()
{
 if ( ((TParPpt *)TmpMinEntJorn >= 0) && (NTrip > 0) && (this->TmpTrocaTrip >= 0) &&
      (this->NMaxTripDP >= 0) && (this->IntTotRepAli >= 0) && (this->SubIntContRA >= 0) &&
      (this->TmpMaxTrab > 0) && (this->TmpNormalTrab > 0) && (this->TmpDPegada > 0) )
   return true;
 else
   return false;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: SelecionarArquivo
- Objetivo...: Ler os valores do objeto a partir do arquivo correto.
- Retorno....: <-- Nenhum -->
- Parmetros.: Tipo -> 'D'- Default   |  'P'- Padro.
============================================================================= */
void TParPptED::SelecionarArquivo(char Tipo)
{
 String Diretorio, Msg;
 if (Tipo == 'P')
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\PPT_ED.par";
   Msg = "O arquivo 'PPT_ED.par' no pode ser aberto!";
  }
 else
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\PPT.dft";
   Msg = "O arquivo 'PPT.dft' no pode ser aberto!";
  }

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "r");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg(Msg, mtError, TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   char P[100];
   char *Par = "TED";

   do
    {
     fscanf(Arq, "%s", &P);
    }while (strncmp(Par, P, 4));

   fscanf(Arq, "%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d", &this->TmpMinEntJorn,
          &this->NTrip, &this->TmpTrocaTrip, &this->NMaxTripDP, &this->IntTotRepAli,
          &this->SubIntContRA, &this->TmpMaxTrab, &this->TmpNormalTrab, &this->TmpDPegada);
  }
 fclose(Arq);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LerPadrao
- Objetivo...: Ler os valores do objeto a partir do arquivo PPT_ED.par.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TParPptED::LerPadrao()
{
 SelecionarArquivo('P');
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LerDefault
- Objetivo...: Ler os valores do objeto a partir do arquivo PPT.dft.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TParPptED::LerDefault()
{
 SelecionarArquivo('D');
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: GravarPadrao
- Objetivo...: Gravar os valores do objeto no arquivo PPT_ED.par.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TParPptED::GravarPadrao()
{
 String Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\PPT_ED.par";

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "w");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg("O arquivo PPT_ED.par no pode ser aberto!", mtError,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   fprintf(Arq, "%s\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d", "TED", this->TmpMinEntJorn,
           this->NTrip, this->TmpTrocaTrip, this->NMaxTripDP, this->IntTotRepAli,
           this->SubIntContRA, this->TmpMaxTrab, this->TmpNormalTrab, this->TmpDPegada);
  }

 fclose(Arq);
}
//------------------------------------------------------------------------------


                        // ----- CLASSE TParPptEM ----- \\

/* =============================================================================
- Mtodo.....: TParPptEM
- Objetivo...: Criar e inicializar o objeto TParPptEM.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TParPptEM::TParPptEM()
{
 TParPpt::TParPpt();
 DifTMT     = 0;
 HorLTPTrab = 0;

 this->LerPadrao();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherAtributos
- Objetivo...: Preencher os valores do objeto com os valores recebidos.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) TMEJ  -> Tempo mnimo entre jornadas.
   2) DTMT  -> Diferena mxima do tempo mdio de trabalho.
   3) HLTPT -> Horrio limite para troca do perodo de trabalho.
============================================================================= */
void TParPptEM::PreencherAtributos(int TMEJ, int DTMT, int HLTPT)
{
 TParPpt::PreencherAtributos(TMEJ);
 DifTMT     = DTMT;
 HorLTPTrab = HLTPT;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ValoresValidos
- Objetivo...: Verificar os valores do objeto.
- Retorno....: true/false (bool)
- Parmetros.: <-- Nenhum -->
============================================================================= */
bool TParPptEM::ValoresValidos()
{
 if ( ((TParPpt *)TmpMinEntJorn >= 0) && (this->DifTMT >= 0) &&
      (this->HorLTPTrab > 0) && (this->HorLTPTrab < 1440) )
   return true;
 else
   return false;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: SelecionarArquivo
- Objetivo...: Ler os valores do objeto a partir do arquivo correto.
- Retorno....: <-- Nenhum -->
- Parmetros.: Tipo -> 'D'- Default   |  'P'- Padro.
============================================================================= */
void TParPptEM::SelecionarArquivo(char Tipo)
{
 String Diretorio, Msg;
 if (Tipo == 'P')
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\PPT_EM.par";
   Msg = "O arquivo 'PPT_EM.par' no pode ser aberto!";
  }
 else
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Arquivos\\PPT.dft";
   Msg = "O arquivo 'PPT.dft' no pode ser aberto!";
  }

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "r");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg(Msg, mtError, TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   char P[100];
   char *Par = "TEM";

   do
    {
     fscanf(Arq, "%s", &P);
    }while (strncmp(Par, P, 4));

   fscanf(Arq, "%d\t%d\t%d", &this->TmpMinEntJorn, &this->DifTMT, &this->HorLTPTrab);
  }

 fclose(Arq);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LerPadrao
- Objetivo...: Ler os valores do objeto a partir do arquivo PPT_EM.par.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TParPptEM::LerPadrao()
{
 SelecionarArquivo('P');
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LerPadrao
- Objetivo...: Ler os valores do objeto a partir do arquivo PPT.dft.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TParPptEM::LerDefault()
{
 SelecionarArquivo('D');
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: GravarPadrao
- Objetivo...: Gravar os valores do objeto no arquivo PPT_EM.par.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TParPptEM::GravarPadrao()
{
 String Diretorio = ExtractFilePath(Application->ExeName)+ "\\Arquivos\\PPT_EM.par";

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "w");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg("O arquivo 'PPT_EM.par' no pode ser aberto!", mtError,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   fprintf(Arq, "%s\t%d\t%d\t%d", "TEM", this->TmpMinEntJorn, this->DifTMT,
          this->HorLTPTrab);
  }
 fclose(Arq);
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
