/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmTarefas                      Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Conter a tela de exibio das tarefas de uma
*                            tripulao.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmTarefas) referente a tela de exibio de
*                            tarefas.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UEscDiaria
*     2) UTripulacoes
*     3) UTar_Jorn
*     4) UUtil
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmTarefas.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UEscDiaria.h"
#include "UTripulacoes.h"
#include "UTar_Jorn.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#define max(a, b)  (((a) > (b)) ? (a) : (b))

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmTarefas *FrmTarefas;
//------------------------------------------------------------------------------

__fastcall TFrmTarefas::TFrmTarefas(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preencher o cabealho do grid.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmTarefas::FormShow(TObject *Sender)
{
 StrGTarefas->Cells[1][0] = "N do veculo";
 StrGTarefas->Cells[2][0] = "Hor. inicial";
 StrGTarefas->Cells[3][0] = "Hor. final";
 StrGTarefas->Cells[4][0] = "Pto. inicial";
 StrGTarefas->Cells[5][0] = "Pto. final";
 StrGTarefas->Cells[6][0] = "F. acumulada";
 StrGTarefas->Cells[7][0] = "L. inicial";
 StrGTarefas->Cells[8][0] = "L. final";

 StrGTarefas->Color       = S->CCCTabelas;
 StrGTarefas->FixedColor  = S->CCFTabelas;
 StrGTarefas->Font->Color = S->CFTabelas;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherGrid
- Objetivo...: Preencher o grid com as tarefas da tripulao recebida.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) NTrip -> N da tripulao.
============================================================================= */
void TFrmTarefas::PreencherGrid(int NTrip)
{
 TTripED *Trip;
 TTarefa *T;
 int lin = 1;

 Trip = (TTripED *)escdiaria->LstTripulacoes->Items[NTrip];

 for (int i = 0; i < Trip->LstTarefas->Count; i++)
  {
   T = (TTarefa *)Trip->LstTarefas->Items[i];
   StrGTarefas->Cells[0][lin] = "Tarefa: " + IntToStr(i);
   StrGTarefas->Cells[1][lin] = IntToStr(T->NumVeic);
   StrGTarefas->Cells[2][lin] = MinuteToStr(T->HInicio);
   StrGTarefas->Cells[3][lin] = MinuteToStr(T->HFim);
   StrGTarefas->Cells[4][lin] = IntToStr(T->PIni);
   StrGTarefas->Cells[5][lin] = IntToStr(T->PFim);
   StrGTarefas->Cells[6][lin] = IntToStr(T->FolAcu);
   StrGTarefas->Cells[7][lin] = getLinha(T->LinIni);
   StrGTarefas->Cells[8][lin] = getLinha(T->LinFin);

   lin++;
  }
 if (Trip->TVirtual != 0)
  {
   StrGTarefas->Cells[0][lin] = "Tarefa virtual!";
   StrGTarefas->Cells[1][lin] = "T. virtual!";
   StrGTarefas->Cells[2][lin] = MinuteToStr(T->HFim);
   StrGTarefas->Cells[3][lin] = MinuteToStr(Trip->TVirtual);
   StrGTarefas->Cells[4][lin] = "T. virtual!";
   StrGTarefas->Cells[5][lin] = "T. virtual!";
   StrGTarefas->Cells[6][lin] = "T. virtual!";
   StrGTarefas->Cells[7][lin] = "T. virtual!";
   StrGTarefas->Cells[8][lin] = "T. virtual!";

   lin++;
  }

 StrGTarefas->RowCount = max(2, lin);

 this->Caption      = "PPT Solver v2.0 - Tarefas da tripulao " + IntToStr(NTrip);
 LblTitulo->Caption = "Tarefas da tripulao " + IntToStr(NTrip);
 LblFO->Caption     = "Funo objetivo: " + FloatToStr(Trip->FncObjetivo);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: FormClose
- Objetivo...: Limpar o grid.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmTarefas::FormClose(TObject *Sender, TCloseAction &Action)
{
 LimparGrid(StrGTarefas);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnFecharClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmTarefas::BBtnFecharClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
