/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmSistema                      Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Exibir os valores das sistema.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmSistema) referente a tela que contm os valores
*                            do sistema.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UFrmPrincipal
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmSistema.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UFrmPrincipal.h"
//------------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmSistema *FrmSistema;
//------------------------------------------------------------------------------

__fastcall TFrmSistema::TFrmSistema(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preencher a interface no momento de exibio da tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmSistema::FormShow(TObject *Sender)
{
 PreencherInterface();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherInterface
- Objetivo...: Preencher a interface com os valores do objeto S.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmSistema::PreencherInterface()
{
 ClrBFTPrinc->Selected = S->CFundoTPrinc;
 ClrBCCTab->Selected   = S->CCCTabelas;
 ClrBCFTab->Selected   = S->CCFTabelas;
 ClrBFTab->Selected    = S->CFTabelas;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnAlterarClick
- Objetivo...: Alterar os valores do objeto S.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmSistema::BBtnAlterarClick(TObject *Sender)
{
 S->PreencherAtributos(ClrBFTPrinc->Selected, ClrBCCTab->Selected,
                       ClrBCFTab->Selected, ClrBFTab->Selected);
 if (S->ValoresValidos())
  {
   S->GravarPadrao();
   FrmPrincipal->Color = S->CFundoTPrinc;
   Close();
  }
 else
  {
   Beep();
   MessageDlg("As cores devem ser todas diferentes!",
              mtInformation, TMsgDlgButtons() << mbOK, 0);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnDefaultClick
- Objetivo...: Restaurar os valores default do objeto S.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmSistema::BBtnDefaultClick(TObject *Sender)
{
 S->LerDefault();
 S->GravarPadrao();
 PreencherInterface();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnFecharClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmSistema::BBtnFecharClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
