/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmSimAnn                       Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Exibir os valores dos parmetros do SA.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmSimAnn) referente a tela que contm os
*                            parmetros para o simulated annealing.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UUtil
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmSimAnn.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UUtil.cpp"
//------------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmSimAnn *FrmSimAnn;
//------------------------------------------------------------------------------

__fastcall TFrmSimAnn::TFrmSimAnn(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preencher a interface no momento de exibio da tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmSimAnn::FormShow(TObject *Sender)
{
 PreencherInterface();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherInterface
- Objetivo...: Preencher a interface com os valores do objeto SA.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmSimAnn::PreencherInterface()
{
 EdtNMI->Text  = IntToStr(SA->NumMaxIte);
 EdtTI->Text   = FloatToStr(SA->TprInic);
 EdtTC->Text   = FloatToStr(SA->TprCong);
 EdtTR->Text   = FloatToStr(SA->TxResf);
 MEdtTMP->Text = MinuteToStr(SA->TmpMaxProc);
 ChkBCPTMP->Checked = SA->CPtmMaxProc;
 ChkBCPTC->Checked  = SA->CPtprCong;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnOKClick
- Objetivo...: Preencher os valores do objeto SA com os valores da interface.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmSimAnn::BBtnOKClick(TObject *Sender)
{
 try
  {
   SA->PreencherAtributos( StrToInt(EdtNMI->Text), StrToFloat(EdtTR->Text),
                           StrToFloat(EdtTI->Text), StrToFloat(EdtTC->Text),
                           StrToMinute(MEdtTMP->Text), ChkBCPTC->Checked,
                           ChkBCPTMP->Checked );

   if (!SA->ValoresValidos())
    {
     Beep();
     MessageDlg("Todos os valores devem ser maiores do que zero, exceto a TAXA DE RESFRIAMENTO, que deve ser maior que ZERO e menor que UM!",
                mtWarning, TMsgDlgButtons() << mbOK, 0);
    }
   else
    {
     Close();
    }
  }
 catch ( ... ) { MessageDlg("O NMERO DE ITERAES e o TEMPO DE PROCESSAMENTO devem ser nmeros INTEIROS e os demais parmetros, nmeros REAIS!",
                            mtError, TMsgDlgButtons() << mbOK, 0); }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnResPadClick
- Objetivo...: Restaurar os valores do objeto (SA) e da interface a partir do
               arquivo padro (SimAnn.par).
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmSimAnn::BBtnResPadClick(TObject *Sender)
{
 SA->LerPadrao();
 PreencherInterface();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnCancelarClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmSimAnn::BBtnCancelarClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
