/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmResultadoEM                  Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Conter a tela do resultado da escala mensal.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmResultadoEM) referente a tela do resultado da
*                            escala mensal.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UEscMensal
*     2) UResultados
*     3) UUtil
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmResultadoEM.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UEscMensal.h"
#include "UResultados.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmResultadoEM *FrmResultadoEM;
//------------------------------------------------------------------------------

__fastcall TFrmResultadoEM::TFrmResultadoEM(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preencher os campos da tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmResultadoEM::FormShow(TObject *Sender)
{
 TResultadoEM *ResEM = new TResultadoEM();
 ResEM->CalcularResultado(escmensal, ParEM, SA);

 // --- Custos --- \\
 LblNTrip->Caption    = IntToStr(ResEM->NTrip);
 LblNTTP->Caption     = IntToStr(ResEM->NTrTipPeg);
 LblTMT->Caption      = MinuteToStr(ResEM->TmpMedioTrab);
 LblNTPTrab->Caption  = IntToStr(ResEM->NTroPerTrab);
 LblNJornDif->Caption = IntToStr(ResEM->NJornDif);
 LblDMTMT->Caption  = MinuteToStr(ResEM->DifMaxTMT);

 // --- Inviabilidades --- \\
 LblTFTEJ->Caption  = MinuteToStr(ResEM->FTEJorn);

 // --- Outros --- \\
 LblTTT->Caption   = MinuteToStr(ResEM->TmpTT);
 LblNJorn->Caption = IntToStr(ResEM->NJorn);
 LblTESA->Caption  = ResEM->TempoExec.TimeString();
 LblFOT->Caption   =  IntToStr(ResEM->FncObj);

 if (ResEM->FTEJorn != 0)
  LblTFTEJ->Font->Color = clRed;

 if (!escmensal->Valida)
  {
   LblResult->Caption = "Escala mensal invlida!";
   LblResult->Font->Color = clRed;
  }
 ResEM->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnFecharClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmResultadoEM::BBtnFecharClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\