/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmResultadoED                  Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Conter a tela do resultado da escala diria.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmResultadoED) referente a tela do resultado da
*                            escala diria.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UEscDiaria
*     2) UResultados
*     3) UUtil
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmResultadoED.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UEscDiaria.h"
#include "UResultados.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmResultadoED *FrmResultadoED;
//------------------------------------------------------------------------------

__fastcall TFrmResultadoED::TFrmResultadoED(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preencher os campos da tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmResultadoED::FormShow(TObject *Sender)
{
 TResultadoED *ResED = new TResultadoED();
 ResED->CalcularResultado(escdiaria, ParED, SA);

 // --- Custos --- \\
 LblNTrip->Caption  = IntToStr(ResED->NTrip);
 LblTOT->Caption    = MinuteToStr(ResED->TmpOc);
 LblHET->Caption    = MinuteToStr(ResED->HExtra);
 LblNTDP->Caption   = IntToStr(ResED->NDP);
 LblNTV->Caption    = IntToStr(ResED->NTVei);
 LblNTPPer->Caption = IntToStr(ResED->NTPPer);
 LblNTLPer->Caption = IntToStr(ResED->NTLPer);

 // --- Inviabilidades --- \\
 LblNTPPro->Caption = IntToStr(ResED->NTPPro);
 LblTS->Caption     = MinuteToStr(ResED->TmpSob);
 LblHEx->Caption    = MinuteToStr(ResED->HExc);
 LblFTEJ->Caption   = MinuteToStr(ResED->FTEJorn);
 LblNTLPro->Caption = IntToStr(ResED->NTLPro);

 // --- Outros --- \\
 LblNTar->Caption = IntToStr(ResED->NTar);
 LblTESA->Caption = ResED->TempoExec.TimeString();
 LblTTT->Caption  = MinuteToStr(ResED->TmpTT);
 LblFOT->Caption  = IntToStr(ResED->FncObj);

 if (ResED->NTPPro != 0)
  LblNTPPro->Font->Color = clRed;
 if (ResED->TmpSob != 0)
  LblTS->Font->Color = clRed;
 if (ResED->HExc != 0)
  LblHEx->Font->Color = clRed;
 if (ResED->FTEJorn != 0)
  LblFTEJ->Font->Color = clRed;
 if (ResED->NTLPro != 0)
  LblNTLPro->Font->Color = clRed;

 if (!escdiaria->Valida)
  {
   LblResult->Caption = "Escala diria invlida!";
   LblResult->Font->Color = clRed;
  }
 ResED->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnFecharClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmResultadoED::BBtnFecharClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\

