/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmReaquecerSA                  Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Conter a tela de reaquecimento do SA.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmReaquecerSA) referente a tela de reaquecimento
*                            do Simulated Annealing.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............: <--- NENHUMA --->
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmReaquecerSA.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmReaquecerSA *FrmReaquecerSA;
//------------------------------------------------------------------------------

__fastcall TFrmReaquecerSA::TFrmReaquecerSA(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: BBtnReaquecerClick
- Objetivo...: Reaquecer o SA.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmReaquecerSA::BBtnReaquecerClick(TObject *Sender)
{
 try
  {
   if (StrToFloat(CbxTemperatura->Text) > 0)
    {
     SA->Reaquecer(StrToFloat(CbxTemperatura->Text));
     SA->PodeReaquecer = true;
     CbxTemperatura->Text = "";
     Close();
    }
   else
    {
     Beep();
     MessageDlg("O valor da temperatura deve ser maior do que zero!",
                mtWarning, TMsgDlgButtons() << mbOK, 0);
    }
  }
 catch ( ... ) { MessageDlg("A temperatura deve ser um nmero REAL!",
                            mtError, TMsgDlgButtons() << mbOK, 0); }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnCancelarClick
- Objetivo...: No reaquecer o SA.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmReaquecerSA::BBtnCancelarClick(TObject *Sender)
{
 SA->PodeReaquecer = false;
 CbxTemperatura->Text = "";
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
