/*******************************************************************************
* Dependncia.....: UParPpt; UPesos; UProgVei; UEstruturaMes; USimAnn; USistema*
*******************************************************************************/

//------------------------------------------------------------------------------
#ifndef UFrmPrincipalH
#define UFrmPrincipalH
//------------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ActnList.hpp>
#include <Menus.hpp>
#include <Dialogs.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <ToolWin.hpp>
#include <ImgList.hpp>

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UParPpt.h"
#include "UPesos.h"
#include "UProgVei.h"
#include "UEstruturaMes.h"
#include "USimAnn.h"
#include "USistema.h"
//------------------------------------------------------------------------------

class TFrmPrincipal : public TForm
{
__published:	// IDE-managed Components
        TMainMenu *MMnuPrincipal;
        TMenuItem *MItEscdiaria;
        TMenuItem *MItEscMensal;
        TMenuItem *MItMetodos;
        TMenuItem *MItOpcoes;
        TMenuItem *MItAjuda;
        TMenuItem *MItSair;
        TMenuItem *MItSair2;
        TMenuItem *MItAjuda2;
        TMenuItem *MItLinha3;
        TMenuItem *MItSobre;
        TMenuItem *MItParEM;
        TMenuItem *MItPesEM;
        TMenuItem *MItCarregEM;
        TMenuItem *MItLinha2;
        TMenuItem *MItExecEM;
        TMenuItem *MItParED;
        TMenuItem *MItPesED;
        TMenuItem *MItCarregED;
        TMenuItem *MItLinha1;
        TMenuItem *MItExecED;
        TActionList *ActLstPrincipal;
        TAction *ActParED;
        TAction *ActPesED;
        TAction *ActCarregED;
        TAction *ActParEM;
        TAction *ActPesEM;
        TAction *ActCarregEM;
        TAction *ActExecEM;
        TAction *ActSair;
        TMenuItem *MItProgVei;
        TAction *ActDefGrupLin;
        TOpenDialog *OpDlgProgVei;
        TMenuItem *MItDUtil;
        TMenuItem *MItDomFer;
        TMenuItem *MItSab;
        TAction *ActExecEDDU;
        TAction *ActExecEDDF;
        TAction *ActExecEDSab;
        TAction *ActExecED;
        TAction *ActLerEDiarias;
        TAction *ActLerProgVei;
        TMenuItem *MItSimAnn;
        TAction *ActSimAnn;
        TAction *ActSistema;
        TMenuItem *MItSistema;
        TTimer *TmrPrincipal;
        TStatusBar *StsBPrincipal;
        TToolBar *TlBPrincipal;
        TToolButton *TlBSeparador1;
        TToolButton *TlBtnProgVei;
        TToolButton *TlBSeparador2;
        TToolButton *TlBtnEscDiarias;
        TToolButton *TlBSeparador3;
        TToolButton *TlBtnCarED;
        TToolButton *TlBSeparador;
        TToolButton *TlBtnCarEM;
        TToolButton *TlBSeparador5;
        TToolButton *TlBtnSistema;
        TToolButton *TlBSeparador7;
        TAction *ActAlterarPadrao;
        TAction *ActAjuda;
        TAction *ActSobre;
        TMenuItem *MItAltPadrao;
        TOpenDialog *OpDlgEscDiaria;
        TMenuItem *MItLerEscDiarias;
        TImageList *ImgLstPrincipal;
        TToolButton *TlBtnAjuda;
        TToolButton *TlBSeparador8;
        TToolButton *TlBtnSair;
        TToolButton *TlBSeparador9;
        TToolButton *TlBtnSimAnn;
        TToolButton *TlBSeparador6;
        TOpenDialog *OpDlgEscMensal;

        void __fastcall FormCreate(TObject *Sender);
        void __fastcall ActParEDExecute(TObject *Sender);
        void __fastcall ActPesEDExecute(TObject *Sender);
        void __fastcall ActCarregEDExecute(TObject *Sender);
        void __fastcall ActParEMExecute(TObject *Sender);
        void __fastcall ActPesEMExecute(TObject *Sender);
        void __fastcall ActCarregEMExecute(TObject *Sender);
        void __fastcall ActExecEMExecute(TObject *Sender);
        void __fastcall ActSairExecute(TObject *Sender);
        void __fastcall ActLerProgVeiExecute(TObject *Sender);
        void __fastcall ActExecEDDUExecute(TObject *Sender);
        void __fastcall ActExecEDDFExecute(TObject *Sender);
        void __fastcall ActExecEDSabExecute(TObject *Sender);
        void __fastcall ActExecEDExecute(TObject *Sender);
        void __fastcall ActLerEDiariasExecute(TObject *Sender);
        void __fastcall ActSimAnnExecute(TObject *Sender);
        void __fastcall ActSistemaExecute(TObject *Sender);
        void __fastcall TmrPrincipalTimer(TObject *Sender);
        void __fastcall ActAlterarPadraoExecute(TObject *Sender);
        void __fastcall ActAjudaExecute(TObject *Sender);
        void __fastcall ActSobreExecute(TObject *Sender);
        void __fastcall FormDestroy(TObject *Sender);

private:
        TParPptED *ParED; // Objeto que representa os par. para a escala diria.
        TParPptEM *ParEM; // Objeto que representa os par. para a escala mensal.
        TPesosED *PesED;  // Objeto que representa os pesos para a escala diria.
        TPesosEM *PesEM;  // Objeto que representa os pesos para a escala mensal.
        TProgVei *PV;     // Objeto que representa a programao de veculos.
        TSimAnn *SA;      // Objeto que representa o simulated annealing.
        TSistema *S;      // Objeto que representa o sistema.
        TEscDiaria *EDU;  // Objeto que representa uma esc. diria para dias teis.
        TEscDiaria *EDF;  // Objeto que representa uma esc. diria para dom. e feriados.
        TEscDiaria *ESab; // Objeto que representa uma esc. diria para sbados.

        void AgruparLinhas();

public:
        __fastcall TFrmPrincipal(TComponent* Owner);

        TEstruturaMes *EstM; // Objeto que representa uma estrutura de um ms.

        String DirEscDU;     // Diretrio de uma esc. diria para dias teis.
        String DirEscDF;     // Diretrio de uma esc. diria para dom. e feriados.
        String DirEscSab;    // Diretrio de uma esc. diria para sbados.

        bool LeuProgVei;     // Indica se a prog. de veculos foi lida ou no.
        bool AgrupouLinhas;  // Indica se as linhas foram agrupadas ou no.
        bool LeuEscDiarias;  // Indica se as esc. dirias foram lidas.
        bool SelecionouMes;  // Indica se algum ms foi selecionado.
};
//------------------------------------------------------------------------------
extern PACKAGE TFrmPrincipal *FrmPrincipal;
//------------------------------------------------------------------------------
#endif
