/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmPrincipal                    Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Conter a tela principal do sistema.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmPrincipal) referente a tela principal.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UFrmParED                      8) UFrmLerEscDiarias
*     2) UFrmParEM                      9) UFrmSimAnn
*     3) UFrmPesED                     10) UFrmSistema
*     4) UFrmPesEM                     11) UFrmAltValPad
*     5) UFrmAgruparLinhas             12) UFrmSobre
*     6) UFrmEscDiaria                 13) UUtil
*     7) UFrmEscMensal
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmPrincipal.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UFrmParED.h"
#include "UFrmParEM.h"
#include "UFrmPesED.h"
#include "UFrmPesEM.h"
#include "UFrmAgruparLinhas.h"
#include "UFrmEscDiaria.h"
#include "UFrmEscMensal.h"
#include "UFrmMesEscMensal.h"
#include "UFrmLerEscDiarias.h"
#include "UFrmSimAnn.h"
#include "UFrmSistema.h"
#include "UFrmAltValPad.h"
#include "UFrmSobre.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmPrincipal *FrmPrincipal;
//------------------------------------------------------------------------------

__fastcall TFrmPrincipal::TFrmPrincipal(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormCreate
- Objetivo...: Criar os objetos "Pesos", "Parmetros" e "Simulated Annealing";
               e inicializar as variveis de controle.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::FormCreate(TObject *Sender)
{
 ParED = new TParPptED();
 ParEM = new TParPptEM();
 PesED = new TPesosED();
 PesEM = new TPesosEM();
 SA    = new TSimAnn();
 S     = new TSistema();

 this->Color = S->CFundoTPrinc;
 StsBPrincipal->Panels->Items[0]->Width = ClientWidth - 200;
 StsBPrincipal->Panels->Items[1]->Width = 100;
 StsBPrincipal->Panels->Items[2]->Width = 100; 

 LeuProgVei    = false;
 AgrupouLinhas = false;
 LeuEscDiarias = false;
 SelecionouMes = false;
}
//------------------------------------------------------------------------------


                        // ----- ESCALA DIRIA ----- \\

/* =============================================================================
- Mtodo.....: ActParEDExecute
- Objetivo...: Exibir a tela de parmetros da escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActParEDExecute(TObject *Sender)
{
 FrmParED = new TFrmParED(Owner);
 FrmParED->ParED = ParED;
 FrmParED->ShowModal();
 FrmParED->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActLerProgVeiExecute
- Objetivo...: Ler a programao de veculos.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActLerProgVeiExecute(TObject *Sender)
{
 if (OpDlgProgVei->Execute())
  {
   if (PV != NULL)
    PV->Free();
   PV = new TProgVei();
   PV->CriarLstTarefas(ParED, OpDlgProgVei->FileName);
   PV->LstTarefas->Sort(OrdenaListaTamTarefa);
   Beep();
   MessageDlg("O arquivo da programao de veculos foi lido com sucesso!",
              mtInformation, TMsgDlgButtons() << mbOK, 0);
   LeuProgVei = true;
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: AgruparLinhas
- Objetivo...: Exibir a tela de agrupamento de linhas.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmPrincipal::AgruparLinhas()
{
 if (LeuProgVei)
  {
   FrmAgruparLinhas = new TFrmAgruparLinhas(Owner);
   FrmAgruparLinhas->PV = PV;
   FrmAgruparLinhas->ShowModal();
   FrmAgruparLinhas->Free();
  }
 else
  {
   Beep();
   MessageDlg("O arquivo da programao de veculos ainda no foi lido!",
              mtWarning, TMsgDlgButtons() << mbOK, 0);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActPesEDExecute
- Objetivo...: Exibir a tela de pesos da escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActPesEDExecute(TObject *Sender)
{
 FrmPesED = new TFrmPesED(Owner);
 FrmPesED->PesED = PesED;
 FrmPesED->ShowModal();
 FrmPesED->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActCarregEDExecute
- Objetivo...: Carregar uma escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActCarregEDExecute(TObject *Sender)
{
 Beep();
 MessageDlg("Caso voc queira alterar os parmetros ou os pesos para a escala diria, ou os parmetros do SA, faa-o antes de carregar a escala!",
            mtWarning, TMsgDlgButtons() << mbOK, 0);

 if (OpDlgEscDiaria->Execute())
  {
   escdiaria = new TEscDiaria();
   escdiaria->CarregarEscala(OpDlgEscDiaria->FileName);

   LeuProgVei = true;
   AgruparLinhas();

   if (AgrupouLinhas)
    {
     escdiaria->EfetuarCalculos(ParED, PesED);

     FrmEscDiaria = new TFrmEscDiaria(Owner);
     FrmEscDiaria->ParED = ParED;
     FrmEscDiaria->PesED = PesED;
     FrmEscDiaria->SA    = SA;
     FrmEscDiaria->S     = S;
     FrmEscDiaria->ShowModal();
     FrmEscDiaria->Free();

     AgrupouLinhas = false;
    }

   LeuProgVei = false;
   escdiaria->Free();
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActExecEDDUExecute
- Objetivo...: Criar uma escala diria para dias teis.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActExecEDDUExecute(TObject *Sender)
{
 escdiaria = new TEscDiaria();
 escdiaria->Tipo = 'U';
 ActExecED->Execute();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActExecEDDFExecute
- Objetivo...: Criar uma escala diria para domingos e feriados.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActExecEDDFExecute(TObject *Sender)
{
 escdiaria = new TEscDiaria();
 escdiaria->Tipo = 'D';
 ActExecED->Execute();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActExecEDSabExecute
- Objetivo...: Criar uma escala diria para sbados.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActExecEDSabExecute(TObject *Sender)
{
 escdiaria = new TEscDiaria();
 escdiaria->Tipo = 'S';
 ActExecED->Execute();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActExecEDExecute
- Objetivo...: Executar uma escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActExecEDExecute(TObject *Sender)
{
 if (LeuProgVei)
  {
   escdiaria->InicializaLstTripulacoes(ParED->NTrip);
   escdiaria->CriarJornadas(PV->LstTarefas);

   AgruparLinhas();

   if (AgrupouLinhas)
    {
     escdiaria->EfetuarCalculos(ParED, PesED);

     FrmEscDiaria = new TFrmEscDiaria(Owner);
     FrmEscDiaria->ParED = ParED;
     FrmEscDiaria->PesED = PesED;
     FrmEscDiaria->SA    = SA;
     FrmEscDiaria->S     = S;
     FrmEscDiaria->ShowModal();
     FrmEscDiaria->Free();
    }
   escdiaria->Free();
  }
 else
  {
   Beep();
   MessageDlg("O arquivo da programao de veculos ainda no foi lido!",
              mtWarning, TMsgDlgButtons() << mbOK, 0);
  }
 LeuProgVei = false;
 AgrupouLinhas = false;
}
//------------------------------------------------------------------------------


                        // ----- ESCALA MENSAL ----- \\

/* =============================================================================
- Mtodo.....: ActParEMExecute
- Objetivo...: Exibir a tela de parmetros da escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActParEMExecute(TObject *Sender)
{
 FrmParEM = new TFrmParEM(Owner);
 FrmParEM->ParEM = ParEM;
 FrmParEM->ShowModal();
 FrmParEM->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActPesEMExecute
- Objetivo...: Exibir a tela de pesos da escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActPesEMExecute(TObject *Sender)
{
 FrmPesEM = new TFrmPesEM(Owner);
 FrmPesEM->PesEM = PesEM;
 FrmPesEM->ShowModal();
 FrmPesEM->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActCarregEMExecute
- Objetivo...: Carregar uma escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActCarregEMExecute(TObject *Sender)
{
 Beep();
 MessageDlg("Caso voc queira alterar os parmetros ou os pesos para a escala mensal, ou os parmetros do SA, faa-o antes de carregar a escala!",
            mtWarning, TMsgDlgButtons() << mbOK, 0);

 if (OpDlgEscMensal->Execute())
  {
   escmensal = new TEscMensal();
   EstM = new TEstruturaMes(0, 0);
   escmensal->CarregarEscala(&EstM, OpDlgEscMensal->FileName);

   escmensal->EfetuarCalculos(EstM, ParEM, PesEM);

   FrmEscMensal = new TFrmEscMensal(Owner);
   FrmEscMensal->EstM  = EstM;
   FrmEscMensal->ParEM = ParEM;
   FrmEscMensal->PesEM = PesEM;
   FrmEscMensal->SA    = SA;
   FrmEscMensal->S     = S;
   FrmEscMensal->ShowModal();
   FrmEscMensal->Free();

   escmensal->Free();
   EstM->Free();
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActLerEDiariasExecute
- Objetivo...: Carregar os diretrios das escalas dirias para a construo da
               esc. mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActLerEDiariasExecute(TObject *Sender)
{
 FrmLerEscDiarias = new TFrmLerEscDiarias(Owner);
 FrmLerEscDiarias->ShowModal();
 FrmLerEscDiarias->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActExecEMExecute
- Objetivo...: Executar uma escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActExecEMExecute(TObject *Sender)
{
 if (LeuEscDiarias)
  {
   EDU = new TEscDiaria();
   EDU->CarregarEscala(this->DirEscDU);
   EDU->EfetuarCalculos(ParED, PesED);
   EDF = new TEscDiaria();
   EDF->CarregarEscala(this->DirEscDF);
   EDF->EfetuarCalculos(ParED, PesED);
   ESab = new TEscDiaria();
   ESab->CarregarEscala(this->DirEscSab);
   ESab->EfetuarCalculos(ParED, PesED);

   if ( ((EDF->LstTripulacoes->Count + ESab->LstTripulacoes->Count) ==  EDU->LstTripulacoes->Count) )
    {
     FrmMesEscMensal = new TFrmMesEscMensal(Owner);
     FrmMesEscMensal->EDU  = EDU;
     FrmMesEscMensal->EDF  = EDF;
     FrmMesEscMensal->ESab = ESab;
     FrmMesEscMensal->ShowModal();
     FrmMesEscMensal->Free();

     if (SelecionouMes)
      {
       escmensal = new TEscMensal();
       escmensal->InicializaLstTripulacoes(EstM->LstJornDU->Count);
       escmensal->DistribuirJornadas(EstM);
       escmensal->EfetuarCalculos(EstM, ParEM, PesEM);

       FrmEscMensal = new TFrmEscMensal(Owner);
       FrmEscMensal->EstM  = EstM;
       FrmEscMensal->ParEM = ParEM;
       FrmEscMensal->PesEM = PesEM;
       FrmEscMensal->SA    = SA;
       FrmEscMensal->S     = S;
       FrmEscMensal->ShowModal();
       FrmEscMensal->Free();

       escmensal->Free();
       EstM->Free();
      }
    }
   else
    {
     Beep();
     MessageDlg("O nmero de jornadas nas escalas dirias  incompatvel!",
                mtWarning, TMsgDlgButtons() << mbOK, 0);
    }
   EDU->Free();
   EDF->Free();
   ESab->Free();

   LeuEscDiarias = false;
   SelecionouMes = false;
  }
 else
  {
   Beep();
   MessageDlg("Os arquivos das escalas dirias (dia til, sbado e domingo e feriado) ainda no foram lidos!",
              mtWarning, TMsgDlgButtons() << mbOK, 0);
  }
}
//------------------------------------------------------------------------------


                        // ----- SIMULATED ANNEALING ----- \\

/* =============================================================================
- Mtodo.....: ActSimAnnExecute
- Objetivo...: Exibir a tela de parmetros do Simulated Annealing.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActSimAnnExecute(TObject *Sender)
{
 FrmSimAnn = new TFrmSimAnn(Owner);
 FrmSimAnn->SA = SA;
 FrmSimAnn->ShowModal();
 FrmSimAnn->Free();
}
//------------------------------------------------------------------------------


                        // ----- SISTEMA ----- \\

/* =============================================================================
- Mtodo.....: TmrPrincipalTimer
- Objetivo...: Exibir a hora e a data corrente do sistema.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::TmrPrincipalTimer(TObject *Sender)
{
 StsBPrincipal->Panels->Items[1]->Text = " Data: " + TDateTime::CurrentDateTime().DateString();
 StsBPrincipal->Panels->Items[2]->Text = " Hora: " + TDateTime::CurrentDateTime().TimeString();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActSistemaExecute
- Objetivo...: Exibir a tela de alterao do sistema.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActSistemaExecute(TObject *Sender)
{
 FrmSistema = new TFrmSistema(Owner);
 FrmSistema->S = S;
 FrmSistema->ShowModal();
 FrmSistema->Free();
 this->Color = S->CFundoTPrinc;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActAlterarPadraoExecute
- Objetivo...: Exibir a tela de alterao dos valores padro.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActAlterarPadraoExecute(TObject *Sender)
{
 FrmAltValPad = new TFrmAltValPad(Owner);
 FrmAltValPad->ShowModal();
 FrmAltValPad->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActAjudaExecute
- Objetivo...: Exibir a ajuda do sistema.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActAjudaExecute(TObject *Sender)
{
 Beep();
 MessageDlg("Esse recurso no est disponvel nesta verso!", mtInformation,
            TMsgDlgButtons() << mbOK, 0);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActSobreExecute
- Objetivo...: Exibir a tela "Sobre" do sistema.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActSobreExecute(TObject *Sender)
{
 FrmSobre = new TFrmSobre(Owner);
 FrmSobre->ShowModal();
 FrmSobre->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: FormDestroy
- Objetivo...: Destruir os objetos "Pesos", "Parmetros" e "Simulated Annealing";
               e a "Programao de veculos".
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::FormDestroy(TObject *Sender)
{
 ParED->Free();
 ParEM->Free();
 PesED->Free();
 PesEM->Free();
 S->Free();

 if (PV != NULL)
  PV->Free();

 SA->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ActSairExecute
- Objetivo...: Encerrar a aplicao.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPrincipal::ActSairExecute(TObject *Sender)
{
 Application->Terminate();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\

