/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmPesEM                        Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Exibir os valores das penalizaes para a escala
*                            mensal.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmPesEM) referente a tela que contm os pesos
*                            para a escala mensal.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............: <--- NENHUMA --->
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmPesEM.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmPesEM *FrmPesEM;
//------------------------------------------------------------------------------

__fastcall TFrmPesEM::TFrmPesEM(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preencher a interface no momento de exibio da tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPesEM::FormShow(TObject *Sender)
{
 PreencherInterface();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherInterface
- Objetivo...: Preencher a interface com os valores do objeto PesEM.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmPesEM::PreencherInterface()
{
 EdtPFTEJ->Text  = IntToStr(PesEM->PTEJornadas);
 EdtPEDTMT->Text = IntToStr(PesEM->PTMedioTrab);
 EdtPNJD->Text   = IntToStr(PesEM->PNJorD);
 EdtPNTTP->Text  = IntToStr(PesEM->PNTTPeg);
 EdtPNTPT->Text  = IntToStr(PesEM->PNTPTrab);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnOKClick
- Objetivo...: Preencher os valores do objeto PesEM com os valores da interface.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPesEM::BBtnOKClick(TObject *Sender)
{
 try
  {
   PesEM->PreencherAtributos( StrToInt(EdtPFTEJ->Text), StrToInt(EdtPEDTMT->Text),
                              StrToInt(EdtPNJD->Text), StrToInt(EdtPNTTP->Text),
                              StrToInt(EdtPNTPT->Text) );
   if (!PesEM->ValoresValidos())
    {
     Beep();
     MessageDlg("Todos os valores devem ser maiores ou iguais a zero!",
                mtError, TMsgDlgButtons() << mbOK, 0);
    }
   else
    Close();
  }
 catch ( ... ) { MessageDlg("Todos os valores devem ser nmeros INTEIROS!",
                            mtError, TMsgDlgButtons() << mbOK, 0); }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnResPadClick
- Objetivo...: Restaurar os valores do objeto (PesEM) e da interface a partir do
               arquivo padro (Pesos_EM.par).
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPesEM::BBtnResPadClick(TObject *Sender)
{
 PesEM->LerPadrao();
 PreencherInterface();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnCancelarClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPesEM::BBtnCancelarClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\



