/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmPesED                        Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Exibir os valores das penalizaes para a escala
*                            diria.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmPesED) referente a tela que contm os pesos
*                            para a escala diria.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............: <--- NENHUMA --->
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmPesED.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmPesED *FrmPesED;
//------------------------------------------------------------------------------

__fastcall TFrmPesED::TFrmPesED(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preencher a interface no momento de exibio da tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPesED::FormShow(TObject *Sender)
{
 PreencherInterface();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherInterface
- Objetivo...: Preencher a interface com os valores do objeto PesED.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmPesED::PreencherInterface()
{
 EdtPFTEJ->Text  = IntToStr(PesED->PTEJornadas);
 EdtPNTrip->Text = IntToStr(PesED->PNumTrip);
 EdtPTO->Text    = IntToStr(PesED->PTOcioso);
 EdtPETTT->Text  = IntToStr(PesED->PTTTrabalho);
 EdtPHE->Text    = IntToStr(PesED->PHExtra);
 EdtPTS->Text    = IntToStr(PesED->PTSobreposicao);
 EdtPTPPro->Text = IntToStr(PesED->PTPProibidas);
 EdtPTPPer->Text = IntToStr(PesED->PTPPermitidas);
 EdtPTLPro->Text = IntToStr(PesED->PTLProibidas);
 EdtPTLPer->Text = IntToStr(PesED->PTPPermitidas);
 EdtPTVei->Text  = IntToStr(PesED->PTVeiculos);
 EdtPETDP->Text  = IntToStr(PesED->PNMaxTripDP);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnOKClick
- Objetivo...: Preencher os valores do objeto PesED com os valores da interface.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPesED::BBtnOKClick(TObject *Sender)
{
 try
  {
   PesED->PreencherAtributos( StrToInt(EdtPFTEJ->Text),
                              StrToInt(EdtPNTrip->Text),
                              StrToInt(EdtPTO->Text),
                              StrToInt(EdtPETTT->Text),
                              StrToInt(EdtPHE->Text),
                              StrToInt(EdtPTS->Text),
                              StrToInt(EdtPTPPro->Text),
                              StrToInt(EdtPTPPer->Text),
                              StrToInt(EdtPTLPro->Text),
                              StrToInt(EdtPTLPer->Text),
                              StrToInt(EdtPTVei->Text),
                              StrToInt(EdtPETDP->Text) );
   if (!PesED->ValoresValidos())
    {
     Beep();
     MessageDlg("Todos os valores devem ser maiores ou iguais a zero!",
                mtError, TMsgDlgButtons() << mbOK, 0);
    }
   else
    Close();
  }
 catch ( ... ) { MessageDlg("Todos os valores devem ser nmeros INTEIROS!",
                            mtError, TMsgDlgButtons() << mbOK, 0); }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnResPadClick
- Objetivo...: Restaurar os valores do objeto (PesED) e da interface a partir do
               arquivo padro (Pesos_ED.par).
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPesED::BBtnResPadClick(TObject *Sender)
{
 PesED->LerPadrao();
 PreencherInterface();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnCancelarClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmPesED::BBtnCancelarClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\

