/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmParEM                        Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Exibir os valores dos parmetros para a escala
*                            mensal.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmParEM) referente a tela que contm os
*                            parmetros para a escala mensal.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UUtil
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmParEM.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UUtil.cpp"
//------------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmParEM *FrmParEM;
//------------------------------------------------------------------------------

__fastcall TFrmParEM::TFrmParEM(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preencher a interface no momento de exibio da tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmParEM::FormShow(TObject *Sender)
{
 PreencherInterface();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherInterface
- Objetivo...: Preencher a interface com os valores do objeto ParEM.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmParEM::PreencherInterface()
{
 MEdtTMEJ->Text  = MinuteToStr(ParEM->TmpMinEntJorn);
 MEdtDMTMT->Text = MinuteToStr(ParEM->DifTMT);
 MEdtHLTPT->Text = MinuteToStr(ParEM->HorLTPTrab);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnOKClick
- Objetivo...: Preencher os valores do objeto ParEM com os valores da interface.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmParEM::BBtnOKClick(TObject *Sender)
{
 try
  {
   ParEM->PreencherAtributos( StrToMinute(MEdtTMEJ->Text), StrToMinute(MEdtDMTMT->Text),
                              StrToMinute(MEdtHLTPT->Text) );

   if (!ParEM->ValoresValidos())
    {
     Beep();
     MessageDlg("Todos os valores devem ser maiores ou iguais a zero, exceto o horrio limite, que deve ser maior que zero e menor do que 24:00!",
                mtError, TMsgDlgButtons() << mbOK, 0);
    }
   else
    Close();
  }
 catch ( ... ) { MessageDlg("Todos os valores devem ser nmeros INTEIROS!",
                            mtError, TMsgDlgButtons() << mbOK, 0); }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnResPadClick
- Objetivo...: Restaurar os valores do objeto (ParEM) e da interface a partir do
               arquivo padro (PPT_EM.par).
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmParEM::BBtnResPadClick(TObject *Sender)
{
 ParEM->LerPadrao();
 PreencherInterface();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnCancelarClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmParEM::BBtnCancelarClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\


