/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmParED                        Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Exibir os valores dos parmetros para a escala
*                            diria.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmParED) referente a tela que contm os
*                            parmetros para a escala diria.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UFrmPrincipal
*     2) UUtil
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmParED.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UFrmPrincipal.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmParED *FrmParED;
//------------------------------------------------------------------------------

__fastcall TFrmParED::TFrmParED(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preencher a interface no momento de exibio da tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmParED::FormShow(TObject *Sender)
{
 PreencherInterface();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherInterface
- Objetivo...: Preencher a interface com os valores do objeto ParED.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmParED::PreencherInterface()
{
 MEdtTMEJ->Text   =  MinuteToStr(ParED->TmpMinEntJorn);
 EdtNTrip->Text   =  IntToStr(ParED->NTrip);
 MEdtTTTrip->Text =  MinuteToStr(ParED->TmpTrocaTrip);
 EdtNMTDP->Text   =  IntToStr(ParED->NMaxTripDP);
 MEdtITRA->Text   =  MinuteToStr(ParED->IntTotRepAli);
 MEdtSICRA->Text  =  MinuteToStr(ParED->SubIntContRA);
 MEdtTMT->Text    =  MinuteToStr(ParED->TmpMaxTrab);
 MEdtTNT->Text    =  MinuteToStr(ParED->TmpNormalTrab);
 MEdtTIDP->Text   =  MinuteToStr(ParED->TmpDPegada);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnOKClick
- Objetivo...: Preencher os valores do objeto ParED com os valores da interface.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmParED::BBtnOKClick(TObject *Sender)
{
 try
  {
   ParED->PreencherAtributos( StrToMinute(MEdtTMEJ->Text), StrToInt(EdtNTrip->Text),
                              StrToMinute(MEdtTTTrip->Text), StrToInt(EdtNMTDP->Text),
                              StrToMinute(MEdtITRA->Text), StrToMinute(MEdtSICRA->Text),
                              StrToMinute(MEdtTMT->Text), StrToMinute(MEdtTNT->Text),
                              StrToMinute(MEdtTIDP->Text) );

   if (!ParED->ValoresValidos())
    {
     Beep();
     MessageDlg("Todos os valores devem ser maiores ou iguais a zero, exceto o n de tripulaes, que deve ser maior que zero!",
                mtError, TMsgDlgButtons() << mbOK, 0);
    }
   else
    Close();
  }
 catch ( ... ) { MessageDlg("Todos os valores devem ser nmeros INTEIROS!",
                            mtError, TMsgDlgButtons() << mbOK, 0); }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnResPadClick
- Objetivo...: Restaurar os valores do objeto (ParED) e da interface a partir do
               arquivo padro (PPT_ED.par).
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmParED::BBtnResPadClick(TObject *Sender)
{
 ParED->LerPadrao();
 PreencherInterface();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnCancelarClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmParED::BBtnCancelarClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\

