/*******************************************************************************
* Dependncia.....: UEstruturaMes; UEscDiaria                                  *
*******************************************************************************/

//------------------------------------------------------------------------------
#ifndef UFrmMesEscMensalH
#define UFrmMesEscMensalH
//------------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UEstruturaMes.h"
#include "UEscDiaria.h"
//------------------------------------------------------------------------------

class TFrmMesEscMensal : public TForm
{
__published:	// IDE-managed Components
        TPanel *PnlMesEscM;
        TPanel *PnlBotoes;
        TBitBtn *BBtnOK;
        TBitBtn *BBtnCorrigir;
        TBitBtn *BBtnCancelar;
        TLabel *Label1;
        TMonthCalendar *MntClrMesEscM;
        TListBox *LstBFeriados;
        TLabel *LblTitulo;
        TBevel *BvlLinha;
        TLabel *LblInfo;

        void __fastcall FormCreate(TObject *Sender);
        void __fastcall MntClrMesEscMDblClick(TObject *Sender);
        void __fastcall BBtnOKClick(TObject *Sender);
        void __fastcall BBtnCorrigirClick(TObject *Sender);
        void __fastcall BBtnCancelarClick(TObject *Sender);

private:
        int Mes, Ano;
        bool SeleMes; // Indica se o ms j foi selecionado ou no.

        TList *LstDom; // Lista com os domingos (int).
        TList *LstFer; // Lista com os feriados (int).
        TList *LstSab; // Lista com os sbados (int).

        TEstruturaMes *EstM; // Objeto que representa uma estrutura de um ms.

        void PreencherListas(int);

public:
        __fastcall TFrmMesEscMensal(TComponent* Owner);

        TEscDiaria *EDU;  // Objeto que representa uma esc. diria para dias teis.
        TEscDiaria *EDF;  // Objeto que representa uma esc. diria para dom. e feriados.
        TEscDiaria *ESab; // Objeto que representa uma esc. diria para sbados.
};
//------------------------------------------------------------------------------
extern PACKAGE TFrmMesEscMensal *FrmMesEscMensal;
//------------------------------------------------------------------------------
#endif
