/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmMesEscMensal                 Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Conter a tela de seleo do ms para a escala mensal.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmMesEscMensal) referente a tela de seleo do
*                            ms para a escala mensal.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UFrmPrincipal
*     2) UUtil
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmMesEscMensal.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UFrmPrincipal.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmMesEscMensal *FrmMesEscMensal;
//------------------------------------------------------------------------------

__fastcall TFrmMesEscMensal::TFrmMesEscMensal(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormCreate
- Objetivo...: Criar as listas com os dias e inicializar a varivel de controle.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmMesEscMensal::FormCreate(TObject *Sender)
{
 LstDom = new TList();
 LstFer = new TList();
 LstSab = new TList();

 SeleMes = false;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: MntClrMesEscMDblClick
- Objetivo...: Selecionar os feriados.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmMesEscMensal::MntClrMesEscMDblClick(TObject *Sender)
{
 Word D, M, A;
 TDateTime Data = MntClrMesEscM->Date;
 DecodeDate(Data, A, M, D);
 bool Achou = false;
 String Aux;

 if (!SeleMes)
  {
   Mes = M;
   Ano = A;
   SeleMes = true;
  }

 if ( (M == Mes) && (A == Ano) )
  {
   for (int i = 0; i < LstBFeriados->Items->Count; i++)
    {
     if (LstBFeriados->Items->Strings[i] == D)
      Achou = true;
    }

   if (!Achou)
    {
     Aux = IntToStr(D);
     if (Aux.Length() == 1)
      Aux = "0" + Aux;
     LstBFeriados->Items->Add(Aux);
    }
  }
 else
  {
   Beep();
   MessageDlg("Os feriados devem pertencer ao mesmo ms!", mtWarning,
              TMsgDlgButtons() << mbOK, 0);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherListas
- Objetivo...: Preencher as listas com os dias do ms.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) NDias -> N de dias no ms selecionado.
============================================================================= */
void TFrmMesEscMensal::PreencherListas(int NDias)
{
 Word D, M, A;
 TDateTime Data = MntClrMesEscM->Date;
 DecodeDate(Data, A, M, D);
 int Aux;

 for (int i = 0; i < LstBFeriados->Items->Count; i++)
  {
   Aux = StrToInt(LstBFeriados->Items->Strings[i]);
   LstFer->Add((void *)Aux);
  }

 for (int i = 1; i <= NDias; i++)
  {
   Data = EncodeDate(A, M, i);
   Aux = Data.DayOfWeek();

   if (Aux == 1)
    LstDom->Add((void *)i);
   else if (Aux == 7)
    LstSab->Add((void *)i);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnOKClick
- Objetivo...: Criar a estrutura referente ao ms selecionado.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmMesEscMensal::BBtnOKClick(TObject *Sender)
{
 Word D, M, A;
 TDateTime Data = MntClrMesEscM->Date;
 DecodeDate(Data, A, M, D);
 int NDias = NumeroDeDiasNoMes(A, M);
 PreencherListas(NDias);
 EstM = new TEstruturaMes(M, A);
 EstM->CriarEstrutura(EDU, EDF, ESab, LstSab, LstDom, LstFer, NDias);
 FrmPrincipal->EstM = EstM;
 FrmPrincipal->SelecionouMes = true;
 Close();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnCorrigirClick
- Objetivo...: Limpar a lista de feriados.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmMesEscMensal::BBtnCorrigirClick(TObject *Sender)
{
 SeleMes = false;
 LstBFeriados->Items->Clear();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnCancelarClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmMesEscMensal::BBtnCancelarClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\



