/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmLerEscDiarias                Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Exibir a tela de seleo das escalas dirias.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmLerEscDiarias) referente a tela que contm
*                            de seleo das esc. dirias para a construo da
*                            escala mensal.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UFrmPrincipal
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmLerEscDiarias.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UFrmPrincipal.h"
//------------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmLerEscDiarias *FrmLerEscDiarias;
//------------------------------------------------------------------------------

__fastcall TFrmLerEscDiarias::TFrmLerEscDiarias(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Inicializar as variveis de controle.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmLerEscDiarias::FormShow(TObject *Sender)
{
 this->LeuEDU  = false;
 this->LeuEDF  = false;
 this->LeuESab = false;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnDEDUClick
- Objetivo...: Selecionar um diretrio para uma escala para dias teis.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmLerEscDiarias::BBtnDEDUClick(TObject *Sender)
{
 if (OpDlgEscDiaria->Execute())
  {
   FrmPrincipal->DirEscDU = OpDlgEscDiaria->FileName;
   EdtDEDU->Text = OpDlgEscDiaria->FileName;
   this->LeuEDU  = true;
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnDEDFClick
- Objetivo...: Selecionar um diretrio para uma escala para domingos e feriados.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmLerEscDiarias::BBtnDEDFClick(TObject *Sender)
{
 if (OpDlgEscDiaria->Execute())
  {
   FrmPrincipal->DirEscDF = OpDlgEscDiaria->FileName;
   EdtDEDF->Text = OpDlgEscDiaria->FileName;
   this->LeuEDF  = true;
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnDESabClick
- Objetivo...: Selecionar um diretrio para uma escala para sbados.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmLerEscDiarias::BBtnDESabClick(TObject *Sender)
{
 if (OpDlgEscDiaria->Execute())
  {
   FrmPrincipal->DirEscSab = OpDlgEscDiaria->FileName;
   EdtDESab->Text = OpDlgEscDiaria->FileName;
   this->LeuESab  = true;
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnConfirmarClick
- Objetivo...: Confirmar a leitura dos diretrios das escalas dirias.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmLerEscDiarias::BBtnConfirmarClick(TObject *Sender)
{
 if (LeuEDU && LeuEDF && LeuESab)
  {
   FrmPrincipal->LeuEscDiarias = true;
   Close();
  }
 else
  {
   Beep();
   MessageDlg("Voc deve selecionar as trs escalas primeiro!",
              mtWarning, TMsgDlgButtons() << mbOK, 0);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnCancelarClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmLerEscDiarias::BBtnCancelarClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\

