/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmJornadas                     Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Conter a tela de exibio das jornadas de uma
*                            tripulao.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmJornadas) referente a tela de exibio de
*                            jornadas.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UEscMensal
*     2) UTripulacoes
*     3) UTar_Jorn
*     4) UUtil
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmJornadas.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UEscMensal.h"
#include "UTripulacoes.h"
#include "UTar_Jorn.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#define max(a, b)  (((a) > (b)) ? (a) : (b))

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmJornadas *FrmJornadas;
//------------------------------------------------------------------------------

__fastcall TFrmJornadas::TFrmJornadas(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preencher o cabealho do grid.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmJornadas::FormShow(TObject *Sender)
{
 StrGJornadas->Cells[1][0]  = "N de dias";
 StrGJornadas->Cells[2][0]  = "Tipo";
 StrGJornadas->Cells[3][0]  = "Pegada";
 StrGJornadas->Cells[4][0]  = "Hor. inicial";
 StrGJornadas->Cells[5][0]  = "Hor. final";
 StrGJornadas->Cells[6][0]  = "T. de trabalho";
 StrGJornadas->Cells[7][0]  = "Horas extra";
 StrGJornadas->Cells[8][0]  = "L. inicial";
 StrGJornadas->Cells[9][0]  = "L. final";
 StrGJornadas->Cells[10][0] = "V. inicial";
 StrGJornadas->Cells[11][0] = "V. final";
 StrGJornadas->Cells[12][0] = "Ociosidade";

 StrGJornadas->Color       = S->CCCTabelas;
 StrGJornadas->FixedColor  = S->CCFTabelas;
 StrGJornadas->Font->Color = S->CFTabelas;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherGrid
- Objetivo...: Preencher o grid com as jornadas da tripulao recebida.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) NTrip -> N da tripulao.
============================================================================= */
void TFrmJornadas::PreencherGrid(int NTrip)
{
 TTripEM *TM;
 TJornada *J;
 TDias *D;
 int lin = 1;

 TM = (TTripEM *)escmensal->LstTripulacoes->Items[NTrip];

 for (int i = 0; i < TM->LstDias->Count; i++)
  {
   D = (TDias *)TM->LstDias->Items[i];

   if (D->Numero != -1)
    {
     if (D->Tipo == 'U')
      J = (TJornada *)EstM->LstJornDU->Items[D->Numero];
     else if (D->Tipo == 'S')
      J = (TJornada *)EstM->LstJornSab->Items[D->Numero];
     else
      J = (TJornada *)EstM->LstJornDF->Items[D->Numero];

     StrGJornadas->Cells[0][lin]  = "Jornada: " + IntToStr(i);
     StrGJornadas->Cells[1][lin]  = IntToStr(D->Qtd);
     if (D->Tipo == 'U')
      StrGJornadas->Cells[2][lin] = "Dia til";
     else if (D->Tipo == 'S')
      StrGJornadas->Cells[2][lin] = "Sbado";
     else if (D->Tipo == 'D')
      StrGJornadas->Cells[2][lin] = "Domingo";
     else
      StrGJornadas->Cells[2][lin] = "Feriado";
     if (J->Tipo == 'S')
      StrGJornadas->Cells[3][lin] = "Simples";
     else
      StrGJornadas->Cells[3][lin] = "Dupla";
     StrGJornadas->Cells[4][lin]  = MinuteToStr(J->HInicio);
     StrGJornadas->Cells[5][lin]  = MinuteToStr(J->HFim);
     StrGJornadas->Cells[6][lin]  = MinuteToStr(J->TmpTrab);
     StrGJornadas->Cells[7][lin]  = MinuteToStr(J->HExtra);
     StrGJornadas->Cells[8][lin]  = J->LinIni;
     StrGJornadas->Cells[9][lin]  = J->LinFin;
     StrGJornadas->Cells[10][lin] = IntToStr(J->VeiIni);
     StrGJornadas->Cells[11][lin] = IntToStr(J->VeiFin);
     StrGJornadas->Cells[12][lin] = MinuteToStr(J->Ocio);
    }
   else
    {
     StrGJornadas->Cells[0][lin] = "Jornada: " + IntToStr(i);
     StrGJornadas->Cells[1][lin] = IntToStr(D->Qtd);
     if (D->Tipo == 'U')
      StrGJornadas->Cells[2][lin] = "Dia til";
     else if (D->Tipo == 'S')
      StrGJornadas->Cells[2][lin] = "Sbado";
     else if (D->Tipo == 'D')
      StrGJornadas->Cells[2][lin] = "Domingo";
     else
      StrGJornadas->Cells[2][lin] = "Feriado";
     StrGJornadas->Cells[3][lin]  = "Folga";
     StrGJornadas->Cells[4][lin]  = "Folga";
     StrGJornadas->Cells[5][lin]  = "Folga";
     StrGJornadas->Cells[6][lin]  = "Folga";
     StrGJornadas->Cells[7][lin]  = "Folga";
     StrGJornadas->Cells[8][lin]  = "Folga";
     StrGJornadas->Cells[9][lin]  = "Folga";
     StrGJornadas->Cells[10][lin] = "Folga";
     StrGJornadas->Cells[11][lin] = "Folga";
     StrGJornadas->Cells[12][lin] = "Folga";
    }
   lin++;
  }

 StrGJornadas->RowCount = max(2, lin);

 this->Caption      = "PPT Solver v2.0 - Jornadas da tripulao " + IntToStr(NTrip);
 LblTitulo->Caption = "Jornadas da tripulao " + IntToStr(NTrip);
 LblFO->Caption     = "Funo objetivo: " + FloatToStr(TM->FncObjetivo);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: FormClose
- Objetivo...: Limpar o grid.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmJornadas::FormClose(TObject *Sender, TCloseAction &Action)
{
 LimparGrid(StrGJornadas);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnFecharClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmJornadas::BBtnFecharClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\

