/*******************************************************************************
* Dependncia.....: UEstruturaMes; UParPpt; UPesos; USimAnn; USistema          *
*******************************************************************************/

//------------------------------------------------------------------------------
#ifndef UFrmEscMensalH
#define UFrmEscMensalH
//------------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Grids.hpp>
#include <Buttons.hpp>
#include <Menus.hpp>
#include <Dialogs.hpp>
#include <ExtCtrls.hpp>
#include <ComCtrls.hpp>

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UEstruturaMes.h"
#include "UParPpt.h"
#include "UPesos.h"
#include "USimAnn.h"
#include "USistema.h"
//------------------------------------------------------------------------------

class TFrmEscMensal : public TForm
{
__published:	// IDE-managed Components
        TPanel *PnlEM;
        TStringGrid *StrGTripulacoes;
        TPopupMenu *PpMTripulacoes;
        TMenuItem *MItExJornadas;
        TSaveDialog *SvDlgEscMensal;
        TSaveDialog *SvDlgResultado;
        TLabel *LblTitulo;
        TBevel *BvlLinha;
        TPanel *PnlBotoes;
        TBitBtn *BBtnFechar;
        TGroupBox *GrpBResultado;
        TBitBtn *BBtnVerRes;
        TBitBtn *BBtnSalvarRes;
        TBitBtn *BBtnVisRes;
        TGroupBox *GrpBEscala;
        TBitBtn *BBtnVisEsc;
        TBitBtn *BBtnSalvarEsc;
        TBitBtn *BBtnAltEM;
        TGroupBox *GrpBSAnn;
        TBitBtn *BBtnInterromperSA;
        TBitBtn *BBtnExecutarSA;
        TPanel *PnlSA;
        TProgressBar *PgBEscMensal;
        TLabel *LblTExec;
        TLabel *LblTTRes;
        TLabel *LblTTAtual;
        TLabel *LblTAtual;
        TLabel *LblTRes;
        TLabel *LblTTExec;
        TLabel *LblTFOSC;
        TLabel *LblTFOMS;
        TLabel *LblFOMS;
        TLabel *LblFOSC;
        TTimer *TmrEscMensal;

        void __fastcall FormShow(TObject *Sender);
        void __fastcall BBtnExecutarSAClick(TObject *Sender);
        void __fastcall BBtnSalvarEscClick(TObject *Sender);
        void __fastcall BBtnVisEscClick(TObject *Sender);
        void __fastcall BBtnFecharClick(TObject *Sender);
        void __fastcall StrGTripulacoesSelectCell(TObject *Sender,
          int ACol, int ARow, bool &CanSelect);
        void __fastcall PpMTripulacoesPopup(TObject *Sender);
        void __fastcall MItExJornadasClick(TObject *Sender);
        void __fastcall BBtnInterromperSAClick(TObject *Sender);
        void __fastcall BBtnAltEMClick(TObject *Sender);
        void __fastcall BBtnVerResClick(TObject *Sender);
        void __fastcall BBtnSalvarResClick(TObject *Sender);
        void __fastcall BBtnVisResClick(TObject *Sender);
        void __fastcall TmrEscMensalTimer(TObject *Sender);

private:
        int NTrip; // N da tripulao selecionada para exibir suas jornadas.

        void PrepararGrid();
        void PreencherGrid();

        void ReaquecerSA();

public:
        __fastcall TFrmEscMensal(TComponent* Owner);

        TEstruturaMes *EstM; // Objeto que representa a estrutura do ms selecionado.
        TParPptEM *ParEM;    // Objeto que representa os par. para a escala mensal.
        TPesosEM *PesEM;     // Objeto que representa os pesos para a escala mensal.
        TSimAnn *SA;         // Objeto que representa o Simulate Annealing.
        TSistema *S;         // Objeto que representa o sistema.
};
//------------------------------------------------------------------------------
extern PACKAGE TFrmEscMensal *FrmEscMensal;
//------------------------------------------------------------------------------
#endif
