/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmEscMensal                    Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Conter a tela de execuo da escala mensal.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmEscMensal) referente a tela de execuo da
*                            escala mensal.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UFrmJornadas                   5) UTripulacoes
*     2) UFrmAltEscMensal               6) UTar_Jorn
*     3) UFrmResultadoEM                7) UResultados
*     4) UEscMensal                     8) UUtil
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmEscMensal.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UFrmJornadas.h"
#include "UFrmAltEscMensal.h"
#include "UFrmResultadoEM.h"
#include "UFrmReaquecerSA.h"

#include "UEscMensal.h"
#include "UTripulacoes.h"
#include "UTar_Jorn.h"
#include "UResultados.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmEscMensal *FrmEscMensal;
//------------------------------------------------------------------------------

__fastcall TFrmEscMensal::TFrmEscMensal(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preparar e preencher o grid; e colocar o SA no estado inicial.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::FormShow(TObject *Sender)
{
 LblTAtual->Caption = FloatToStrF(SA->TprInic, 15, 5, 4);
 SA->EstadoInicial();

 PgBEscMensal->Max = SA->TmpMaxProc * 60;

 StrGTripulacoes->Color       = S->CCCTabelas;
 StrGTripulacoes->FixedColor  = S->CCFTabelas;
 StrGTripulacoes->Font->Color = S->CFTabelas;

 PrepararGrid();
 PreencherGrid();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: TmrEscMensalTimer
- Objetivo...: Incrementar a barra de progresso.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::TmrEscMensalTimer(TObject *Sender)
{
 PgBEscMensal->Position++;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PrepararGrid
- Objetivo...: Limpar e preencher o cabealho do grid.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmEscMensal::PrepararGrid()
{
 LimparGrid(StrGTripulacoes);

 StrGTripulacoes->Cells[1][0] = "Dif. do tempo mdio trabalhado";
 StrGTripulacoes->Cells[2][0] = "N de troc. de tipos de pegada";
 StrGTripulacoes->Cells[3][0] = "N de jornadas diferentes";
 StrGTripulacoes->Cells[4][0] = "Falta de tempo entre jornadas";
 StrGTripulacoes->Cells[5][0] = "N de trocas do per. de trabalho";
 StrGTripulacoes->Cells[6][0] = "Funo obj.";
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherGrid
- Objetivo...: Preencher o grid com os valores da escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmEscMensal::PreencherGrid()
{
 int linT = 1;
 TDias *D;
 TTripEM *T;
 int DTMT;

 for (int i = 0; i < escmensal->LstTripulacoes->Count; i++)
  {
   T = (TTripEM *)escmensal->LstTripulacoes->Items[i];

   StrGTripulacoes->Cells[0][linT] =  "Tripulao: " + IntToStr(i);
   DTMT = escmensal->TmpMedioTrab - T->TmpTTrabalho;
   if (DTMT < 0)
    DTMT = DTMT * (-1);
   StrGTripulacoes->Cells[1][linT] = MinuteToStr(DTMT);
   StrGTripulacoes->Cells[2][linT] = IntToStr(T->NumTrocaTipPeg);
   StrGTripulacoes->Cells[3][linT] = IntToStr(T->NumJornDif);
   StrGTripulacoes->Cells[4][linT] = MinuteToStr(T->TmpEJornadas);
   StrGTripulacoes->Cells[5][linT] = IntToStr(T->NumTroPerTrab);
   StrGTripulacoes->Cells[6][linT] = FloatToStr(T->FncObjetivo);

   linT++;

   StrGTripulacoes->RowCount = linT;
  }

 TDateTime Aux = SA->TempoExec;
 Word H, M, S, MS;
 DecodeTime(Aux, H, M, S, MS);
 int SegExec = (H * 3600) + (M * 60) + S;
 int SegRest = SA->TmpMaxProc * 60;
 int TempoRestante = SegRest - SegExec;

 div_t Aux2;
 Aux2 = div(TempoRestante, 60);
 MS = 0;
 if (TempoRestante > 0)
  {
   S = Aux2.rem;
   M = Aux2.quot;
   Aux2 = div(M, 60);
   M = Aux2.rem;
   H = Aux2.quot;
  }
 else
  {
   S = 0;
   M = 0;
   H = 0;
  }
 TryEncodeTime(H, M, S, MS, Aux);
 LblTRes->Caption = Aux.TimeString();
 LblFOSC->Caption = IntToStr(escmensal->FncObjTotal);
 LblFOMS->Caption = IntToStr(escmensal->FncObjTotal);

 if ( (!BBtnExecutarSA->Enabled) && (!BBtnInterromperSA->Enabled) )
  PgBEscMensal->Position = PgBEscMensal->Max;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: StrGTripulacoesSelectCell
- Objetivo...: Selecionar uma tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::StrGTripulacoesSelectCell(TObject *Sender, int ACol,
                                                         int ARow, bool &CanSelect)
{
 String Aux;

 if (ARow != 0)
  {
   Aux = StrGTripulacoes->Cells[0][ARow];
   Aux = Aux.SubString(13, Aux.Length());
   if (Aux != "")
    NTrip = StrToInt(Aux);
   else
    NTrip = 0;
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PpMTripulacoesPopup
- Objetivo...: Atualizar o "Caption" do menu de seleo de tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::PpMTripulacoesPopup(TObject *Sender)
{
 MItExJornadas->Caption = "Exibir jornadas da tripulao " + IntToStr(NTrip);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: MItExJornadasClick
- Objetivo...: Exibir a tela de exibio de jornadas.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::MItExJornadasClick(TObject *Sender)
{
 FrmJornadas = new TFrmJornadas(Owner);
 FrmJornadas->EstM = EstM;
 FrmJornadas->S    = S;
 FrmJornadas->PreencherGrid(NTrip);
 FrmJornadas->ShowModal();
 FrmJornadas->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ReaquecerSA
- Objetivo...: Exibir a tela de reaquecimento do Simulated Annealing.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmEscMensal::ReaquecerSA()
{
 TmrEscMensal->Enabled = false;

 FrmReaquecerSA = new TFrmReaquecerSA(Owner);
 FrmReaquecerSA->SA = SA;
 FrmReaquecerSA->ShowModal();
 FrmReaquecerSA->Free();

 BBtnExecutarSAClick(Owner);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnExecutarSAClick
- Objetivo...: Executar o Simulated Annealing.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::BBtnExecutarSAClick(TObject *Sender)
{
 TmrEscMensal->Enabled = true;

 StrGTripulacoes->Cursor = crAppStart;
 PnlBotoes->Cursor       = crAppStart;
 GrpBEscala->Cursor      = crAppStart;
 GrpBResultado->Cursor   = crAppStart;
 GrpBSAnn->Cursor        = crAppStart;
 PnlSA->Cursor           = crAppStart;
 PnlEM->Cursor           = crAppStart;

 BBtnInterromperSA->Enabled = true;
 BBtnExecutarSA->Enabled    = false;
 BBtnSalvarEsc->Enabled     = false;
 BBtnVisEsc->Enabled        = false;
 BBtnAltEM->Enabled         = false;
 BBtnVerRes->Enabled        = false;
 BBtnSalvarRes->Enabled     = false;
 BBtnVisRes->Enabled        = false;
 BBtnFechar->Enabled        = false;

 SA->ExecutarEM(EstM, ParEM, PesEM);
 LimparGrid(StrGTripulacoes);
 PrepararGrid();
 PreencherGrid();

 TDateTime Aux = SA->TempoExec;
 Word H, M, S, MS;
 DecodeTime(Aux, H, M, S, MS);
 int Minutos = (H * 60) + M;
 if ( (!SA->CPtprCong) && (SA->TempAtual < SA->TprCong) && (Minutos < SA->TmpMaxProc) && (SA->PodeReaquecer) )
  ReaquecerSA();

 BBtnInterromperSA->Enabled = false;
 BBtnSalvarEsc->Enabled     = true;
 BBtnVisEsc->Enabled        = true;
 BBtnAltEM->Enabled         = true;
 BBtnVerRes->Enabled        = true;
 BBtnSalvarRes->Enabled     = true;
 BBtnVisRes->Enabled        = true;
 BBtnFechar->Enabled        = true;

 StrGTripulacoes->Cursor = crDefault;
 PnlBotoes->Cursor       = crDefault;
 GrpBEscala->Cursor      = crDefault;
 GrpBResultado->Cursor   = crDefault;
 GrpBSAnn->Cursor        = crDefault;
 PnlSA->Cursor           = crDefault;
 PnlEM->Cursor           = crDefault;

 TmrEscMensal->Enabled = false;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnInterromperSAClick
- Objetivo...: Interromper a execuo do Simulated Annealing.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::BBtnInterromperSAClick(TObject *Sender)
{
 BBtnExecutarSA->Enabled = true;
 SA->Status = 1;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnAltEMClick
- Objetivo...: Exibir a tela de alterao da escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::BBtnAltEMClick(TObject *Sender)
{
 FrmAltEscMensal = new TFrmAltEscMensal(Owner);
 FrmAltEscMensal->ParEM = ParEM;
 FrmAltEscMensal->PesEM = PesEM;
 FrmAltEscMensal->EstM = EstM;
 FrmAltEscMensal->S    = S;
 FrmAltEscMensal->ShowModal();
 FrmAltEscMensal->Free();
 escmensal->EfetuarCalculos(EstM, ParEM, PesEM);
 PrepararGrid();
 PreencherGrid();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnSalvarEscClick
- Objetivo...: Salvar a escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::BBtnSalvarEscClick(TObject *Sender)
{
 String File    = "";
 String Filtro  = "";
 String FileAux = "";

 if (SvDlgEscMensal->Execute())
  {
   File = SvDlgEscMensal->FileName.SubString(SvDlgEscMensal->FileName.Length()-3, 1);
   if (File == ".")
    File = SvDlgEscMensal->FileName.SubString(1, SvDlgEscMensal->FileName.Length() - 4);
   else
    File = SvDlgEscMensal->FileName;

   if (SvDlgEscMensal->FilterIndex == 1)
    Filtro = SvDlgEscMensal->Filter.SubString(28, 4);
   else
    Filtro = SvDlgEscMensal->Filter.SubString(55, 4);

   escmensal->GravarEscala(EstM, File + Filtro);
   FileAux = File + Filtro;
   escmensal->GravarArqAux(EstM, FileAux.SubString(1, FileAux.Length()-4) + ".aux");

   Beep();
   MessageDlg("Foi criado um arquivo auxiliar (.aux) no mesmo diretrio para carregar a escala futuramente!",
              mtInformation, TMsgDlgButtons() << mbOK, 0);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnVisEscClick
- Objetivo...: Abrir o arquivo da escala mensal no editor padro da mquina.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::BBtnVisEscClick(TObject *Sender)
{
 String Path = ExtractFilePath(Application->ExeName) + "\\Resultados\\EscM.txt";

 escmensal->GravarEscala(EstM, "");
 char *P = new char[ Path.Length() + 1 ];
 strcpy(P, Path.c_str());
 ShellExecute(Handle, NULL, P, NULL, NULL, SW_SHOWNORMAL);
 delete(P);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnVerResClick
- Objetivo...: Exibir a tela de verificao do resultado da escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::BBtnVerResClick(TObject *Sender)
{
 FrmResultadoEM = new TFrmResultadoEM(Owner);
 FrmResultadoEM->ParEM = ParEM;
 FrmResultadoEM->SA    = SA;
 FrmResultadoEM->ShowModal();
 FrmResultadoEM->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnSalvarResClick
- Objetivo...: Salvar o resultado da escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::BBtnSalvarResClick(TObject *Sender)
{
 String File   = "";
 String Filtro = "";

 if (SvDlgResultado->Execute())
  {
   File = SvDlgResultado->FileName.SubString(SvDlgResultado->FileName.Length()-3, 1);
   if (File == ".")
    File = SvDlgResultado->FileName.SubString(1, SvDlgResultado->FileName.Length() - 4);
   else
    File = SvDlgResultado->FileName;

   if (SvDlgResultado->FilterIndex == 1)
    Filtro = SvDlgResultado->Filter.SubString(45, 4);
   else
    Filtro = SvDlgResultado->Filter.SubString(72, 4);

   TResultadoEM *REM = new TResultadoEM();
   REM->CalcularResultado(escmensal, ParEM, SA);
   REM->GravarResultado(ParEM, PesEM, SA, File + Filtro);
   REM->Free();
   Beep();
   MessageDlg("O resultado da escala mensal foi salvo com sucesso!", mtInformation,
              TMsgDlgButtons() << mbOK, 0);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnVisResClick
- Objetivo...: Abrir o arquivo de resultado no editor padro da mquina.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::BBtnVisResClick(TObject *Sender)
{
 String Path = ExtractFilePath(Application->ExeName) + "\\Resultados\\ResEM.txt";

 TResultadoEM *REM = new TResultadoEM();
 REM->CalcularResultado(escmensal, ParEM, SA);
 REM->GravarResultado(ParEM, PesEM, SA, "");
 REM->Free();
 char *P = new char[ Path.Length() + 1 ];
 strcpy(P, Path.c_str());
 ShellExecute(Handle, NULL, P, NULL, NULL, SW_SHOWNORMAL);
 delete(P);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnFecharClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscMensal::BBtnFecharClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\




