/*******************************************************************************
* Dependncia.....: UParPpt; UPesos; USimAnn; USistema                         *
*******************************************************************************/

//------------------------------------------------------------------------------
#ifndef UFrmEscDiariaH
#define UFrmEscDiariaH
//------------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Grids.hpp>
#include <Buttons.hpp>
#include <Menus.hpp>
#include <Dialogs.hpp>
#include <ExtCtrls.hpp>
#include <ComCtrls.hpp>

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UParPpt.h"
#include "UPesos.h"
#include "USimAnn.h"
#include "USistema.h"
//------------------------------------------------------------------------------

class TFrmEscDiaria : public TForm
{
__published:	// IDE-managed Components
        TPanel *PnlED;
        TStringGrid *StrGTripulacoes;
        TPopupMenu *PpMTripulacoes;
        TMenuItem *MItExTarefas;
        TSaveDialog *SvDlgEscDiaria;
        TSaveDialog *SvDlgResultado;
        TLabel *LblTitulo;
        TBevel *BvlLinha;
        TPanel *PnlBotoes;
        TBitBtn *BBtnFechar;
        TPanel *PnlSA;
        TLabel *LblTFOSC;
        TLabel *LblFOSC;
        TLabel *LblTFOMS;
        TLabel *LblFOMS;
        TLabel *LblTTExec;
        TLabel *LblTExec;
        TLabel *LblTTRest;
        TLabel *LblTRes;
        TLabel *LblTTAtual;
        TLabel *LblTAtual;
        TProgressBar *PgBEscDiaria;
        TGroupBox *GrpBResultado;
        TBitBtn *BBtnVerRes;
        TBitBtn *BBtnSalvarRes;
        TBitBtn *BBtnVisRes;
        TGroupBox *GrpBEscala;
        TBitBtn *BBtnVisEsc;
        TBitBtn *BBtnSalvarEsc;
        TBitBtn *BBtnAltED;
        TGroupBox *GrpBSAnn;
        TBitBtn *BBtnInterromperSA;
        TBitBtn *BBtnExecutarSA;
        TTimer *TmrEscDiaria;

        void __fastcall FormShow(TObject *Sender);
        void __fastcall BBtnExecutarSAClick(TObject *Sender);
        void __fastcall BBtnSalvarEscClick(TObject *Sender);
        void __fastcall BBtnVisEscClick(TObject *Sender);
        void __fastcall BBtnFecharClick(TObject *Sender);
        void __fastcall StrGTripulacoesSelectCell(TObject *Sender,
          int ACol, int ARow, bool &CanSelect);
        void __fastcall PpMTripulacoesPopup(TObject *Sender);
        void __fastcall MItExTarefasClick(TObject *Sender);
        void __fastcall BBtnInterromperSAClick(TObject *Sender);
        void __fastcall BBtnAltEDClick(TObject *Sender);
        void __fastcall BBtnVerResClick(TObject *Sender);
        void __fastcall BBtnSalvarResClick(TObject *Sender);
        void __fastcall BBtnVisResClick(TObject *Sender);
        void __fastcall TmrEscDiariaTimer(TObject *Sender);

private:
        int NTrip; // N da tripulao selecionada para exibir suas tarefas.

        void PrepararGrid();
        void PreencherGrid();

        void ReaquecerSA();

public:
        __fastcall TFrmEscDiaria(TComponent* Owner);

        TParPptED *ParED; // Objeto que representa os par. para a escala diria.
        TPesosED *PesED;  // Objeto que representa os pesos para a escala diria.
        TSimAnn *SA;      // Objeto que representa o Simulate Annealing.
        TSistema *S;      // Objeto que representa o sistema.
};
//------------------------------------------------------------------------------
extern PACKAGE TFrmEscDiaria *FrmEscDiaria;
//------------------------------------------------------------------------------
#endif
