/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmEscDiaria                    Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Conter a tela de execuo da escala diria.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmEscDiaria) referente a tela de execuo da
*                            escala diria.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UFrmTarefas                    5) UTripulacoes
*     2) UFrmAltEscDiaria               6) UTar_Jorn
*     3) UFrmResultadoED                7) UResultados
*     4) UEscDiaria                     8) UUtil
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmEscDiaria.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UFrmTarefas.h"
#include "UFrmAltEscDiaria.h"
#include "UFrmResultadoED.h"
#include "UFrmReaquecerSA.h"

#include "UEscDiaria.h"
#include "UTripulacoes.h"
#include "UTar_Jorn.h"
#include "UResultados.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmEscDiaria *FrmEscDiaria;
//------------------------------------------------------------------------------

__fastcall TFrmEscDiaria::TFrmEscDiaria(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preparar e preencher o grid; e colocar o SA no estado inicial.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::FormShow(TObject *Sender)
{
 LblTAtual->Caption = FloatToStrF(SA->TprInic, 15, 5, 4);
 SA->EstadoInicial();

 PgBEscDiaria->Max = SA->TmpMaxProc * 60;

 StrGTripulacoes->Color       = S->CCCTabelas;
 StrGTripulacoes->FixedColor  = S->CCFTabelas;
 StrGTripulacoes->Font->Color = S->CFTabelas;

 PrepararGrid();
 PreencherGrid();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: TmrEscDiariaTimer
- Objetivo...: Incrementar a barra de progresso.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::TmrEscDiariaTimer(TObject *Sender)
{
 PgBEscDiaria->Position++;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PrepararGrid
- Objetivo...: Limpar e preencher o cabealho do grid.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmEscDiaria::PrepararGrid()
{
 LimparGrid(StrGTripulacoes);

 StrGTripulacoes->Cells[1][0]  = "N de tarefas";
 StrGTripulacoes->Cells[2][0]  = "F. acum. total";
 StrGTripulacoes->Cells[3][0]  = "T. total trab.";
 StrGTripulacoes->Cells[4][0]  = "T. ocioso";
 StrGTripulacoes->Cells[5][0]  = "H. extra";
 StrGTripulacoes->Cells[6][0]  = "T. de sobrep.";
 StrGTripulacoes->Cells[7][0]  = "D.Pegada";
 StrGTripulacoes->Cells[8][0]  = "N trocas vec.";
 StrGTripulacoes->Cells[9][0]  = "N trocas linha proib.";
 StrGTripulacoes->Cells[10][0] = "N trocas linha perm.";
 StrGTripulacoes->Cells[11][0] = "N trocas pto proib.";
 StrGTripulacoes->Cells[12][0] = "N trocas pto perm.";
 StrGTripulacoes->Cells[13][0] = "T. entre jornadas";
 StrGTripulacoes->Cells[14][0] = "Funo obj.";
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherGrid
- Objetivo...: Preencher o grid com os valores da escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmEscDiaria::PreencherGrid()
{
 int linT = 1;

 TTarefa *T;
 TTripED *Trip;

// Ordenar a lista de tripulaes pelo horrio de incio da primeira tarefa.
// escdiaria->LstTripulacoes->Sort(OrdenaTripHIni);

 for (int i = 0; i < escdiaria->LstTripulacoes->Count; i++)
  {
   Trip = (TTripED *)escdiaria->LstTripulacoes->Items[i];

   StrGTripulacoes->Cells[0][linT] = "Tripulao: " + IntToStr(i);
   StrGTripulacoes->Cells[1][linT] = IntToStr(Trip->NTarefas);
   StrGTripulacoes->Cells[2][linT] = MinuteToStr(Trip->FolAcuTotal);
   StrGTripulacoes->Cells[3][linT] = MinuteToStr(Trip->TmpTTrabalho);
   StrGTripulacoes->Cells[4][linT] = MinuteToStr(Trip->TmpOcioso);
   StrGTripulacoes->Cells[5][linT] = MinuteToStr(Trip->HExtra);
   StrGTripulacoes->Cells[6][linT] = MinuteToStr(Trip->TmpSobreposicao);

   if (Trip->NDPegadas == 1)
    StrGTripulacoes->Cells[7][linT] = "Sim";
   else
    StrGTripulacoes->Cells[7][linT] = "No";

   StrGTripulacoes->Cells[8][linT]  = IntToStr(Trip->NTVeiculos);
   StrGTripulacoes->Cells[9][linT]  = IntToStr(Trip->NTLProibidas );
   StrGTripulacoes->Cells[10][linT] = IntToStr(Trip->NTLPermitidas);
   StrGTripulacoes->Cells[11][linT] = IntToStr(Trip->NTPProibidas );
   StrGTripulacoes->Cells[12][linT] = IntToStr(Trip->NTPPermitidas);
   StrGTripulacoes->Cells[13][linT] = MinuteToStr(Trip->TmpEJornadas);
   StrGTripulacoes->Cells[14][linT] = FloatToStr(Trip->FncObjetivo);

   linT++;

   StrGTripulacoes->RowCount = linT;
  }

 TDateTime Aux = SA->TempoExec;
 Word H, M, S, MS;
 DecodeTime(Aux, H, M, S, MS);
 int SegExec = (H * 3600) + (M * 60) + S;
 int SegRest = SA->TmpMaxProc * 60;
 int TempoRestante = SegRest - SegExec;

 div_t Aux2;
 Aux2 = div(TempoRestante, 60);
 MS = 0;
 if (TempoRestante > 0)
  {
   S = Aux2.rem;
   M = Aux2.quot;
   Aux2 = div(M, 60);
   M = Aux2.rem;
   H = Aux2.quot;
  }
 else
  {
   S = 0;
   M = 0;
   H = 0;
  }
 TryEncodeTime(H, M, S, MS, Aux);
 LblTRes->Caption = Aux.TimeString();
 LblFOSC->Caption = IntToStr(escdiaria->FncObjTotal);
 LblFOMS->Caption = IntToStr(escdiaria->FncObjTotal);

 if ( (!BBtnExecutarSA->Enabled) && (!BBtnInterromperSA->Enabled) )
  PgBEscDiaria->Position = PgBEscDiaria->Max;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: StrGTripulacoesSelectCell
- Objetivo...: Selecionar uma tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::StrGTripulacoesSelectCell(TObject *Sender, int ACol,
                                                         int ARow, bool &CanSelect)
{
 String Aux;

 if (ARow != 0)
  {
   Aux = StrGTripulacoes->Cells[0][ARow];
   Aux = Aux.SubString(13, Aux.Length());
   if (Aux != "")
    NTrip = StrToInt(Aux);
   else
    NTrip = 0;
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PpMTripulacoesPopup
- Objetivo...: Atualizar o "Caption" do menu de seleo de tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::PpMTripulacoesPopup(TObject *Sender)
{
 MItExTarefas->Caption = "Exibir tarefas da tripulao " + IntToStr(NTrip);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: MItExTarefasClick
- Objetivo...: Exibir a tela de exibio de tarefas.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::MItExTarefasClick(TObject *Sender)
{
 FrmTarefas = new TFrmTarefas(Owner);
 FrmTarefas->S = S;
 FrmTarefas->PreencherGrid(NTrip);
 FrmTarefas->ShowModal();
 FrmTarefas->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: ReaquecerSA
- Objetivo...: Exibir a tela de reaquecimento do Simulated Annealing.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmEscDiaria::ReaquecerSA()
{
 TmrEscDiaria->Enabled = false;

 FrmReaquecerSA = new TFrmReaquecerSA(Owner);
 FrmReaquecerSA->SA = SA;
 FrmReaquecerSA->ShowModal();
 FrmReaquecerSA->Free();

 BBtnExecutarSAClick(Owner);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnExecutarSAClick
- Objetivo...: Executar o Simulated Annealing.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::BBtnExecutarSAClick(TObject *Sender)
{
 TmrEscDiaria->Enabled = true;

 StrGTripulacoes->Cursor = crAppStart;
 PnlBotoes->Cursor       = crAppStart;
 GrpBEscala->Cursor      = crAppStart;
 GrpBResultado->Cursor   = crAppStart;
 GrpBSAnn->Cursor        = crAppStart;
 PnlSA->Cursor           = crAppStart;
 PnlED->Cursor           = crAppStart;

 BBtnInterromperSA->Enabled = true;
 BBtnExecutarSA->Enabled    = false;
 MItExTarefas->Enabled      = false;
 BBtnSalvarEsc->Enabled     = false;
 BBtnVisEsc->Enabled        = false;
 BBtnAltED->Enabled         = false;
 BBtnVerRes->Enabled        = false;
 BBtnSalvarRes->Enabled     = false;
 BBtnVisRes->Enabled        = false;
 BBtnFechar->Enabled        = false;

 SA->ExecutarED(ParED, PesED);
 LimparGrid(StrGTripulacoes);
 PrepararGrid();
 PreencherGrid();

 TDateTime Aux = SA->TempoExec;
 Word H, M, S, MS;
 DecodeTime(Aux, H, M, S, MS);
 int Minutos = (H * 60) + M;
 if ( (!SA->CPtprCong) && (SA->TempAtual < SA->TprCong) && (Minutos < SA->TmpMaxProc) && (SA->PodeReaquecer))
  ReaquecerSA();

 BBtnInterromperSA->Enabled = false;
 MItExTarefas->Enabled      = true;
 BBtnSalvarEsc->Enabled     = true;
 BBtnVisEsc->Enabled        = true;
 BBtnAltED->Enabled         = true;
 BBtnVerRes->Enabled        = true;
 BBtnSalvarRes->Enabled     = true;
 BBtnVisRes->Enabled        = true;
 BBtnFechar->Enabled        = true;

 StrGTripulacoes->Cursor = crDefault;
 PnlBotoes->Cursor       = crDefault;
 GrpBEscala->Cursor      = crDefault;
 GrpBResultado->Cursor   = crDefault;
 GrpBSAnn->Cursor        = crDefault;
 PnlSA->Cursor           = crDefault;
 PnlED->Cursor           = crDefault;

 TmrEscDiaria->Enabled = false;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnInterromperSAClick
- Objetivo...: Interromper a execuo do Simulated Annealing.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::BBtnInterromperSAClick(TObject *Sender)
{
 BBtnExecutarSA->Enabled = true;
 SA->Status = 1;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnAltEDClick
- Objetivo...: Exibir a tela de alterao da escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::BBtnAltEDClick(TObject *Sender)
{
 FrmAltEscDiaria = new TFrmAltEscDiaria(Owner);
 FrmAltEscDiaria->ParED = ParED;
 FrmAltEscDiaria->PesED = PesED;
 FrmAltEscDiaria->S     = S;
 FrmAltEscDiaria->ShowModal();
 FrmAltEscDiaria->Free();
 escdiaria->EfetuarCalculos(ParED, PesED);
 PrepararGrid();
 PreencherGrid();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnSalvarEscClick
- Objetivo...: Salvar a escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::BBtnSalvarEscClick(TObject *Sender)
{
 String File   = "";
 String Filtro = "";

 if (SvDlgEscDiaria->Execute())
  {
   File = SvDlgEscDiaria->FileName.SubString(SvDlgEscDiaria->FileName.Length()-3, 1);
   if (File == ".")
    File = SvDlgEscDiaria->FileName.SubString(1, SvDlgEscDiaria->FileName.Length() - 4);
   else
    File = SvDlgEscDiaria->FileName;

   if (SvDlgEscDiaria->FilterIndex == 1)
    Filtro = SvDlgEscDiaria->Filter.SubString(28, 4);
   else
    Filtro = SvDlgEscDiaria->Filter.SubString(55, 4);

   escdiaria->GravarEscala(File + Filtro);
   Beep();
   MessageDlg("A escala diria foi salva com sucesso!", mtInformation,
              TMsgDlgButtons() << mbOK, 0);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnVisEscClick
- Objetivo...: Abrir o arquivo da escala diria no editor padro da mquina.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::BBtnVisEscClick(TObject *Sender)
{
 String Path;

 if (escdiaria->Tipo == 'U')
  Path = ExtractFilePath(Application->ExeName) + "\\Resultados\\EsDU.txt";
 else if (escdiaria->Tipo == 'D')
  Path = ExtractFilePath(Application->ExeName) + "\\Resultados\\EsDF.txt";
 else if (escdiaria->Tipo == 'S')
  Path = ExtractFilePath(Application->ExeName) + "\\Resultados\\EsSab.txt";

 escdiaria->GravarEscala("");
 char *P = new char[ Path.Length() + 1 ];
 strcpy(P, Path.c_str());
 ShellExecute(Handle, NULL, P, NULL, NULL, SW_SHOWNORMAL);
 delete(P);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnVerResClick
- Objetivo...: Exibir a tela de verificao do resultado da escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::BBtnVerResClick(TObject *Sender)
{
 FrmResultadoED = new TFrmResultadoED(Owner);
 FrmResultadoED->ParED = ParED;
 FrmResultadoED->SA = SA;
 FrmResultadoED->ShowModal();
 FrmResultadoED->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnSalvarResClick
- Objetivo...: Salvar o resultado da escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::BBtnSalvarResClick(TObject *Sender)
{
 String File   = "";
 String Filtro = "";

 if (SvDlgResultado->Execute())
  {
   File = SvDlgResultado->FileName.SubString(SvDlgResultado->FileName.Length()-3, 1);
   if (File == ".")
    File = SvDlgResultado->FileName.SubString(1, SvDlgResultado->FileName.Length() - 4);
   else
    File = SvDlgResultado->FileName;

   if (SvDlgResultado->FilterIndex == 1)
    Filtro = SvDlgResultado->Filter.SubString(45, 4);
   else
    Filtro = SvDlgResultado->Filter.SubString(72, 4);

   TResultadoED *RED = new TResultadoED();
   RED->CalcularResultado(escdiaria, ParED, SA);
   RED->GravarResultado(escdiaria, ParED, PesED, SA, File + Filtro);
   RED->Free();
   Beep();
   MessageDlg("O resultado da escala diria foi salvo com sucesso!", mtInformation,
              TMsgDlgButtons() << mbOK, 0);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnVisResClick
- Objetivo...: Abrir o arquivo de resultado no editor padro da mquina.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::BBtnVisResClick(TObject *Sender)
{
 String Path;

 if (escdiaria->Tipo == 'U')
  Path = ExtractFilePath(Application->ExeName) + "\\Resultados\\ResDU.txt";
 else if (escdiaria->Tipo == 'D')
  Path = ExtractFilePath(Application->ExeName) + "\\Resultados\\ResDF.txt";
 else if (escdiaria->Tipo == 'S')
  Path = ExtractFilePath(Application->ExeName) + "\\Resultados\\ResSab.txt";

 TResultadoED *RED = new TResultadoED();
 RED->CalcularResultado(escdiaria, ParED, SA);
 RED->GravarResultado(escdiaria, ParED, PesED, SA, "");
 RED->Free();
 char *P = new char[ Path.Length() + 1 ];
 strcpy(P, Path.c_str());
 ShellExecute(Handle, NULL, P, NULL, NULL, SW_SHOWNORMAL);
 delete(P);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnFecharClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmEscDiaria::BBtnFecharClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\


