/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmAltValPad                    Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Conter a tela de alterao dos "valores padro".
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmAltValPad) referente a tela de alterao dos
*                            valores padro.
* Obs......................: O arquivo .h dessa unit NO foi alterado.
* Dependncias.............:
*     1) UUtil
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmAltValPad.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UUtil.cpp"
//------------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmAltValPad *FrmAltValPad;
//------------------------------------------------------------------------------

__fastcall TFrmAltValPad::TFrmAltValPad(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preencher a interface no momento de exibio da tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltValPad::FormShow(TObject *Sender)
{
 this->PreencherIntSA();
 this->PreencherIntParED();
 this->PreencherIntParEM();
 this->PreencherIntPesED();
 this->PreencherIntPesEM();
}
//------------------------------------------------------------------------------


                        // ----- SIMULATE ANNEALING ----- \\

/* =============================================================================
- Mtodo.....: PreencherInterface
- Objetivo...: Preencher a interface com os valores do objeto SA.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmAltValPad::PreencherIntSA()
{
 SA = new TSimAnn();
 SA->LerPadrao();
 EdtNMI->Text  = IntToStr(SA->NumMaxIte);
 EdtTI->Text   = FloatToStr(SA->TprInic);
 EdtTC->Text   = FloatToStr(SA->TprCong);
 EdtTR->Text   = FloatToStr(SA->TxResf);
 MEdtTMP->Text = MinuteToStr(SA->TmpMaxProc);
 ChkBCPTMP->Checked = SA->CPtmMaxProc;
 ChkBCPTC->Checked  = SA->CPtprCong;
 SA->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnAltSAClick
- Objetivo...: Alterar os valores padro do Simulated Annealing.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltValPad::BBtnAltSAClick(TObject *Sender)
{
 SA = new TSimAnn();
 try
  {
   SA->PreencherAtributos( StrToInt(EdtNMI->Text), StrToFloat(EdtTR->Text),
                           StrToFloat(EdtTI->Text), StrToFloat(EdtTC->Text),
                           StrToMinute(MEdtTMP->Text), ChkBCPTC->Checked,
                           ChkBCPTMP->Checked );

   if (!SA->ValoresValidos())
    {
     Beep();
     MessageDlg("Todos os valores devem ser maiores do que zero, exceto a TAXA DE RESFRIAMENTO, que deve ser maior que ZERO e menor que UM!",
                mtWarning, TMsgDlgButtons() << mbOK, 0);
    }
   else
    SA->GravarPadrao();
  }
 catch ( ... ) { MessageDlg("O NMERO DE ITERAES e o TEMPO DE PROCESSAMENTO devem ser nmeros INTEIROS e os demais parmetros, nmeros REAIS!",
                            mtError, TMsgDlgButtons() << mbOK, 0); }
 SA->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnDefSAClick
- Objetivo...: Restaurar o padro do Simulated Annealing para os valores default.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltValPad::BBtnDefSAClick(TObject *Sender)
{
 SA = new TSimAnn();
 SA->LerDefault();
 SA->GravarPadrao();
 this->PreencherIntSA();
 SA->Free();
}
//------------------------------------------------------------------------------


                        // ----- PARMETROS ----- \\

/* =============================================================================
- Mtodo.....: PreencherInterface
- Objetivo...: Preencher a interface com os valores do objeto ParED.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmAltValPad::PreencherIntParED()
{
 ParED = new TParPptED();
 ParED->LerPadrao();
 MEdtTMEJD->Text  =  MinuteToStr(ParED->TmpMinEntJorn);
 EdtNTrip->Text   =  IntToStr(ParED->NTrip);
 MEdtTTTrip->Text =  MinuteToStr(ParED->TmpTrocaTrip);
 EdtNMTDP->Text   =  IntToStr(ParED->NMaxTripDP);
 MEdtITRA->Text   =  MinuteToStr(ParED->IntTotRepAli);
 MEdtSICRA->Text  =  MinuteToStr(ParED->SubIntContRA);
 MEdtTMT->Text    =  MinuteToStr(ParED->TmpMaxTrab);
 MEdtTNT->Text    =  MinuteToStr(ParED->TmpNormalTrab);
 MEdtTIDP->Text   =  MinuteToStr(ParED->TmpDPegada);
 ParED->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnAltParEDClick
- Objetivo...: Alterar os valores padro dos parmetros para a escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltValPad::BBtnAltParEDClick(TObject *Sender)
{
 ParED = new TParPptED();
 try
  {
   ParED->PreencherAtributos( StrToMinute(MEdtTMEJD->Text), StrToInt(EdtNTrip->Text),
                              StrToMinute(MEdtTTTrip->Text), StrToInt(EdtNMTDP->Text),
                              StrToMinute(MEdtITRA->Text), StrToMinute(MEdtSICRA->Text),
                              StrToMinute(MEdtTMT->Text), StrToMinute(MEdtTNT->Text),
                              StrToMinute(MEdtTIDP->Text) );

   if (!ParED->ValoresValidos())
    {
     Beep();
     MessageDlg("Todos os valores devem ser maiores ou iguais a zero, exceto o n de tripulaes, que deve ser maior que zero!",
                mtError, TMsgDlgButtons() << mbOK, 0);
    }
   else
    ParED->GravarPadrao();
  }
 catch ( ... ) { MessageDlg("Todos os valores devem ser nmeros INTEIROS!",
                            mtError, TMsgDlgButtons() << mbOK, 0); }
 ParED->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnDefParEDClick
- Objetivo...: Restaurar o padro do parmetros (esc. diria) para os valores default.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltValPad::BBtnDefParEDClick(TObject *Sender)
{
 ParED = new TParPptED();
 ParED->LerDefault();
 ParED->GravarPadrao();
 this->PreencherIntParED();
 ParED->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherInterface
- Objetivo...: Preencher a interface com os valores do objeto ParEM.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmAltValPad::PreencherIntParEM()
{
 ParEM = new TParPptEM();
 ParEM->LerPadrao();
 MEdtTMEJM->Text = MinuteToStr(ParEM->TmpMinEntJorn);
 MEdtDMTMT->Text = MinuteToStr(ParEM->DifTMT);
 MEdtHLTPT->Text = MinuteToStr(ParEM->HorLTPTrab);
 ParEM->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnAltParEMClick
- Objetivo...: Alterar os valores padro dos parmetros para a escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltValPad::BBtnAltParEMClick(TObject *Sender)
{
 ParEM = new TParPptEM();
 try
  {
   ParEM->PreencherAtributos( StrToMinute(MEdtTMEJM->Text), StrToMinute(MEdtDMTMT->Text),
                              StrToMinute(MEdtHLTPT->Text) );

   if (!ParEM->ValoresValidos())
    {
     Beep();
     MessageDlg("Todos os valores devem ser maiores ou iguais a zero, exceto o horrio limite, que deve ser maior que zero e menor do que 24:00!",
                mtError, TMsgDlgButtons() << mbOK, 0);
    }
   else
    ParEM->GravarPadrao();
  }
 catch ( ... ) { MessageDlg("Todos os valores devem ser nmeros INTEIROS!",
                            mtError, TMsgDlgButtons() << mbOK, 0); }
 ParEM->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnDefParEMClick
- Objetivo...: Restaurar o padro do parmetros (esc. mensal) para os valores default.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltValPad::BBtnDefParEMClick(TObject *Sender)
{
 ParEM = new TParPptEM();
 ParEM->LerDefault();
 ParEM->GravarPadrao();
 this->PreencherIntParEM();
 ParEM->Free();
}
//------------------------------------------------------------------------------


                        // ----- PESOS ----- \\

/* =============================================================================
- Mtodo.....: PreencherInterface
- Objetivo...: Preencher a interface com os valores do objeto PesED.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmAltValPad::PreencherIntPesED()
{
 PesED = new TPesosED();
 PesED->LerPadrao();
 EdtPFTEJD->Text = IntToStr(PesED->PTEJornadas);
 EdtPNTrip->Text = IntToStr(PesED->PNumTrip);
 EdtPTO->Text    = IntToStr(PesED->PTOcioso);
 EdtPETTT->Text  = IntToStr(PesED->PTTTrabalho);
 EdtPHE->Text    = IntToStr(PesED->PHExtra);
 EdtPTS->Text    = IntToStr(PesED->PTSobreposicao);
 EdtPTPPro->Text = IntToStr(PesED->PTPProibidas);
 EdtPTPPer->Text = IntToStr(PesED->PTPPermitidas);
 EdtPTLPro->Text = IntToStr(PesED->PTLProibidas);
 EdtPTLPer->Text = IntToStr(PesED->PTPPermitidas);
 EdtPTVei->Text  = IntToStr(PesED->PTVeiculos);
 EdtPETDP->Text  = IntToStr(PesED->PNMaxTripDP);
 PesED->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnAltPesEDClick
- Objetivo...: Alterar os valores padro dos pesos para a escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltValPad::BBtnAltPesEDClick(TObject *Sender)
{
 PesED = new TPesosED();
 try
  {
   PesED->PreencherAtributos( StrToInt(EdtPFTEJD->Text),
                              StrToInt(EdtPNTrip->Text),
                              StrToInt(EdtPTO->Text),
                              StrToInt(EdtPETTT->Text),
                              StrToInt(EdtPHE->Text),
                              StrToInt(EdtPTS->Text),
                              StrToInt(EdtPTPPro->Text),
                              StrToInt(EdtPTPPer->Text),
                              StrToInt(EdtPTLPro->Text),
                              StrToInt(EdtPTLPer->Text),
                              StrToInt(EdtPTVei->Text),
                              StrToInt(EdtPETDP->Text) );
   if (!PesED->ValoresValidos())
    {
     Beep();
     MessageDlg("Todos os valores devem ser maiores ou iguais a zero!",
                mtError, TMsgDlgButtons() << mbOK, 0);
    }
   else
    PesED->GravarPadrao();
  }
 catch ( ... ) { MessageDlg("Todos os valores devem ser nmeros INTEIROS!",
                            mtError, TMsgDlgButtons() << mbOK, 0); }
 PesED->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnDefPesEDClick
- Objetivo...: Restaurar o padro do pesos (esc. diria) para os valores default.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltValPad::BBtnDefPesEDClick(TObject *Sender)
{
 PesED = new TPesosED();
 PesED->LerDefault();
 PesED->GravarPadrao();
 this->PreencherIntPesED();
 PesED->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherInterface
- Objetivo...: Preencher a interface com os valores do objeto PesEM.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TFrmAltValPad::PreencherIntPesEM()
{
 PesEM = new TPesosEM();
 PesEM->LerPadrao();
 EdtPFTEJM->Text = IntToStr(PesEM->PTEJornadas);
 EdtPEDTMT->Text = IntToStr(PesEM->PTMedioTrab);
 EdtPNJD->Text   = IntToStr(PesEM->PNJorD);
 EdtPNTTP->Text  = IntToStr(PesEM->PNTTPeg);
 EdtPNTPT->Text  = IntToStr(PesEM->PNTPTrab);
 PesEM->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnAltPesEMClick
- Objetivo...: Alterar os valores padro dos pesos para a escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltValPad::BBtnAltPesEMClick(TObject *Sender)
{
 PesEM = new TPesosEM();
 try
  {
   PesEM->PreencherAtributos( StrToInt(EdtPFTEJM->Text), StrToInt(EdtPEDTMT->Text),
                              StrToInt(EdtPNJD->Text), StrToInt(EdtPNTTP->Text),
                              StrToInt(EdtPNTPT->Text) );
   if (!PesEM->ValoresValidos())
    {
     Beep();
     MessageDlg("Todos os valores devem ser maiores ou iguais a zero!",
                mtError, TMsgDlgButtons() << mbOK, 0);
    }
   else
    PesEM->GravarPadrao();
  }
 catch ( ... ) { MessageDlg("Todos os valores devem ser nmeros INTEIROS!",
                            mtError, TMsgDlgButtons() << mbOK, 0); }
 PesEM->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnDefPesEMClick
- Objetivo...: Restaurar o padro do pesos (esc. mensal) para os valores default.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltValPad::BBtnDefPesEMClick(TObject *Sender)
{
 PesEM = new TPesosEM();
 PesEM->LerDefault();
 PesEM->GravarPadrao();
 this->PreencherIntPesEM();
 PesEM->Free();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnFecharClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltValPad::BBtnFecharClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
