/*******************************************************************************
* Dependncia.....: UParPpt; UPesos; UEstruturaMes; USistema                   *
*******************************************************************************/

//------------------------------------------------------------------------------
#ifndef UFrmAltEscMensalH
#define UFrmAltEscMensalH
//------------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <Grids.hpp>
#include <ExtCtrls.hpp>

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UParPpt.h"
#include "UPesos.h"
#include "UEstruturaMes.h"
#include "USistema.h"
//------------------------------------------------------------------------------

class TFrmAltEscMensal : public TForm
{
__published:	// IDE-managed Components
        TPanel *PnlED;
        TLabel *LblTitulo;
        TBevel *BvlLinha;
        TLabel *LblInfo;
        TBitBtn *BBtnFechar;
        TPanel *PnlTrip1;
        TLabel *LblTFncObjTrip1;
        TLabel *LblFncObjTrip1;
        TStringGrid *StrGJorTrip1;
        TPanel *PnlTrip2;
        TLabel *LblTFncObjTrip2;
        TLabel *LblFncObjTrip2;
        TStringGrid *StrGJorTrip2;
        TPanel *PnlTrip;
        TLabel *LblTrip;
        TListBox *LstBTrip1;
        TListBox *LstBTrip2;
        TBitBtn *BBtnInsTrip;
        TBitBtn *BBtnRemTrip;

        void __fastcall FormShow(TObject *Sender);
        void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
        void __fastcall BBtnInsTripClick(TObject *Sender);
        void __fastcall BBtnRemTripClick(TObject *Sender);
        void __fastcall BBtnFecharClick(TObject *Sender);
        void __fastcall StrGJorTrip1DblClick(TObject *Sender);
        void __fastcall StrGJorTrip1SelectCell(TObject *Sender, int ACol,
          int ARow, bool &CanSelect);
        void __fastcall StrGJorTrip2SelectCell(TObject *Sender, int ACol,
          int ARow, bool &CanSelect);
        void __fastcall StrGJorTrip2DblClick(TObject *Sender);
        void __fastcall LstBTrip1Click(TObject *Sender);
        void __fastcall LstBTrip2Click(TObject *Sender);

private:
        int Trip1;        // N de uma das tripulaes da troca.
        int Trip2;        // N de uma das tripulaes da troca.
        int NumJornada;   // N da jornada.
        bool TemJornada1; // Verifica se uma jornada foi selecionada no grid 1.
        bool TemJornada2; // Verifica se uma jornada foi selecionada no grid 2.

        void PrepararGrid();
        void PreencherGrid();

public:
        __fastcall TFrmAltEscMensal(TComponent* Owner);

        TParPptEM *ParEM;    // Objeto que representa os par. para a escala mensal.
        TPesosEM *PesEM;     // Objeto que representa os pesos para a escala mensal.
        TEstruturaMes *EstM; // Objeto que representa a estrutura do ms selecionado.
        TSistema *S;         // Objeto que representa o sistema.

        void PrepararGrid(TStringGrid *);
        void PreencherGrid(TStringGrid *, int);
        void PreencherLstBox(int);
        void AtualizarGrids(int);
};
//------------------------------------------------------------------------------
extern PACKAGE TFrmAltEscMensal *FrmAltEscMensal;
//------------------------------------------------------------------------------
#endif
