/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmAltEscMensal                 Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Conter a tela de alterao manual da escala mensal.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmAltEscMensal) referente a tela de alterao da
*                            escala mensal.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UEscMensal
*     2) UTripulacoes
*     3) UTar_Jorn
*     4) UUtil
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmAltEscMensal.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UEscMensal.h"
#include "UTripulacoes.h"
#include "UTar_Jorn.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#define max(a, b)  (((a) > (b)) ? (a) : (b))

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmAltEscMensal *FrmAltEscMensal;
//------------------------------------------------------------------------------

__fastcall TFrmAltEscMensal::TFrmAltEscMensal(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preparar os grids e os listbox.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscMensal::FormShow(TObject *Sender)
{
 PrepararGrid(StrGJorTrip1);
 PrepararGrid(StrGJorTrip2);
 PreencherLstBox(escmensal->LstTripulacoes->Count);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PrepararGrid
- Objetivo...: Limpar e preencher o cabealho do grid recebido.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) Grid -> Grid a ser preparado.
============================================================================= */
void TFrmAltEscMensal::PrepararGrid(TStringGrid *Grid)
{
 LimparGrid(Grid);

 Grid->Cells[1][0]  = "N de dias";
 Grid->Cells[2][0]  = "Tipo";
 Grid->Cells[3][0]  = "Pegada";
 Grid->Cells[4][0]  = "Hor. inicial";
 Grid->Cells[5][0]  = "Hor. final";
 Grid->Cells[6][0]  = "T. de trabalho";
 Grid->Cells[7][0]  = "Horas extra";
 Grid->Cells[8][0]  = "L. inicial";
 Grid->Cells[9][0]  = "L. final";
 Grid->Cells[10][0] = "V. inicial";
 Grid->Cells[11][0] = "V. final";
 Grid->Cells[12][0] = "Ociosidade";

 Grid->Color       = S->CCCTabelas;
 Grid->FixedColor  = S->CCFTabelas;
 Grid->Font->Color = S->CFTabelas;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherGrid
- Objetivo...: Preencher o grid recebido por parmetro com os valores da
               tripulao (tambm recebida por parmetro).
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) Grid  -> Grid a ser preenchido.
   2) NTrip -> N da tripulao.
============================================================================= */
void TFrmAltEscMensal::PreencherGrid(TStringGrid *Grid, int NTrip)
{
 int lin = 1;
 TTripEM *TM;
 TJornada *J;
 TDias *D;

 TM = (TTripEM *)escmensal->LstTripulacoes->Items[NTrip];

 for (int i = 0; i < TM->LstDias->Count; i++)
  {
   D = (TDias *)TM->LstDias->Items[i];

   if (D->Numero != -1)
    {
     if (D->Tipo == 'U')
      J = (TJornada *)EstM->LstJornDU->Items[D->Numero];
     else if (D->Tipo == 'S')
      J = (TJornada *)EstM->LstJornSab->Items[D->Numero];
     else
      J = (TJornada *)EstM->LstJornDF->Items[D->Numero];

     Grid->Cells[0][lin]  = "Jornada: " + IntToStr(i);
     Grid->Cells[1][lin]  = IntToStr(D->Qtd);
     if (D->Tipo == 'U')
      Grid->Cells[2][lin] = "Dia til";
     else if (D->Tipo == 'S')
      Grid->Cells[2][lin] = "Sbado";
     else if (D->Tipo == 'D')
      Grid->Cells[2][lin] = "Domingo";
     else
      Grid->Cells[2][lin] = "Feriado";
     if (J->Tipo == 'S')
      Grid->Cells[3][lin] = "Simples";
     else
      Grid->Cells[3][lin] = "Dupla";
     Grid->Cells[4][lin]  = MinuteToStr(J->HInicio);
     Grid->Cells[5][lin]  = MinuteToStr(J->HFim);
     Grid->Cells[6][lin]  = MinuteToStr(J->TmpTrab);
     Grid->Cells[7][lin]  = MinuteToStr(J->HExtra);
     Grid->Cells[8][lin]  = J->LinIni;
     Grid->Cells[9][lin]  = J->LinFin;
     Grid->Cells[10][lin] = IntToStr(J->VeiIni);
     Grid->Cells[11][lin] = IntToStr(J->VeiFin);
     Grid->Cells[12][lin] = MinuteToStr(J->Ocio);
    }
   else
    {
     Grid->Cells[0][lin] = "Jornada: " + IntToStr(i);
     Grid->Cells[1][lin] = IntToStr(D->Qtd);
     if (D->Tipo == 'U')
      Grid->Cells[2][lin] = "Dia til";
     else if (D->Tipo == 'S')
      Grid->Cells[2][lin] = "Sbado";
     else if (D->Tipo == 'D')
      Grid->Cells[2][lin] = "Domingo";
     else
      Grid->Cells[2][lin] = "Feriado";
     Grid->Cells[3][lin]  = "Folga";
     Grid->Cells[4][lin]  = "Folga";
     Grid->Cells[5][lin]  = "Folga";
     Grid->Cells[6][lin]  = "Folga";
     Grid->Cells[7][lin]  = "Folga";
     Grid->Cells[8][lin]  = "Folga";
     Grid->Cells[9][lin]  = "Folga";
     Grid->Cells[10][lin] = "Folga";
     Grid->Cells[11][lin] = "Folga";
     Grid->Cells[12][lin] = "Folga";
    }
   lin++;
  }
 Grid->RowCount = max(2, lin);

 if (Grid == StrGJorTrip1)
  {
   LblFncObjTrip1->Caption  = TM->FncObjetivo;
   LblTFncObjTrip1->Caption = "Valor da funo objetivo da tripulao " + IntToStr(NTrip) + ": ";
  }
 else
  {
   LblFncObjTrip2->Caption  = TM->FncObjetivo;
   LblTFncObjTrip2->Caption = "Valor da funo objetivo da tripulao " + IntToStr(NTrip) + ": ";
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherLstBox
- Objetivo...: Preencher os ListBoxes com o nmero de tripulaes.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) NTrip -> N de tripulaes.
============================================================================= */
void TFrmAltEscMensal::PreencherLstBox(int NTrip)
{
 LstBTrip1->Clear();
 LstBTrip2->Clear();

 for (int i = 0; i < NTrip ; i++)
  {
   LstBTrip1->Items->Add(IntToStr(i));
   LstBTrip2->Items->Add(IntToStr(i));
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: AtualizarGrids
- Objetivo...: Realizar a troca e atualizar os valores dos grids.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) NTrip -> N da tripulao de origem.
============================================================================= */
void TFrmAltEscMensal::AtualizarGrids(int NTrip)
{
 if ((LstBTrip1->ItemIndex == -1)||(LstBTrip2->ItemIndex == -1))
  {
   Beep();
   MessageDlg("Voc deve selecionar as duas tripulaes!", mtWarning,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   TTripEM *T1, *T2;
   T1 = (TTripEM *)escmensal->LstTripulacoes->Items[Trip1];
   T2 = (TTripEM *)escmensal->LstTripulacoes->Items[Trip2];
   bool Aux;

   if (NTrip == 1)
    Aux = TemJornada1;
   else
    Aux = TemJornada2;

   if (Aux)
    {
     escmensal->Movimento(&T1->LstDias, NumJornada, &T2->LstDias);
     T1->EfetuarCalcTrip(escmensal->TmpMedioTrab, EstM, ParEM, PesEM);
     T2->EfetuarCalcTrip(escmensal->TmpMedioTrab, EstM, ParEM, PesEM);
    }
   else
    {
     Beep();
     MessageDlg("Voc deve selecionar uma jornada!", mtWarning,
                TMsgDlgButtons() << mbOK, 0);
    }

   PrepararGrid(StrGJorTrip1);
   PrepararGrid(StrGJorTrip2);

   PreencherGrid(StrGJorTrip1, LstBTrip1->ItemIndex);
   PreencherGrid(StrGJorTrip2, LstBTrip2->ItemIndex);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: StrGJorTrip1DblClick
- Objetivo...: Atualizar o grid 1.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscMensal::StrGJorTrip1DblClick(TObject *Sender)
{
 AtualizarGrids(1);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: StrGJorTrip2DblClick
- Objetivo...: Atualizar o grid 2.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscMensal::StrGJorTrip2DblClick(TObject *Sender)
{
 AtualizarGrids(2);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LstBTrip1Click
- Objetivo...: Preencher o grid 1 com as jornadas da tripulao selecionada.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscMensal::LstBTrip1Click(TObject *Sender)
{
 PrepararGrid(StrGJorTrip1);
 PreencherGrid(StrGJorTrip1, LstBTrip1->ItemIndex);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LstBTrip2Click
- Objetivo...: Preencher o grid 2 com as jornadas da tripulao selecionada.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscMensal::LstBTrip2Click(TObject *Sender)
{
 PrepararGrid(StrGJorTrip2);
 PreencherGrid(StrGJorTrip2, LstBTrip2->ItemIndex);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: StrGJorTrip1SelectCell
- Objetivo...: Selecionar uma jornada no grid 1.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscMensal::StrGJorTrip1SelectCell(TObject *Sender,
      int ACol, int ARow, bool &CanSelect)
{
 String Aux;

 if (ARow != 0)
  {
   Aux = StrGJorTrip1->Cells[0][ARow];
   Aux = Aux.SubString(9 ,Aux.Length());
   if ( (Aux != "") && (StrGJorTrip1->Cells[3][ARow] != "Folga") && (StrGJorTrip2->Cells[3][ARow] != "Folga") )
    {
     NumJornada = StrToInt(Aux);
     TemJornada1 = true;
    }
   else
    TemJornada1 = false;
  }
 Trip1 = LstBTrip1->ItemIndex;
 Trip2 = LstBTrip2->ItemIndex;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: StrGJorTrip2SelectCell
- Objetivo...: Selecionar uma jornada no grid 2.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscMensal::StrGJorTrip2SelectCell(TObject *Sender,
      int ACol, int ARow, bool &CanSelect)
{
 String Aux;

 if (ARow != 0)
  {
   Aux = StrGJorTrip2->Cells[0][ARow];
   Aux = Aux.SubString(9 ,Aux.Length());
   if ( (Aux != "") && (StrGJorTrip2->Cells[3][ARow] != "Folga") && (StrGJorTrip1->Cells[3][ARow] != "Folga") )
    {
     NumJornada  = StrToInt(Aux);
     TemJornada2 = true;
    }
   else
    TemJornada2 = false;
  }
 Trip1 = LstBTrip2->ItemIndex;
 Trip2 = LstBTrip1->ItemIndex;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnInsTripClick
- Objetivo...: Inserir uma nova tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscMensal::BBtnInsTripClick(TObject *Sender)
{
 Beep();
 MessageDlg("Esse recurso no est disponvel nesta verso!", mtInformation,
            TMsgDlgButtons() << mbOK, 0);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnRemTripClick
- Objetivo...: Remover uma tripulao (sem jornadas).
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscMensal::BBtnRemTripClick(TObject *Sender)
{
 Beep();
 MessageDlg("Esse recurso no est disponvel nesta verso!", mtInformation,
            TMsgDlgButtons() << mbOK, 0);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: FormClose
- Objetivo...: Efetuar os clculos para a escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscMensal::FormClose(TObject *Sender, TCloseAction &Action)
{
 escmensal->EfetuarCalculos(EstM, ParEM, PesEM);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnFecharClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscMensal::BBtnFecharClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\






