/*******************************************************************************
* Dependncia.....: UParPpt; UPesos; USistema                                  *
*******************************************************************************/

//------------------------------------------------------------------------------
#ifndef UFrmAltEscDiariaH
#define UFrmAltEscDiariaH
//------------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Grids.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UParPpt.h"
#include "UPesos.h"
#include "USistema.h"
//------------------------------------------------------------------------------

class TFrmAltEscDiaria : public TForm
{
__published:	// IDE-managed Components
        TPanel *PnlED;
        TBitBtn *BBtnFechar;
        TLabel *LblTitulo;
        TBevel *BvlLinha;
        TPanel *PnlTrip1;
        TLabel *LblTFncObjTrip1;
        TLabel *LblFncObjTrip1;
        TStringGrid *StrGTarTrip1;
        TPanel *PnlTrip2;
        TLabel *LblTFncObjTrip2;
        TLabel *LblFncObjTrip2;
        TStringGrid *StrGTarTrip2;
        TPanel *PnlTrip;
        TListBox *LstBTrip1;
        TListBox *LstBTrip2;
        TLabel *LblTrip;
        TBitBtn *BBtnInsTrip;
        TBitBtn *BBtnRemTrip;
        TLabel *LblInfo;

        void __fastcall FormShow(TObject *Sender);
        void __fastcall BBtnInsTripClick(TObject *Sender);
        void __fastcall BBtnRemTripClick(TObject *Sender);
        void __fastcall BBtnFecharClick(TObject *Sender);
        void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
        void __fastcall LstBTrip1Click(TObject *Sender);
        void __fastcall LstBTrip2Click(TObject *Sender);
        void __fastcall StrGTarTrip2DblClick(TObject *Sender);
        void __fastcall StrGTarTrip1DblClick(TObject *Sender);
        void __fastcall StrGTarTrip1SelectCell(TObject *Sender, int ACol,
          int ARow, bool &CanSelect);
        void __fastcall StrGTarTrip2SelectCell(TObject *Sender, int ACol,
          int ARow, bool &CanSelect);

private:
        int TripOrigem;  // N da tripulao de origem da tarefa.
        int TripDestino; // N da tripulao de destino da tarefa.
        int NumTarefa;   // N da tarefa.
        bool TemTarefa1; // Verifica se uma tarefa foi selecionada no grid 1.
        bool TemTarefa2; // Verifica se uma tarefa foi selecionada no grid 2.

        void PrepararGrid();
        void PreencherGrid();

public:
        __fastcall TFrmAltEscDiaria(TComponent* Owner);

        TParPptED *ParED; // Objeto que representa os par. para a escala diria.
        TPesosED *PesED;  // Objeto que representa os pesos para a escala diria.
        TSistema *S;      // Objeto que representa o sistema.

        void PrepararGrid(TStringGrid *);
        void PreencherGrid(TStringGrid *, int);
        void PreencherLstBox(int);
        void AtualizarGrids(int);
};
//------------------------------------------------------------------------------
extern PACKAGE TFrmAltEscDiaria *FrmAltEscDiaria;
//------------------------------------------------------------------------------
#endif
