/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmAltEscDiaria                 Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Conter a tela de alterao manual da escala diria.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmAltEscDiaria) referente a tela de alterao da
*                            escala diria.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UEscDiaria
*     2) UTripulacoes
*     3) UTar_Jorn
*     4) UUtil
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmAltEscDiaria.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UEscDiaria.h"
#include "UTripulacoes.h"
#include "UTar_Jorn.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#define max(a, b)  (((a) > (b)) ? (a) : (b))

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmAltEscDiaria *FrmAltEscDiaria;
//------------------------------------------------------------------------------

__fastcall TFrmAltEscDiaria::TFrmAltEscDiaria(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Preparar os grids e os listbox.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscDiaria::FormShow(TObject *Sender)
{
 PrepararGrid(StrGTarTrip1);
 PrepararGrid(StrGTarTrip2);
 PreencherLstBox(escdiaria->LstTripulacoes->Count);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PrepararGrid
- Objetivo...: Limpar e preencher o cabealho do grid recebido.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) Grid -> Grid a ser preparado.
============================================================================= */
void TFrmAltEscDiaria::PrepararGrid(TStringGrid *Grid)
{
 LimparGrid(Grid);

 Grid->Cells[1][0] = "N do veculo";
 Grid->Cells[2][0] = "Hor. inicial";
 Grid->Cells[3][0] = "Hor. final";
 Grid->Cells[4][0] = "Pto. inicial";
 Grid->Cells[5][0] = "Pto. final";
 Grid->Cells[6][0] = "F. acumulada";
 Grid->Cells[7][0] = "L. inicial";
 Grid->Cells[8][0] = "L. final";

 Grid->Color       = S->CCCTabelas;
 Grid->FixedColor  = S->CCFTabelas;
 Grid->Font->Color = S->CFTabelas;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherGrid
- Objetivo...: Preencher o grid recebido por parmetro com os valores da
               tripulao (tambm recebida por parmetro).
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) Grid  -> Grid a ser preenchido.
   2) NTrip -> N da tripulao.
============================================================================= */
void TFrmAltEscDiaria::PreencherGrid(TStringGrid *Grid, int NTrip)
{
 TTripED *Trip;
 TTarefa *T;
 int lin = 1;

 Trip = (TTripED *)escdiaria->LstTripulacoes->Items[NTrip];

 for (int i = 0; i < Trip->LstTarefas->Count; i++)
  {
   T = (TTarefa *)Trip->LstTarefas->Items[i];

   Grid->Cells[0][lin] = "Tarefa: " + IntToStr(i);
   Grid->Cells[1][lin] = IntToStr(T->NumVeic);
   Grid->Cells[2][lin] = MinuteToStr(T->HInicio);
   Grid->Cells[3][lin] = MinuteToStr(T->HFim);
   Grid->Cells[4][lin] = IntToStr(T->PIni);
   Grid->Cells[5][lin] = IntToStr(T->PFim);
   Grid->Cells[6][lin] = IntToStr(T->FolAcu);
   Grid->Cells[7][lin] = getLinha(T->LinIni);
   Grid->Cells[8][lin] = getLinha(T->LinFin);
   lin++;
  }
 if (Trip->TVirtual != 0)
  {
   Grid->Cells[0][lin] = "Tarefa virtual!";
   Grid->Cells[1][lin] = "T. virtual!";
   Grid->Cells[2][lin] = MinuteToStr(T->HFim);
   Grid->Cells[3][lin] = MinuteToStr(Trip->TVirtual);
   Grid->Cells[4][lin] = "T. virtual!";
   Grid->Cells[5][lin] = "T. virtual!";
   Grid->Cells[6][lin] = "T. virtual!";
   Grid->Cells[7][lin] = "T. virtual!";
   Grid->Cells[8][lin] = "T. virtual!";
   lin++;
  }
 Grid->RowCount = max(2, lin);

 if (Grid == StrGTarTrip1)
  {
   LblFncObjTrip1->Caption  = Trip->FncObjetivo;
   LblTFncObjTrip1->Caption = "Valor da funo objetivo da tripulao " + IntToStr(NTrip) + ": ";
  }
 else
  {
   LblFncObjTrip2->Caption  = Trip->FncObjetivo;
   LblTFncObjTrip2->Caption = "Valor da funo objetivo da tripulao " + IntToStr(NTrip) + ": ";
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherLstBox
- Objetivo...: Preencher os ListBoxes com o nmero de tripulaes.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) NTrip -> N de tripulaes.
============================================================================= */
void TFrmAltEscDiaria::PreencherLstBox(int NTrip)
{
 LstBTrip1->Clear();
 LstBTrip2->Clear();

 for (int i = 0; i < NTrip ; i++)
  {
   LstBTrip1->Items->Add(IntToStr(i));
   LstBTrip2->Items->Add(IntToStr(i));
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: AtualizarGrids
- Objetivo...: Realizar a troca e atualizar os valores dos grids.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) NTrip -> N da tripulao de origem.
============================================================================= */
void TFrmAltEscDiaria::AtualizarGrids(int NTrip)
{
 if ((LstBTrip1->ItemIndex == -1)||(LstBTrip2->ItemIndex == -1))
  {
   Beep();
   MessageDlg("Voc deve selecionar as duas tripulaes!", mtWarning,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   TTripED *TO, *TD;
   TO = (TTripED *)escdiaria->LstTripulacoes->Items[TripOrigem];
   TD = (TTripED *)escdiaria->LstTripulacoes->Items[TripDestino];
   bool Aux;

   if (NTrip == 1)
    Aux = TemTarefa1;
   else
    Aux = TemTarefa2;

   if (Aux)
    {
     escdiaria->Movimento(&TO->LstTarefas, NumTarefa, &TD->LstTarefas);
     TO->EfetuarCalcTrip(ParED, PesED);
     TD->EfetuarCalcTrip(ParED, PesED);
    }
   else
    {
     Beep();
     MessageDlg("Voc deve selecionar uma tarefa!", mtWarning,
                TMsgDlgButtons() << mbOK, 0);
    }

   PrepararGrid(StrGTarTrip1);
   PrepararGrid(StrGTarTrip2);

   PreencherGrid(StrGTarTrip1, LstBTrip1->ItemIndex);
   PreencherGrid(StrGTarTrip2, LstBTrip2->ItemIndex);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: StrGTarTrip1DblClick
- Objetivo...: Atualizar o grid 1.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscDiaria::StrGTarTrip1DblClick(TObject *Sender)
{
 AtualizarGrids(1);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: StrGTarTrip2DblClick
- Objetivo...: Atualizar o grid 2.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscDiaria::StrGTarTrip2DblClick(TObject *Sender)
{
 AtualizarGrids(2);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LstBTrip1Click
- Objetivo...: Preencher o grid 1 com as tarefas da tripulao selecionada.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscDiaria::LstBTrip1Click(TObject *Sender)
{
 PrepararGrid(StrGTarTrip1);
 PreencherGrid(StrGTarTrip1, LstBTrip1->ItemIndex);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: LstBTrip2Click
- Objetivo...: Preencher o grid 2 com as tarefas da tripulao selecionada.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscDiaria::LstBTrip2Click(TObject *Sender)
{
 PrepararGrid(StrGTarTrip2);
 PreencherGrid(StrGTarTrip2, LstBTrip2->ItemIndex);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: StrGTarTrip1SelectCell
- Objetivo...: Selecionar uma tarefa no grid 1.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscDiaria::StrGTarTrip1SelectCell(TObject *Sender,
      int ACol, int ARow, bool &CanSelect)
{
 String Aux;

 if (ARow != 0)
  {
   Aux = StrGTarTrip1->Cells[0][ARow];
   Aux = Aux.SubString(9, Aux.Length());
   if ((Aux != "") && (Aux != "irtual!"))
    {
     NumTarefa = StrToInt(Aux);
     TemTarefa1 = true;
    }
   else
    TemTarefa1 = false;
  }
 TripOrigem  = LstBTrip1->ItemIndex;
 TripDestino = LstBTrip2->ItemIndex;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: StrGTarTrip2SelectCell
- Objetivo...: Selecionar uma tarefa no grid 2.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscDiaria::StrGTarTrip2SelectCell(TObject *Sender,
      int ACol, int ARow, bool &CanSelect)
{
 String Aux;

 if (ARow != 0)
  {
   Aux = StrGTarTrip2->Cells[0][ARow];
   Aux = Aux.SubString(9, Aux.Length());
   if ((Aux != "") && (Aux != "irtual!"))
    {
     NumTarefa = StrToInt(Aux);
     TemTarefa2 = true;
    }
   else
    TemTarefa2 = false;
  }
 TripOrigem  = LstBTrip2->ItemIndex;
 TripDestino = LstBTrip1->ItemIndex;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnInsTripClick
- Objetivo...: Inserir uma nova tripulao.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscDiaria::BBtnInsTripClick(TObject *Sender)
{
 TTripED *NovaT = new TTripED();
 escdiaria->LstTripulacoes->Add(NovaT);
 LstBTrip1->Items->Add(escdiaria->LstTripulacoes->Count-1);
 LstBTrip2->Items->Add(escdiaria->LstTripulacoes->Count-1);
 Beep();
 MessageDlg("Tripulao " + IntToStr(escdiaria->LstTripulacoes->Count-1) +
            " inserida com sucesso!", mtInformation, TMsgDlgButtons() << mbOK, 0);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnRemTripClick
- Objetivo...: Remover uma tripulao (sem tarefas).
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscDiaria::BBtnRemTripClick(TObject *Sender)
{
 TTripED *T;
 bool Removeu = false;
 int NumTrip = 0;

 for (int i = escdiaria->LstTripulacoes->Count-1; i >= 0; i--)
  {
   T = (TTripED *)escdiaria->LstTripulacoes->Items[i];
   if ( (T->NTarefas == 0) && (Removeu == false) )
    {
     Removeu = true;
     NumTrip = i;
     escdiaria->LstTripulacoes->Remove(T);
     escdiaria->LstTripulacoes->Capacity = escdiaria->LstTripulacoes->Count;
    }
  }
 if (Removeu == false)
  {
   Beep();
   MessageDlg("No existem tripulaes sem tarefas!", mtInformation,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   Beep();
   MessageDlg("Tripulao " + IntToStr(NumTrip) + " removida com sucesso!",
              mtInformation, TMsgDlgButtons() << mbOK, 0);
   PreencherLstBox(escdiaria->LstTripulacoes->Count);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: FormClose
- Objetivo...: Efetuar os clculos para a escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscDiaria::FormClose(TObject *Sender, TCloseAction &Action)
{
 escdiaria->EfetuarCalculos(ParED, PesED);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnFecharClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAltEscDiaria::BBtnFecharClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
