/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UFrmAgruparLinhas                Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Agrupar as linhas da programao de veculos.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TFrmAgruparLinhas) referente a tela que agrupa as
*                            linhas.
* Obs......................: O arquivo .h dessa unit foi alterado.
* Dependncias.............:
*     1) UFrmPrincipal
*     2) UEscDiaria
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "UFrmAgruparLinhas.h"

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "UFrmPrincipal.h"
#include "UEscDiaria.h"
//------------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"

TFrmAgruparLinhas *FrmAgruparLinhas;
//------------------------------------------------------------------------------

__fastcall TFrmAgruparLinhas::TFrmAgruparLinhas(TComponent* Owner) : TForm(Owner)
{
}
//------------------------------------------------------------------------------


/* =============================================================================
- Mtodo.....: FormShow
- Objetivo...: Exibir todas as linhas da programao de veculos.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAgruparLinhas::FormShow(TObject *Sender)
{
 LstBLinhas->Items->Clear();
 LstBLinGrup->Items->Clear();
 PV->IniciarLinhas(&escdiaria);
 TStringList *L = PV->GetLinhas(escdiaria);

 for (int i = 0; i < L->Count; i++)
  LstBLinhas->Items->Add(L->Strings[i]);
 delete(L);
 Pos   = 0;
 Grupo = 1;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnAgruparClick
- Objetivo...: Agrupar as linhas selecionadas.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAgruparLinhas::BBtnAgruparClick(TObject *Sender)
{
 String Aux;
 int i;

 if (LstBLinhas->SelCount != 0)
  {
   TStringList *L = new TStringList();

   LstBLinhas->CopySelection(LstBLinGrup);
   LstBLinhas->DeleteSelected();

   for (i = Pos; i < LstBLinGrup->Items->Count; i++)
    {
     Aux = LstBLinGrup->Items->Strings[i];
     L->Add(Aux);
     Aux = Aux + "." + Grupo;
     LstBLinGrup->Items->Delete(i);
     LstBLinGrup->Items->Insert(i, Aux);
    }

   PV->AdicionarGrupo(&escdiaria, L, Grupo);
   Pos = i;
   Grupo++;
   L->Clear();
   L->Capacity = L->Count;
   delete(L);
  }
 else
  {
   Beep();
   MessageDlg("Voc deve selecionar as linhas desejadas primeiro!",
            mtWarning, TMsgDlgButtons() << mbOK, 0);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnCorrigirClick
- Objetivo...: Desfazer os grupos das linhas (coloca o mesmo para todas).
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAgruparLinhas::BBtnCorrigirClick(TObject *Sender)
{
 FormShow(Owner);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnOKClick
- Objetivo...: Continuar a execuo da escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAgruparLinhas::BBtnOKClick(TObject *Sender)
{
 FrmPrincipal->AgrupouLinhas = true;
 Close();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: BBtnCancelarClick
- Objetivo...: Fechar a tela.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void __fastcall TFrmAgruparLinhas::BBtnCancelarClick(TObject *Sender)
{
 Close();
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\



