/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UEstruturaMes                      Tipo.......: .h
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar uma estrutura semelhante ao ms selecionado
*                            pelo usurio.
* Descrio................: Esta unit contm a "declarao" de uma classe
*                            (TDias) referente aos dias do ms e de uma outra
*                            (TEstruturaMes)referente ao ms selecionado.
* Obs......................: O arquivo .cpp dessa unit possui a implementao de
*                            tudo que foi declarado aqui.
* Dependncias.............:
*     1) UEscDiaria
*******************************************************************************/

#ifndef UEstruturaMesH
#define UEstruturaMesH

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "system.hpp"
#include "classes.hpp"

#include "UEscDiaria.h"
//------------------------------------------------------------------------------

/* =============================================================================
- Classe.....: TDias
- Objetivo...: Possui os atributos e mtodos referentes aos dias do ms.
============================================================================= */
class TDias{
  public:
    int Numero; // Nmero referente posio da jornada na lista (de jornadas).
    char Tipo;  // Identifica o tipo da jornada usada nestes dias.
                // 'U' -> Dia til    |
                // 'S' -> Sbado      |  'B' -> Sbado e Feriado.
                // 'D' -> Domingo     |  'M' -> Domingo e Feriado.
    int Qtd;    // Quantidade de dias (consecutivos) que possuiro a mesma jornada.

    TDias();
    void Free();
};
//------------------------------------------------------------------------------


/* =============================================================================
- Classe.....: TEstruturaMes
- Objetivo...: Possui os atributos e mtodos referentes aos meses.
============================================================================= */
class TEstruturaMes{
  private:
    void CompactarEstrutura();
    void PreencherListas(TEscDiaria *, char);

  public:
    String Mes; // Nome do ms selecionado.
    int NumMes; // Nmero do ms selecionado pelo usurio (1...12).
    int Ano;    // Ano selecionado pelo usurio.

    TList *LstDias;    // Lista que representa todos os dias do ms selecionado.

    TList *LstJornDU;  // Lista das jornadas para dias teis.
    TList *LstJornDF;  // Lista das jornadas para domingos e feriados.
    TList *LstJornSab; // Lista das jornadas para sbados.

    TList *LstTar_TripDU;  // Lista das tarafas das tripulaes para dias teis.
    TList *LstTar_TripDF;  // Lista das tarafas das tripulaes para domingos e feriados.
    TList *LstTar_TripSab; // Lista das tarafas das tripulaes para sbados.

    TEstruturaMes(int, int);
    void CriarEstrutura(TEscDiaria *, TEscDiaria *, TEscDiaria *, TList *, TList *, TList *, int);
    String getData(int);
    void Free();
};
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#endif
// ----------------------------------- FIM ---------------------------------- \\
