/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UEstruturaMes                    Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar uma estrutura semelhante ao ms selecionado
*                            pelo usurio.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TDias) referente aos dias do ms e de uma outra
*                            (TEstruturaMes)referente ao ms selecionado.
* Obs......................: O arquivo .h dessa unit possui a declarao de tudo
*                            que foi implementado aqui.
* Dependncias.............:
*     1) UTar_Jorn
*     2) UTripulacoes
*     3) UUtil
*******************************************************************************/

#pragma hdrstop

#include "UEstruturaMes.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
//------------------------------------------------------------------------------

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "stdio.h"
#include "vcl.h"

#include "UTar_Jorn.h"
#include "UTripulacoes.h"
#include "UUtil.cpp"
//------------------------------------------------------------------------------


                        // ----- CLASSE TDias ----- \\

/* =============================================================================
- Mtodo.....: TDias
- Objetivo...: Criar e inicializar o objeto TDias.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TDias::TDias()
{
 Numero = -1;
 Tipo   = 'U';
 Qtd    = 1;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Free
- Objetivo...: Destuir o objeto TDias.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TDias::Free()
{
 delete(this);
}
//------------------------------------------------------------------------------


                        // ----- CLASSE TEstruturaMes ----- \\

/* =============================================================================
- Mtodo.....: TEstruturaMes
- Objetivo...: Criar o objeto TEstruturaMes.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) NM -> Nmero do ms.
   2) A  -> Ano.
============================================================================= */
TEstruturaMes::TEstruturaMes(int NM, int A)
{
 Mes    = getMes(NM);
 NumMes = NM;
 Ano    = A;

 this->LstDias  = new TList();

 LstJornDU      = new TList();
 LstTar_TripDU  = new TList();
 LstJornDF      = new TList();
 LstTar_TripDF  = new TList();
 LstJornSab     = new TList();
 LstTar_TripSab = new TList();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: getData
- Objetivo...: Retornar a data de uma determinada jornada.
- Retorno....: Data (String).
- Parmetros.:
   1) Pos -> Posio na lista de dias (LstDias).
============================================================================= */
String TEstruturaMes::getData(int Pos)
{
 TDias *D;
 int Inic = 0;
 int Fim = 0;
 String Data = "";

 for (int i = 0; i < Pos + 1; i++)
  {
   D = (TDias *)this->LstDias->Items[i];
   Fim = Fim + D->Qtd;
  }

 Inic = Fim - D->Qtd + 1;

 if (Fim == Inic)
  Data = IntToStr(Inic) + "/" + IntToStr(this->NumMes) + "/"+ IntToStr(this->Ano);
 else
  Data = "De  " + IntToStr(Inic) + "  at  " + IntToStr(Fim) + "/" + IntToStr(this->NumMes) + "/"+ IntToStr(this->Ano);

 return Data;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CompactarEstrutura
- Objetivo...: Agrupar os dias de mesmo tipo na estrutura do ms selecionado.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TEstruturaMes::CompactarEstrutura()
{
 TList *LstAux = new TList();
 TDias *D1, *D2, *DAux;
 char Tipo;
 int qtd = 1;

 for (int i = 0; i < LstDias->Count; i++)
  {
   D1 = (TDias *)LstDias->Items[i];
   Tipo = D1->Tipo;
   if (D1 != LstDias->Last())
    {
     D2 = (TDias *)LstDias->Items[i+1];
     if (D1->Tipo == D2->Tipo)
      qtd++;
     else
      {
       DAux = new TDias();
       DAux->Tipo = Tipo;
       DAux->Qtd = qtd;
       LstAux->Add(DAux);
       qtd = 1;
      }
    }
   else
    {
     DAux = new TDias();
     DAux->Tipo = Tipo;
     DAux->Qtd = qtd;
     LstAux->Add(DAux);
     qtd = 1;
    }
  }

 for (int i = 0; i < LstDias->Count; i++)
  {
   DAux = (TDias *)LstDias->Items[i];
   delete(DAux);
  }
 delete(LstDias);
 LstDias = LstAux;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CriarEstrutura
- Objetivo...: Criar "os dias" de acordo com o seu tipo.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) EDU   -> Escala diria para dias teis.
   2) EDF   -> Escala diria para domingos e feriados.
   3) ESab  -> Escala diria para sbados.
   4) LS    -> Lista com os sbados.
   5) LD    -> Lista com os domingos.
   6) LF    -> Lista com os feriados.
   7) NDias -> N de dias no ms.
============================================================================= */
void TEstruturaMes::CriarEstrutura(TEscDiaria *EDU, TEscDiaria *EDF, TEscDiaria *ESab,
                                   TList *LS, TList *LD, TList *LF, int NDias)
{
 TDias *D;
 int Sab = 0;
 int Dom = 0;
 int Fer = 0;
 bool EFeriado;

 PreencherListas(EDU, 'U');
 PreencherListas(EDF, 'D');
 PreencherListas(ESab, 'S');

 for (int i = 0; i < NDias; i++)
  {
   D = new TDias();
   this->LstDias->Add(D);
  }

 for (int i = 0; i < LF->Count; i++)
  {
   Fer = (int)LF->Items[i];
   D = (TDias *)LstDias->Items[Fer-1];
   D->Tipo = 'F';
  }

 for (int i = 0; i < LS->Count; i++)
  {
   EFeriado = false;
   Sab = (int)LS->Items[i];
   for (int j = 0; j < LF->Count; j++)
    {
     Fer = (int)LF->Items[j];
     if (Sab == Fer)
      EFeriado = true;
    }
   if (EFeriado)
    {
     D = (TDias *)LstDias->Items[Sab-1];
     D->Tipo = 'B';
    }
   else
    {
     D = (TDias *)LstDias->Items[Sab-1];
     D->Tipo = 'S';
    }
  }

 for (int i = 0; i < LD->Count; i++)
  {
   EFeriado = false;
   Dom = (int)LD->Items[i];
   for (int j = 0; j < LF->Count; j++)
    {
     Fer = (int)LF->Items[j];
     if (Dom == Fer)
      EFeriado = true;
    }
   if (EFeriado)
    {
     D = (TDias *)LstDias->Items[Dom-1];
     D->Tipo = 'M';
    }
   else
    {
     D = (TDias *)LstDias->Items[Dom-1];
     D->Tipo = 'D';
    }
  }
 CompactarEstrutura();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: PreencherLista
- Objetivo...: Preencher uma lista de jornadas e uma de tarefas referentes 
               escala recebida.
- Retorno....: <-- Nenhum -->
- Parmetros.:
   1) ED   -> Escala diria.
   2) Tipo -> Indica se a lista  para dias teis, sbados ou domingos e feriados.
============================================================================= */
void TEstruturaMes::PreencherListas(TEscDiaria *ED, char Tipo)
{
 TList *LJorn;
 TList *LTar_Trip;

 if (Tipo == 'U')
  {
   LJorn     = this->LstJornDU;
   LTar_Trip = this->LstTar_TripDU;
  }
 else if (Tipo == 'D')
  {
   LJorn     = this->LstJornDF;
   LTar_Trip = this->LstTar_TripDF;
  }
 else
  {
   LJorn     = this->LstJornSab;
   LTar_Trip = this->LstTar_TripSab;
  }

 TTripED *Trip;
 TTarefa *T, *T1, *T2;

 TJornada *J;
 TTar_Trip *TT;
 char TipoDP;
 int HFim;
 int i, j;

 for (i = 0; i < ED->LstTripulacoes->Count; i++)
  {
   Trip = (TTripED *)ED->LstTripulacoes->Items[i];
   for (j = 0; j < Trip->LstTarefas->Count; j++)
    {
     T = (TTarefa *)Trip->LstTarefas->Items[j];
     TT = new TTar_Trip();
     TT->PreencherAtributos(T->HInicio, T->HFim, T->LinIni, T->LinFin, T->NumVeic,
                            T->PIni, T->PFim, T->FolAcu, i, j);
     LTar_Trip->Add(TT);
    }
   if (Trip->TVirtual != 0)
    {
     TT = new TTar_Trip();
     TT->PreencherAtributos(T->HFim, Trip->TVirtual, "-1", "-1", -1, -1, -1, -1, i, j);
     LTar_Trip->Add(TT);
    }

   T1 = (TTarefa *)Trip->LstTarefas->First();
   T2 = (TTarefa *)Trip->LstTarefas->Last();
   if (Trip->TVirtual != 0)
    HFim = Trip->TVirtual;
   else
    HFim = T2->HFim;

   if (Trip->NDPegadas == 0)
    TipoDP = 'S';
   else
    TipoDP = 'D';
   J = new TJornada();
   J->PreencherAtributos(T1->HInicio, HFim, T1->LinIni, T2->LinFin, TipoDP,
                         Trip->TmpTTrabalho, Trip->HExtra, T1->NumVeic, T2->NumVeic,
                         Trip->TmpOcioso);
   LJorn->Add(J);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Free
- Objetivo...: Destruir o objeto TEstruturaMes, sua lista de dias e de jornadas
               para dias teis, sbados e domingos e feriados.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TEstruturaMes::Free()
{
 int i;

 for (i = 0; i < this->LstDias->Count; i++)
  delete(LstDias->Items[i]);
 delete(this->LstDias);

 for (i = 0; i < this->LstJornDU->Count; i++)
  delete(LstJornDU->Items[i]);
 delete(this->LstJornDU);

 for (i = 0; i < this->LstJornDF->Count; i++)
  delete(LstJornDF->Items[i]);
 delete(this->LstJornDF);

 for (i = 0; i < this->LstJornSab->Count; i++)
  delete(LstJornSab->Items[i]);
 delete(this->LstJornSab);

 for (i = 0; i < this->LstTar_TripDU->Count; i++)
  delete(LstTar_TripDU->Items[i]);
 delete(this->LstTar_TripDU);

 for (i = 0; i < this->LstTar_TripDF->Count; i++)
  delete(LstTar_TripDF->Items[i]);
 delete(this->LstTar_TripDF);

 for (i = 0; i < this->LstTar_TripSab->Count; i++)
  delete(LstTar_TripSab->Items[i]);
 delete(this->LstTar_TripSab);

 delete(this);
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
