/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UEscMensal                         Tipo.......: .h
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar estruturas referentes  escala mensal.
* Descrio................: Esta unit contm a "declarao" de uma classe
*                            (TEscMensal) referente  escala mensal.
* Obs......................: O arquivo .cpp dessa unit possui a implementao de
*                            tudo que foi declarado aqui.
* Dependncias.............:
*     1) UEstruturaMes
*     2) UParPpt
*     3) UPesos
*******************************************************************************/

#ifndef UEscMensalH
#define UEscMensalH

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "classes.hpp"

#include "UEstruturaMes.h"
#include "UParPpt.h"
#include "UPesos.h"
//------------------------------------------------------------------------------


/* =============================================================================
- Classe.....: TEscMensal
- Objetivo...: Possui os atributos e mtodos referentes  escala mensal.
============================================================================= */
class TEscMensal{
  private:
    TList *getTarefas(TEstruturaMes *, char, int);
    void EfetuarCalcEM();

  public:
    bool Valida;               // Indica se a escala  vlida ou no.
    int TmpMedioTrab;          // Tempo mdio de trabalho das tripulaes.
    long int FncObjTotal;      // Valor da funo objetivo da escala.
    long int FOTotTripulacoes; // Valor da soma das funes objetivo das tripulaes.
    TList *LstTripulacoes;     // Lista de tripulaes.

    TEscMensal();
    void InicializaLstTripulacoes(int);
    void DistribuirJornadas(TEstruturaMes *);
    TEscMensal *Clone();
    void Movimento(TList **, int, TList **);
    void EfetuarCalculos(TEstruturaMes *, TParPptEM *, TPesosEM *);
    void EfCalcDepoisDoMovimento(TEstruturaMes *, TParPptEM *, TPesosEM *, int, int);
    void CalcTmpMedioTrab(TEstruturaMes *);
    void GravarEscala(TEstruturaMes *, String);
    void CarregarEscala(TEstruturaMes **, String);

    void GravarArqAux(TEstruturaMes *, String);

    void Free();
};
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
extern TEscMensal *escmensal;
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#endif
// ----------------------------------- FIM ---------------------------------- \\
