/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UEscMensal                       Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar estruturas referentes  escala mensal.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TEscMensal) referente  escala mensal.
* Obs......................: O arquivo .h dessa unit possui a declarao de
*                            tudo que foi implementado aqui.
* Dependncias.............:
*     1) UTripulacoes
*     2) UTar_Jorn
*     3) UEscDiaria
*     4) UUtil
*******************************************************************************/

#pragma hdrstop

#include "UEscMensal.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
//------------------------------------------------------------------------------

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "stdio.h"
#include "vcl.h"

#include "UTripulacoes.h"
#include "UTar_Jorn.h"
#include "UEscDiaria.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#define max(a, b)  (((a) > (b)) ? (a) : (b))

//------------------------------------------------------------------------------

TEscMensal *escmensal;

/* =============================================================================
- Mtodo.....: TEscMensal
- Objetivo...: Criar e inicializar o objeto TEscMensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TEscMensal::TEscMensal()
{
 Valida           = false;
 TmpMedioTrab     = 0;
 FncObjTotal      = 0;
 FOTotTripulacoes = 0;
 LstTripulacoes = new TList();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: InicializarLstTripulacoes
- Objetivo...: "Criar" NTrip tripulaes e adicion-las na lista.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) NTrip -> Nmero de tripulaes.
============================================================================= */
void TEscMensal::InicializaLstTripulacoes(int NTrip)
{
 for (int i=0; i < NTrip; i++)
  {
   TTripEM *T = new TTripEM();
   this->LstTripulacoes->Add(T);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: DistribuirJornadas
- Objetivo...: Distribuir as jornadas s tripulaes.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) EM -> Objeto que contm a estrutura do ms selecionado.
============================================================================= */
void TEscMensal::DistribuirJornadas(TEstruturaMes *EM)
{
 TTripEM *T;
 TDias *D, *DAux;
 int Aux;

 for (int i = 0; i < EM->LstJornDU->Count; i++)
  {
   T = (TTripEM *)this->LstTripulacoes->Items[i];
   for (int j = 0; j < EM->LstDias->Count; j++)
    {
     DAux = (TDias *)EM->LstDias->Items[j];
     D = new TDias();

     if (DAux->Tipo == 'U')
      D->Numero = i;

     D->Tipo = DAux->Tipo;
     D->Qtd  = DAux->Qtd;
     T->LstDias->Add(D);
    }
  }

 for (int i = 0; i < EM->LstJornSab->Count; i++)
  {
   T = (TTripEM *)this->LstTripulacoes->Items[i];
   for (int j = 0; j < T->LstDias->Count; j++)
    {
     D = (TDias *)T->LstDias->Items[j];
     if (D->Tipo == 'S')
      D->Numero = i;
    }
  }

 Aux = 0;
 for (int i = EM->LstJornSab->Count; i < this->LstTripulacoes->Count; i++)
  {
   T = (TTripEM *)this->LstTripulacoes->Items[i];
   for (int j = 0; j < T->LstDias->Count; j++)
    {
     D = (TDias *)T->LstDias->Items[j];
     if ( (D->Tipo == 'D') || (D->Tipo == 'M') || (D->Tipo == 'F') || (D->Tipo == 'B') )
      D->Numero = Aux;
    }
   Aux++;
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Clone
- Objetivo...: Criar e retornar uma escala mensal com os valores iguais aos da
               escala mensal que chamou o mtodo.
- Retorno....: Clone -> Objeto (TEscMensal) com os mesmos valores da escala que
                        chamou o mtodo.
- Parmetros.: <-- Nenhum -->
============================================================================= */
TEscMensal *TEscMensal::Clone()
{
 TTripEM *T, *TC;
 TDias *D, *DC;

 TEscMensal *Clone = new TEscMensal();

 Clone->InicializaLstTripulacoes(this->LstTripulacoes->Count);

 int i = 0;
 int j = 0;

 Clone->Valida           = this->Valida;
 Clone->FncObjTotal      = this->FncObjTotal;
 Clone->FOTotTripulacoes = this->FOTotTripulacoes;
 Clone->TmpMedioTrab     = this->TmpMedioTrab;

 while (i < this->LstTripulacoes->Count)
  {
   T = (TTripEM *)this->LstTripulacoes->Items[i];
   TC = (TTripEM *)Clone->LstTripulacoes->Items[i];

   TC->TmpTTrabalho   = T->TmpTTrabalho;
   TC->TmpEJornadas   = T->TmpEJornadas;
   TC->FncObjetivo    = T->FncObjetivo;
   TC->NumJornDif     = T->NumJornDif;
   TC->NumTrocaTipPeg = T->NumTrocaTipPeg;
   TC->NumTroPerTrab  = T->NumTroPerTrab;

   while (j < T->LstDias->Count)
    {
     D = (TDias *)T->LstDias->Items[j];
     DC = new TDias();
     DC->Numero = D->Numero;
     DC->Tipo   = D->Tipo;
     DC->Qtd    = D->Qtd;
     TC->LstDias->Add(DC);
     j++;
    }
   j = 0;
   i++;
  }

 return Clone;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Movimento
- Objetivo...: Tira um objeto (TDias) de uma lista e o coloca em outra
               (na mesma posio), e tira o objeto da outra lista (na mesma posio)
               e o insere no lugar do primeiro.
- Retorno....: <-- Nenhum -->
- Parmetros.: (As lista so passadas por referncia)
     1) Lst1 -> Lista qualquer (de objetos TDias).
     2) Pos  -> Posio (nas listas 1 e 2) do "TDias" a ser trocado.
     3) Lst2 -> Lista qualquer (de objetos TDias).
============================================================================= */
void TEscMensal::Movimento(TList **Lst1, int Pos, TList **Lst2)
{
 TList *L1 = *Lst1;
 TList *L2 = *Lst2;
 TDias *Aux1, *Aux2;

 Aux1 = (TDias *)L1->Extract(L1->Items[Pos]);
 Aux2 = (TDias *)L2->Extract(L2->Items[Pos]);

 L1->Insert(Pos, Aux2);
 L2->Insert(Pos, Aux1);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: EfetuarCalculos
- Objetivo...: Efetuar todos os clculos para todas as tripulaes da lista.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) EstMes -> Objeto que contm a estrutura do ms selecionado.
     2) ParEM  -> Objeto que contm os parmetros para a escala mensal.
     3) PEM    -> Objeto que contm os pesos para a escala mensal.
============================================================================= */
void TEscMensal::EfetuarCalculos(TEstruturaMes *EstMes, TParPptEM *ParEM, TPesosEM *PEM)
{
 TTripEM *T;
 this->FOTotTripulacoes = 0;
 this->CalcTmpMedioTrab(EstMes);

 for (int i = 0; i < this->LstTripulacoes->Count; i++)
  {
   T = (TTripEM *)LstTripulacoes->Items[i];
   T->EfetuarCalcTrip(this->TmpMedioTrab, EstMes, ParEM, PEM);
   this->FOTotTripulacoes = this->FOTotTripulacoes + T->FncObjetivo;
  }
 this->EfetuarCalcEM();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: EfetuarCalcEM
- Objetivo...: Calcular o valor da funo objetivo total da escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TEscMensal::EfetuarCalcEM()
{
 this->FncObjTotal = this->FOTotTripulacoes;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: EfCalDepoisDoMovimento
- Objetivo...: Calcular o valor da funo objetivo total depois de um movimento.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) EstEM -> Objeto que contm a estrutura do ms selecionado.
     2) ParEM -> Objeto que contm os parmetros para a escala mensal.
     3) PEM   -> Objeto que contm os pesos para a escala mensal.
     4) T1    -> N de uma das tripulaes do movimento.
     5) T2    -> N da outra tripulao do movimento.
============================================================================= */
void TEscMensal::EfCalcDepoisDoMovimento(TEstruturaMes *EstMes, TParPptEM *ParEM, TPesosEM *PEM, int T1, int T2)
{
 TTripEM *Trip1, *Trip2;

 int FOT1Antes, FOT1Depois, FOT2Antes, FOT2Depois;

 Trip1 = (TTripEM *)this->LstTripulacoes->Items[T1];
 Trip2 = (TTripEM *)this->LstTripulacoes->Items[T2];

 FOT1Antes = Trip1->FncObjetivo;
 FOT2Antes = Trip2->FncObjetivo;

 this->CalcTmpMedioTrab(EstMes);

 Trip1->EfetuarCalcTrip(this->TmpMedioTrab, EstMes, ParEM, PEM);
 Trip2->EfetuarCalcTrip(this->TmpMedioTrab, EstMes, ParEM, PEM);

 FOT1Depois = Trip1->FncObjetivo;
 FOT2Depois = Trip2->FncObjetivo;

 this->FOTotTripulacoes = this->FOTotTripulacoes - FOT1Antes - FOT2Antes + FOT1Depois + FOT2Depois;

 this->EfetuarCalcEM();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CalcTmpMedioTrab
- Objetivo...: Calcular o tempo mdio de trabalho das tripulaes durante o ms.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) EM -> Objeto que contm a estrutura do ms selecionado.
============================================================================= */
void TEscMensal::CalcTmpMedioTrab(TEstruturaMes *EM)
{
 TTripEM *T;
 div_t Aux;
 this->TmpMedioTrab = 0;
 for (int i = 0; i < this->LstTripulacoes->Count; i++)
  {
   T = (TTripEM *)this->LstTripulacoes->Items[i];
   T->CalcTmpTTrabalho(EM);
   this->TmpMedioTrab = this->TmpMedioTrab + T->TmpTTrabalho;
  }
 Aux = div(this->TmpMedioTrab, this->LstTripulacoes->Count);

 this->TmpMedioTrab = Aux.quot;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: GravarEscala
- Objetivo...: Gravar a escala mensal obtida em no arquivo EsM.txt.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) EM  -> Objeto que contm a estrutura do ms selecionado.
     2) Dir -> Diretrio de destino do arquivo gravado.
============================================================================= */
void TEscMensal::GravarEscala(TEstruturaMes *EM, String Dir)
{
 String Diretorio;
 Diretorio = ExtractFilePath(Application->ExeName) + "\\Resultados\\EscM.txt";

 if (Dir == "")
  Dir = Diretorio;

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "w");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg("O arquivo da escala mensal no pode ser aberto!", mtError,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   char separador1[108] =
   "===========================================================================================================";
   char separador2[108] =
   "-----------------------------------------------------------------------------------------------------------";

   TTripEM *TM;
   TTar_Trip *T;
   TDias *D;
   TList *LstAux;

   String Titulo;
   int i=0;
   int j=0;
   String Aux, NV, HI, HF, PI, PF, FA, LI, LF, TTT;
   int NTTP, NTPT;
   String Data, Tipo;

   fprintf(Arq,"\n\t\t\t\t\t\t%s\n\t\t\t\t\t\t%s\n\t\t\t\t\t\t%s\n\n",
           "*******************","*  ESCALA MENSAL  *","*******************");

   fprintf(Arq,"\n\t%s\n\t%s%s%s%d\n\t%s\n\n\n",
           "------------------------------"," MS: ", EM->Mes, "     ANO: ", EM->Ano, "------------------------------");

   while(i < this->LstTripulacoes->Count)
    {
     Titulo = "TRIPULAO " + IntToStr(i);

     fprintf(Arq,"%s\n\t\t\t\t\t\t\t%s\n%s\n\n\n",separador1,Titulo,separador1);

     TM = (TTripEM *)this->LstTripulacoes->Items[i];

     while(j < TM->LstDias->Count)
      {
       D = (TDias *)TM->LstDias->Items[j];

       Data = EM->getData(j);
       if (D->Tipo == 'U')
        Tipo = "Dia til";
       else if (D->Tipo == 'S')
        Tipo = "Sbado";
       else if (D->Tipo == 'D')
        Tipo = "Domingo";
       else
        Tipo = "Feriado";

       fprintf(Arq,"%s%s\t\t\t%s%s\n%s\n"," Data: ", Data, "Tipo: ", Tipo, separador2);

       if (D->Numero == -1)
        fprintf(Arq, "\t%s\n%s\n\n\n\n", "FOLGA",separador2);
       else
        {
         if (D->Tipo == 'U')
          LstAux = getTarefas(EM, 'U', D->Numero);
         else if (D->Tipo == 'S')
          LstAux = getTarefas(EM, 'S', D->Numero);
         else
          LstAux = getTarefas(EM, 'D', D->Numero);

         fprintf(Arq,"\t\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\n%s\n",
                 "N_Vei","H_Ini","H_Fim","P_Ini","P_Fim","F_Acu","L_Ini","L_Fim",separador2);

         for (int k = 0; k < LstAux->Count; k++)
          {
           T = (TTar_Trip *)LstAux->Items[k];

           if (T->NumVeic != -1)
            {
             Titulo = "Tarefa " + IntToStr(k);
             NV = IntToStr(T->NumVeic);
             PI = IntToStr(T->PIni);
             PF = IntToStr(T->PFim);
             FA = IntToStr(T->FolAcu);
             LI = T->LinIni;
             LF = T->LinFin;

             HI = MinuteToStr(T->HInicio);
             HF = MinuteToStr(T->HFim);
            }
           else
            {
             Titulo = "T.virtual!";
             NV = "TV!";
             PI = "TV!";
             PF = "TV!";
             FA = "TV!";
             LI = "TV!";
             LF = "TV!";

             HI = MinuteToStr(T->HInicio);
             HF = MinuteToStr(T->HFim);
            }

           fprintf(Arq,"%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\n%s\n",Titulo,
                   NV,HI,HF,PI,PF,FA,LI,LF,separador2);
          }
         fprintf(Arq, "\n\n\n");
        }
       j++;
      }
     j = 0;
     TTT  = MinuteToStr(TM->TmpTTrabalho);
     NTTP = TM->NumTrocaTipPeg;
     NTPT = TM->NumTroPerTrab;

     fprintf(Arq,"%s%s\n%s%d\n%s%d\n%s\n\n\n\n\n",
     "Tempo total trabalhado......................: ", TTT,
     "N de trocas de tipo de pegada..............: ", NTTP,
     "N de trocas do perodo de trabalho.........: ", NTPT,
     "---------------------------------------------------------------");
     i++;
    }
  }
 fprintf(Arq,"%s", "FIM");
 fclose(Arq);

 char *DDestino = new char[ Dir.Length() + 1 ];
 strcpy(DDestino, Dir.c_str());
 char *DOrigem = new char[ Diretorio.Length() + 1 ];
 strcpy(DOrigem, Diretorio.c_str());

 CopyFile(DOrigem, DDestino, false);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: GravarArqAux
- Objetivo...: Gravar um arquivo para carregar a escala mensal.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) EstM -> Objeto que contm uma estrutura de um ms.
     2) Dir  -> Diretrio a ser gravado o arquivo.
============================================================================= */
void TEscMensal::GravarArqAux(TEstruturaMes *EstM, String Dir)
{
 String Diretorio;
 Diretorio = ExtractFilePath(Application->ExeName) + "\\Resultados\\EscM.aux";

 if (Dir == "")
  Dir = Diretorio;

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "w");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg("O arquivo auxiliar da escala mensal no pode ser aberto!", mtError,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   TTripEM *TEM;
   TTar_Trip *T;
   TJornada *J;
   TDias *D;

   fprintf(Arq, "\n%s %d%s%d\n", "ESTRUTURA DO MS: ", EstM->NumMes, "/", EstM->Ano);
   for (int i = 0; i < EstM->LstDias->Count; i++)
    {
     D = (TDias *)EstM->LstDias->Items[i];
     fprintf(Arq, "%s %d %c %d\n", "D ", D->Numero, D->Tipo, D->Qtd);
    }

   fprintf(Arq, "\n\n%s\n\n", "TAREFAS");

   fprintf(Arq, "\n%s\n", "Dias teis:");
   for (int i = 0; i < EstM->LstTar_TripDU->Count; i++)
    {
     T = (TTar_Trip *)EstM->LstTar_TripDU->Items[i];
     fprintf(Arq, "%s %d %d %d %d %d %d %d %d %s %s\n", "T ", T->NumTrip, T->NumTar, T->NumVeic, T->HInicio, T->HFim,
             T->PIni, T->PFim, T->FolAcu, T->LinIni, T->LinFin);
    }

   fprintf(Arq, "\n\n");
   fprintf(Arq, "\n%s\n", "Feriados e domingos:");
   for (int i = 0; i < EstM->LstTar_TripDF->Count; i++)
    {
     T = (TTar_Trip *)EstM->LstTar_TripDF->Items[i];
     fprintf(Arq, "%s %d %d %d %d %d %d %d %d %s %s\n", "T ", T->NumTrip, T->NumTar, T->NumVeic, T->HInicio, T->HFim,
             T->PIni, T->PFim, T->FolAcu, T->LinIni, T->LinFin);
    }

   fprintf(Arq, "\n\n");
   fprintf(Arq, "\n%s\n", "Sbados:");
   for (int i = 0; i < EstM->LstTar_TripSab->Count; i++)
    {
     T = (TTar_Trip *)EstM->LstTar_TripSab->Items[i];
     fprintf(Arq, "%s %d %d %d %d %d %d %d %d %s %s\n", "T ", T->NumTrip, T->NumTar, T->NumVeic, T->HInicio, T->HFim,
             T->PIni, T->PFim, T->FolAcu, T->LinIni, T->LinFin);
    }

   fprintf(Arq, "\n\n\n%s\n\n", "JORNADAS");

   fprintf(Arq, "\n%s\n", "Dias teis:");
   for (int i = 0; i < EstM->LstJornDU->Count; i++)
    {
     J = (TJornada *)EstM->LstJornDU->Items[i];

     fprintf(Arq, "%s %c %d %d %d %d %d %d %d %s %s\n", "J ", J->Tipo, J->TmpTrab, J->HExtra, J->VeiIni, J->VeiFin,
             J->Ocio, J->HInicio, J->HFim, J->LinIni, J->LinFin);
    }

   fprintf(Arq, "\n\n");
   fprintf(Arq, "\n%s\n", "Feriados e domingos:");
   for (int i = 0; i < EstM->LstJornDF->Count; i++)
    {
     J = (TJornada *)EstM->LstJornDF->Items[i];

     fprintf(Arq, "%s %c %d %d %d %d %d %d %d %s %s\n", "J ", J->Tipo, J->TmpTrab, J->HExtra, J->VeiIni, J->VeiFin,
             J->Ocio, J->HInicio, J->HFim, J->LinIni, J->LinFin);
    }

   fprintf(Arq, "\n\n");
   fprintf(Arq, "\n%s\n", "Sbados:");
   for (int i = 0; i < EstM->LstJornSab->Count; i++)
    {
     J = (TJornada *)EstM->LstJornSab->Items[i];

     fprintf(Arq, "%s %c %d %d %d %d %d %d %d %s %s\n", "J ", J->Tipo, J->TmpTrab, J->HExtra, J->VeiIni, J->VeiFin,
             J->Ocio, J->HInicio, J->HFim, J->LinIni, J->LinFin);
    }

   fprintf(Arq, "\n\n\n%s\n\n", "JORNADAS DAS TRIPULAES");

   for (int i = 0; i < this->LstTripulacoes->Count; i++)
    {
     TEM = (TTripEM *)this->LstTripulacoes->Items[i];
     fprintf(Arq, "%s %d\n", "Tripulao: ", i);
     for (int j = 0; j < TEM->LstDias->Count; j++)
      {
       D = (TDias *)TEM->LstDias->Items[j];
       fprintf(Arq, "%s %d %c %d\n", "D ", D->Numero, D->Tipo, D->Qtd);
      }
     fprintf(Arq, "\n\n");
    }
   fprintf(Arq, "%s", "FIM");
  }
 fclose(Arq);

 char *DDestino = new char[ Dir.Length() + 1 ];
 strcpy(DDestino, Dir.c_str());
 char *DOrigem = new char[ Diretorio.Length() + 1 ];
 strcpy(DOrigem, Diretorio.c_str());

 CopyFile(DOrigem, DDestino, false);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CarregarEscala
- Objetivo...: Carregar uma escala mensal a partir de um arquivo (.esm).
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) EstM      -> Objeto que contm uma estrutura de um ms.
     2) Diretorio -> Diretrio do arquivo selecionado.
============================================================================= */
void TEscMensal::CarregarEscala(TEstruturaMes **EstM, String Diretorio)
{
 TEstruturaMes *EM = *EstM;

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "r");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg("O arquivo auxiliar da escala mensal no pode ser aberto!", mtError,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   char Linha[150];

   do
    {
     fscanf(Arq, "%s", &Linha);
    }while(strncmp(Linha, "MS:", 5));
   fscanf(Arq, "%s", &Linha);

   String Aux = Linha;
   int Mes, Ano;

   if (Aux[2] == '/')
    {
     Mes = StrToInt(Aux.SubString(1, 1));
     Ano = StrToInt(Aux.SubString(3, 4));
    }
   else
    {
     Mes = StrToInt(Aux.SubString(1, 2));
     Ano = StrToInt(Aux.SubString(4, 4));
    }

   EM->Mes    = getMes(Mes);
   EM->NumMes = Mes;
   EM->Ano    = Ano;

   TDias *D;
   TTar_Trip *T;
   TJornada *J;
   TTripEM *Trip;
   char LinIni[10];
   char LinFin[10];
   char Tipo;

   fscanf(Arq, "%s", &Linha);
   while (strncmp(Linha, "TAREFAS", 8))
    {
     D = new TDias();
     fscanf(Arq, "%d %c %d", &D->Numero, &D->Tipo, &D->Qtd);
     EM->LstDias->Add(D);
     fscanf(Arq, "%s", &Linha);
    }

   fscanf(Arq, "%s%s%s", &Linha, &Linha, &Linha);

   while (!strncmp(Linha, "T", 2))
    {
     T = new TTar_Trip();
     fscanf(Arq, "%d %d %d %d %d %d %d %d %s %s", &T->NumTrip, &T->NumTar, &T->NumVeic, &T->HInicio,
            &T->HFim, &T->PIni, &T->PFim, &T->FolAcu, &LinIni, &LinFin);
     T->LinIni = LinIni;
     T->LinFin = LinFin;
     EM->LstTar_TripDU->Add(T);
     fscanf(Arq, "%s", &Linha);
    }

   fscanf(Arq, "%s%s%s", &Linha, &Linha, &Linha);

   while (!strncmp(Linha, "T", 2))
    {
     T = new TTar_Trip();
     fscanf(Arq, "%d %d %d %d %d %d %d %d %s %s", &T->NumTrip, &T->NumTar, &T->NumVeic, &T->HInicio,
            &T->HFim, &T->PIni, &T->PFim, &T->FolAcu, &LinIni, &LinFin);
     T->LinIni = LinIni;
     T->LinFin = LinFin;
     EM->LstTar_TripDF->Add(T);
     fscanf(Arq, "%s", &Linha);
    }

   fscanf(Arq, "%s", &Linha);

   while (!strncmp(Linha, "T", 2))
    {
     T = new TTar_Trip();
     fscanf(Arq, "%d %d %d %d %d %d %d %d %s %s", &T->NumTrip, &T->NumTar, &T->NumVeic, &T->HInicio,
            &T->HFim, &T->PIni, &T->PFim, &T->FolAcu, &LinIni, &LinFin);
     T->LinIni = LinIni;
     T->LinFin = LinFin;
     EM->LstTar_TripSab->Add(T);
     fscanf(Arq, "%s", &Linha);
    }

   fscanf(Arq, "%s%s%s", &Linha, &Linha, &Linha);

   while (!strncmp(Linha, "J", 2))
    {
     J = new TJornada();
     fscanf(Arq, "%s %d %d %d %d %d %d %d %s %s", &Tipo, &J->TmpTrab, &J->HExtra, &J->VeiIni,
            &J->VeiFin, &J->Ocio, &J->HInicio, &J->HFim, &LinIni, &LinFin);
     J->Tipo   = Tipo;
     J->LinIni = LinIni;
     J->LinFin = LinFin;
     EM->LstJornDU->Add(J);
     fscanf(Arq, "%s", &Linha);
    }

   fscanf(Arq, "%s%s%s", &Linha, &Linha, &Linha);

   while (!strncmp(Linha, "J", 2))
    {
     J = new TJornada();
     fscanf(Arq, "%s %d %d %d %d %d %d %d %s %s", &Tipo, &J->TmpTrab, &J->HExtra, &J->VeiIni,
            &J->VeiFin, &J->Ocio, &J->HInicio, &J->HFim, &LinIni, &LinFin);
     J->Tipo   = Tipo;
     J->LinIni = LinIni;
     J->LinFin = LinFin;
     EM->LstJornDF->Add(J);
     fscanf(Arq, "%s", &Linha);
    }

   fscanf(Arq, "%s", &Linha);

   while (!strncmp(Linha, "J", 2))
    {
     J = new TJornada();
     fscanf(Arq, "%s %d %d %d %d %d %d %d %s %s", &Tipo, &J->TmpTrab, &J->HExtra, &J->VeiIni,
            &J->VeiFin, &J->Ocio, &J->HInicio, &J->HFim, &LinIni, &LinFin);
     J->Tipo   = Tipo;
     J->LinIni = LinIni;
     J->LinFin = LinFin;
     EM->LstJornSab->Add(J);
     fscanf(Arq, "%s", &Linha);
    }

   do
    {
     fscanf(Arq, "%s", &Linha);
    }while(strncmp(Linha, "Tripulao:", 11));
   do
    {
     fscanf(Arq, "%s", &Linha);
    }while(strncmp(Linha, "D", 2));

   while (strncmp(Linha, "FIM", 4))
    {
     Trip = new TTripEM();
     while (!strncmp(Linha, "D", 2))
      {
       D = new TDias();
       fscanf(Arq, "%d %c %d\n", &D->Numero, &D->Tipo, &D->Qtd);
       Trip->LstDias->Add(D);
       fscanf(Arq, "%s", &Linha);
      }
     this->LstTripulacoes->Add(Trip);
     fscanf(Arq, "%s%s", &Linha, &Linha);
    }
  }
 fclose(Arq);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: getTarefas
- Objetivo...: Agrupar todas as tarefas de uma tripulao.
- Retorno....: Uma lista com as tarefas.
- Parmetros.:
     1) EM    -> Objeto que contm a estrutura do ms selecionado.
     2) id    -> Indica se a lista  para dias teis, sbados ou domingos e feriados.
     3) NTrip -> N da tripulao.
============================================================================= */
TList *TEscMensal::getTarefas(TEstruturaMes *EM, char id, int NTrip)
{
 TList *L;
 if (id == 'U')
  L = EM->LstTar_TripDU;
 else if (id == 'D')
  L = EM->LstTar_TripDF;
 else
  L = EM->LstTar_TripSab;

 TList *LstAux = new TList();

 TTar_Trip *T;

 for (int i = 0; i < L->Count; i++)
  {
   T = (TTar_Trip *)L->Items[i];
   if (T->NumTrip == NTrip)
    LstAux->Add(T);
  }
 L->Capacity = L->Count;
 return LstAux;
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Free
- Objetivo...: Destuir o objeto TEscMensal e suas tripulaes.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TEscMensal::Free()
{
 TTripEM *Trip;
 for (int i = 0; i < this->LstTripulacoes->Count; i++)
  {
   Trip = (TTripEM *)this->LstTripulacoes->Items[i];
   Trip->Free();
  }
 delete(this->LstTripulacoes);
 delete(this);
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\



