/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UEscDiaria                         Tipo.......: .h
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar estruturas referentes  escala diria.
* Descrio................: Esta unit contm a "declarao" de uma classe
*                            (TEscDiaria) referente  escala diria.
* Obs......................: O arquivo .cpp dessa unit possui a implementao de
*                            tudo que foi declarado aqui.
* Dependncias.............:
*     1) UParPpt
*     2) UPesos
*******************************************************************************/

#ifndef UEscDiariaH
#define UEscDiariaH

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "classes.hpp"

#include "UParPpt.h"
#include "UPesos.h"
//------------------------------------------------------------------------------


/* =============================================================================
- Classe.....: TEscDiaria
- Objetivo...: Possui os atributos e mtodos referentes  escala diria.
============================================================================= */
class TEscDiaria{
  private:
    void EfetuarCalcED(TParPptED *, TPesosED *);

  public:
    bool Valida;               // Indica se a escala  vlida ou no.
    char Tipo;                 // Indica o tipo da escala (dia til, sab, domFer).
    int NTripComTarefa;        // Nmero de tripulaes com tarefas.
    int NTripDP;               // Nmero de tripulaes com dupla pegada.
    long int FncObjTotal;      // Valor da funo objetivo da escala.
    long int FOTotTripulacoes; // Valor da soma das funes objetivo das tripulaes.
    TList *LstTripulacoes;     // Lista de tripulaes.

    TEscDiaria();
    void InicializaLstTripulacoes(int);
    void CriarJornadas(TList *);
    TEscDiaria *Clone();
    void Movimento(TList **, int, TList **);
    void EfetuarCalculos(TParPptED *, TPesosED *);
    void EfCalcDepoisDoMovimento(TParPptED *, TPesosED *, int, int);
    void GravarEscala(String);
    void CarregarEscala(String);
    void Free();
};
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
extern TEscDiaria *escdiaria;
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#endif
// ----------------------------------- FIM ---------------------------------- \\
