/*******************************************************************************
* Sistema..................: PPT_Solver
* Unit.....................: UEscDiaria                       Tipo.......: .cpp
* Autor....................: Geraldo Regis Mauri (KAPA)
* ltima atualizao.......: 10 de JANEIRO de 2003
* Objetivo.................: Criar estruturas referentes  escala diria.
* Descrio................: Esta unit contm a "implementao" de uma classe
*                            (TEscDiaria) referente  escala diria.
* Obs......................: O arquivo .h dessa unit possui a declarao de
*                            tudo que foi implementado aqui.
* Dependncias.............:
*     1) UTripulacoes
*     2) UTar_Jorn
*     3) UUtil
*******************************************************************************/

#pragma hdrstop

#include "UEscDiaria.h"

//------------------------------------------------------------------------------
#pragma package(smart_init)
//------------------------------------------------------------------------------

// --------------------------- ARQUIVOS "IMPORTADOS" ------------------------ \\
#include "stdio.h"
#include "vcl.h"

#include "UTripulacoes.h"
#include "UTar_Jorn.h"

#include "UUtil.cpp"
//------------------------------------------------------------------------------

#define max(a, b)  (((a) > (b)) ? (a) : (b))

//------------------------------------------------------------------------------

TEscDiaria *escdiaria;

/* =============================================================================
- Mtodo.....: TEscDiaria
- Objetivo...: Criar e inicializar o objeto TEscDiaria.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
TEscDiaria::TEscDiaria()
{
 Valida           = false;
 String Tipo      = 'U';
 NTripComTarefa   = 0;
 NTripDP          = 0;
 FncObjTotal      = 0;
 FOTotTripulacoes = 0;
 LstTripulacoes = new TList();
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: InicializarLstTripulacoes
- Objetivo...: "Criar" NTrip tripulaes e adicion-las na lista.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) NTrip -> Nmero de tripulaes.
============================================================================= */
void TEscDiaria::InicializaLstTripulacoes(int NTrip)
{
 for (int i=0; i<NTrip; i++)
  {
   TTripED *T = new TTripED();
   this->LstTripulacoes->Add(T);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CriarJornadas
- Objetivo...: Criar as jornadas e atribu-las s tripulaes.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) LstTar -> Lista de tarefas (criada a partir da prog. de veculos).
============================================================================= */
void TEscDiaria::CriarJornadas(TList *LstTar)
{
 int ListSize = LstTar->Count;
 TTarefa *T;
 TTripED *Trip;

 for (int i = 0; i < ListSize; i++)
  {
   T = (TTarefa *)LstTar->Extract(LstTar->Items[random(LstTar->Count)]);
   LstTar->Capacity = LstTar->Count;
   Trip = (TTripED *)this->LstTripulacoes->Items[random(this->LstTripulacoes->Count)];
   Trip->LstTarefas->Add(T);
  }

 for (int i = 0; i < this->LstTripulacoes->Count; i++)
  {
   Trip = (TTripED *)this->LstTripulacoes->Items[i];
   Trip->LstTarefas->Sort(OrdenaListaHIni);
  }
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Clone
- Objetivo...: Criar e retornar uma escala diria com os valores iguais aos da
               escala diria que chamou o mtodo.
- Retorno....: Clone -> Objeto (TEscDiaria) com os mesmos valores da escala que
                        chamou o mtodo.
- Parmetros.: <-- Nenhum -->
============================================================================= */
TEscDiaria *TEscDiaria::Clone()
{
 TTripED *Trip, *TripC;
 TTarefa *Tar, *TarC;

 TEscDiaria *Clone = new TEscDiaria();

 Clone->InicializaLstTripulacoes(this->LstTripulacoes->Count);

 int i = 0;
 int j = 0;

 Clone->Valida           = this->Valida;
 Clone->FncObjTotal      = this->FncObjTotal;
 Clone->FOTotTripulacoes = this->FOTotTripulacoes;
 Clone->Tipo             = this->Tipo;
 Clone->NTripComTarefa   = this->NTripComTarefa;
 Clone->NTripDP          = this->NTripDP;

 while (i < this->LstTripulacoes->Count)
  {
   Trip = (TTripED *)this->LstTripulacoes->Items[i];
   TripC =(TTripED *)Clone->LstTripulacoes->Items[i];

   TripC->TmpTTrabalho       = Trip->TmpTTrabalho;
   TripC->TmpEJornadas       = Trip->TmpEJornadas;
   TripC->FncObjetivo        = Trip->FncObjetivo;
   TripC->FolAcuTotal        = Trip->FolAcuTotal;
   TripC->HExtra             = Trip->HExtra;
   TripC->TmpOcioso          = Trip->TmpOcioso;
   TripC->TmpSobreposicao    = Trip->TmpSobreposicao;
   TripC->NTarefas           = Trip->NTarefas;
   TripC->NDPegadas          = Trip->NDPegadas;
   TripC->NTPProibidas       = Trip->NTPProibidas;
   TripC->NTPPermitidas      = Trip->NTPPermitidas;
   TripC->NTLProibidas       = Trip->NTLProibidas;
   TripC->NTLPermitidas      = Trip->NTLPermitidas;
   TripC->NTVeiculos         = Trip->NTVeiculos;
   TripC->MaiorIntEntTarefas = Trip->MaiorIntEntTarefas;
   TripC->TVirtual           = Trip->TVirtual;

   while (j < Trip->LstTarefas->Count)
    {
     Tar = (TTarefa *)Trip->LstTarefas->Items[j];
     TarC = new TTarefa();
     TarC->HInicio = Tar->HInicio;
     TarC->HFim    = Tar->HFim;
     TarC->LinIni  = Tar->LinIni;
     TarC->LinFin  = Tar->LinFin;
     TarC->NumVeic = Tar->NumVeic;
     TarC->PIni    = Tar->PIni;
     TarC->PFim    = Tar->PFim;
     TarC->FolAcu  = Tar->FolAcu;
     TripC->LstTarefas->Add(TarC);
     j++;
    }
   j = 0;
   i++;
  }

 return(Clone);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Movimento
- Objetivo...: Remover uma tarefa de uma lista e adiciar em outra.
- Retorno....: <-- Nenhum -->
- Parmetros.: (As lista so passadas por referncia)
     1) LstOrigem  -> Lista de onde ser removida a tarefa.
     2) PosRem     -> Posio (na lista de origem) da tarefa a ser removida.
     3) LstDestino -> Lista de onde ser adicionada a tarefa.
============================================================================= */
void TEscDiaria::Movimento(TList **LstOrigem, int PosRem, TList **LstDestino)
{
 TList *LO = *LstOrigem;
 TList *LD = *LstDestino;
 TTarefa *Aux;

 Aux = (TTarefa *)LO->Extract(LO->Items[PosRem]);
 LO->Capacity = LO->Count;
 LD->Add(Aux);
 LD->Sort(OrdenaListaHIni);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: EfetuarCalculos
- Objetivo...: Efetuar todos os clculos para a escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) ParED -> Objeto que contm os parmetros para a escala diria.
     2) PED   -> Objeto que contm os pesos para a escala diria.
============================================================================= */
void TEscDiaria::EfetuarCalculos(TParPptED *ParED, TPesosED *PED)
{
 TTripED *T;
 this->FOTotTripulacoes = 0;
 this->NTripComTarefa   = 0;
 this->NTripDP          = 0;

 for (int i=0; i<this->LstTripulacoes->Count; i++)
  {
   T = (TTripED *)LstTripulacoes->Items[i];
   T->EfetuarCalcTrip(ParED, PED);
   this->NTripDP = this->NTripDP + T->NDPegadas;
   if (T->NTarefas != 0)
    this->NTripComTarefa++;
   this->FOTotTripulacoes = this->FOTotTripulacoes + T->FncObjetivo;
  }

 this->EfetuarCalcED(ParED, PED);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: EfetuarCalcED
- Objetivo...: Calcular o valor da funo objetivo total da escala diria.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) ParED -> Objeto que contm os parmetros para a escala diria.
     2) PED   -> Objeto que contm os pesos para a escala diria.
============================================================================= */
void TEscDiaria::EfetuarCalcED(TParPptED *ParED, TPesosED *PED)
{
 this->FncObjTotal = 0;

 int ETripDP = 0;  // Excesso de tripulaes com dupla pegada.

 ETripDP = max(0, this->NTripDP - ParED->NMaxTripDP);

 this->FncObjTotal = this->FOTotTripulacoes + (PED->PNumTrip * this->NTripComTarefa) +
                     (PED->PNMaxTripDP * ETripDP);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: EfCalDepoisDoMovimento
- Objetivo...: Calcular o valor da funo objetivo total depois de um movimento.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) ParED -> Objeto que contm os parmetros para a escala diria.
     2) PED   -> Objeto que contm os pesos para a escala diria.
     3) T1    -> N de uma das tripulaes do movimento.
     4) T2    -> N da outra tripulao do movimento.
============================================================================= */
void TEscDiaria::EfCalcDepoisDoMovimento(TParPptED *ParED, TPesosED *PED, int T1, int T2)
{
 TTripED *Trip1, *Trip2;

 int FOT1Antes, FOT1Depois, FOT2Antes, FOT2Depois;
 int NDPT1Antes, NDPT2Antes, NDPT1Depois, NDPT2Depois;
 int TemTarT1Antes, TemTarT2Antes, TemTarT1Depois, TemTarT2Depois;

 Trip1 = (TTripED *)this->LstTripulacoes->Items[T1];
 Trip2 = (TTripED *)this->LstTripulacoes->Items[T2];

 FOT1Antes = Trip1->FncObjetivo;
 FOT2Antes = Trip2->FncObjetivo;
 NDPT1Antes = Trip1->NDPegadas;
 NDPT2Antes = Trip2->NDPegadas;
 if (Trip1->NTarefas == 0)
  TemTarT1Antes = 0;
 else
  TemTarT1Antes = 1;
 if (Trip2->NTarefas == 0)
  TemTarT2Antes = 0;
 else
  TemTarT2Antes = 1;

 Trip1->EfetuarCalcTrip(ParED, PED);
 Trip2->EfetuarCalcTrip(ParED, PED);

 FOT1Depois = Trip1->FncObjetivo;
 FOT2Depois = Trip2->FncObjetivo;
 NDPT1Depois = Trip1->NDPegadas;
 NDPT2Depois = Trip2->NDPegadas;
 if (Trip1->NTarefas == 0)
  TemTarT1Depois = 0;
 else
  TemTarT1Depois = 1;
 if (Trip2->NTarefas == 0)
  TemTarT2Depois = 0;
 else
  TemTarT2Depois = 1;

 this->FOTotTripulacoes = this->FOTotTripulacoes - FOT1Antes - FOT2Antes + FOT1Depois + FOT2Depois;
 this->NTripComTarefa   = this->NTripComTarefa - TemTarT1Antes - TemTarT2Antes + TemTarT1Depois + TemTarT2Depois;
 this->NTripDP          = this->NTripDP - NDPT1Antes - NDPT2Antes + NDPT1Depois + NDPT2Depois;

 this->EfetuarCalcED(ParED, PED);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: GravarEscala
- Objetivo...: Gravar a escala diria obtida em nos arquivos "EsDU.txt" ou
               "EsDF.txt" ou "EsSab.txt" ou.
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) Dir -> Diretrio de destino do arquivo gravado.
============================================================================= */
void TEscDiaria::GravarEscala(String Dir)
{
 String Diretorio, Arquivo;
 String Tipo, separador3;

 if (this->Tipo == 'U')
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Resultados\\EsDU.txt";
   Arquivo = "EsDU.txt";
   Tipo = "*  ESCALA DIRIA - Dias teis  *";
   separador3 = "********************************";
  }
 else if (this->Tipo == 'D')
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Resultados\\EsDF.txt";
   Arquivo = "EsDF.txt";
   Tipo = "*  ESCALA DIRIA - Domingos e feriados  *";
   separador3 = "*****************************************";
  }
 else
  {
   Diretorio = ExtractFilePath(Application->ExeName) + "\\Resultados\\EsSab.txt";
   Arquivo = "EsSab.txt";
   Tipo = "*  ESCALA DIRIA - Sbados  *";
   separador3 = "*****************************";
  }
 if (Dir == "")
  Dir = Diretorio;

 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "w");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg("O arquivo " + Arquivo + " no pode ser aberto!", mtError,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   char separador1[108] =
   "===========================================================================================================";
   char separador2[108] =
   "-----------------------------------------------------------------------------------------------------------";

   TTripED *Trip;
   TTarefa *T;
   String Titulo,Pegadas;
   int i = 0;
   int j = 0;
   int NTrip = 0;
   String Aux, NV, HI, HF, PI, PF, FA, LI, LF, TTT, TO, HE;

   fprintf(Arq,"\n\t\t\t\t\t\t%s\n\t\t\t\t\t\t%s\n\t\t\t\t\t\t%s\n\n\n\n",
           separador3, Tipo, separador3);

   while(i < this->LstTripulacoes->Count)
    {
     Trip = (TTripED *)this->LstTripulacoes->Items[i];

     if (Trip->LstTarefas->Count != 0)
      {
       Titulo = "TRIPULAO " + IntToStr(NTrip);
       fprintf(Arq,"%s\n\t\t\t\t\t\t%s\n%s\n\t\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\n%s\n",
               separador1,Titulo,separador1,"N_Vei","H_Ini","H_Fim","P_Ini","P_Fim",
               "F_Acu","L_Ini","L_Fim",separador2);
       NTrip++;
       while(j < Trip->LstTarefas->Count)
        {
         T = (TTarefa *)Trip->LstTarefas->Items[j];

         Titulo = "Tarefa " + IntToStr(j);
         NV = IntToStr(T->NumVeic);
         PI = IntToStr(T->PIni);
         PF = IntToStr(T->PFim);
         FA = IntToStr(T->FolAcu);
         LI = getLinha(T->LinIni);
         LF = getLinha(T->LinFin);

         HI = MinuteToStr(T->HInicio);
         HF = MinuteToStr(T->HFim);

         fprintf(Arq,"%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\n%s\n",
                 Titulo,NV,HI,HF,PI,PF,FA,LI,LF,separador2);
         j++;
        }
       if (Trip->TVirtual != 0)
        {
         Titulo = "T.virtual!";
         NV = "TV!";
         PI = "TV!";
         PF = "TV!";
         FA = "TV!";
         LI = "TV!";
         LF = "TV!";

         HI = MinuteToStr(T->HFim);
         HF = MinuteToStr(Trip->TVirtual);

         fprintf(Arq,"%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\t\t%s\n%s\n",
                 Titulo,NV,HI,HF,PI,PF,FA,LI,LF,separador2);
        }
       j=0;
       fprintf(Arq,"\n");

       TTT = MinuteToStr(Trip->TmpTTrabalho);
       TO  = MinuteToStr(Trip->TmpOcioso);
       HE  = MinuteToStr(Trip->HExtra);

       if (Trip->NDPegadas == 0)
        Pegadas = "Jornada com pegada nica.";
       else
        Pegadas = "Jornada com dupla pegada.";

       fprintf(Arq,"%s%s\n%s%s\n%s%s\n%s\n%s\n\n\n", "Tempo trabalhado........: ",
               TTT, "Tempo ocioso............: ", TO, "Hora extra..............: ",
               HE, Pegadas, "--------------------------------------");
      }

     i++;
    }
  }
 fprintf(Arq,"%s", "FIM");

 fclose(Arq);

 char *DDestino = new char[ Dir.Length() + 1 ];
 strcpy(DDestino, Dir.c_str());
 char *DOrigem = new char[ Diretorio.Length() + 1 ];
 strcpy(DOrigem, Diretorio.c_str());

 CopyFile(DOrigem, DDestino, false);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: CarregarEscala
- Objetivo...: Carregar uma escala diria a partir de um arquivo (.esd).
- Retorno....: <-- Nenhum -->
- Parmetros.:
     1) Diretorio -> Diretrio do arquivo selecionado.
============================================================================= */
void TEscDiaria::CarregarEscala(String Diretorio)
{
 char *Path = new char[ Diretorio.Length() + 1 ];
 strcpy(Path, Diretorio.c_str());

 FILE *Arq;
 Arq = fopen(Path, "r");
 delete(Path);
 if(!Arq)
  {
   Beep();
   MessageDlg("O arquivo que contm a escala diria no pode ser aberto!", mtError,
              TMsgDlgButtons() << mbOK, 0);
  }
 else
  {
   char separador1[108] = "-----------------------------------------------------------------------------------------------------------";
   char separador2[39] = "--------------------------------------";
   char Linha[150];
   char Titulo[10];

   TTripED *TripED;
   TTarefa *T;

   int NTar;
   int HI, MI, HF, MF, LI, LF, NV, PI, PF, FA;
   char TV[3];
   int HorTT, MinTT, HorTO, MinTO, HorHE, MinHE;
   char TipoDePegada[24];

   do
    {
     fscanf(Arq, "%s", &Linha);
    }while(strncmp(Linha, "-", 2));
    fscanf(Arq, "%s", &Linha);

   if (!strncmp(Linha, "Dias", 5))
    this->Tipo = 'U';
   else if (!strncmp(Linha, "Domingos", 10))
    this->Tipo = 'D';
   else
    this->Tipo = 'S';

   fscanf(Arq,"%s",&Linha);
   while (strncmp(Linha, "FIM", 3))
    {
     TripED = new TTripED();

     do
      {
       fscanf(Arq,"%s",&Linha);
      }while(strncmp(Linha, separador1,109));

     fscanf(Arq, "%s", &Titulo);

     while (strncmp(Titulo, "Tempo", 5))
      {
       if (!strncmp(Titulo, "Tarefa", 6))
        {
         fscanf(Arq, "%d %d %d:%d %d:%d %d %d %d %d %d %s", &NTar, &NV, &HI, &MI, &HF, &MF, &PI, &PF, &FA, &LI, &LF, &Linha);
         T = new TTarefa();
         T->PreencherAtributos( (HI*60) + MI, (HF*60) + MF, LI, LF, NV, PI, PF, FA);
         TripED->LstTarefas->Add(T);
        }
       else
        {
         fscanf(Arq, "%s %d:%d %d:%d %s %s %s %s %s %s", &TV, &HI, &MI, &HF, &MF, &TV, &TV, &TV, &TV, &TV, &Linha);
         TripED->TVirtual = (HF*60) + MF;
        }

       fscanf(Arq, "%s", &Titulo);
      }
     this->LstTripulacoes->Add(TripED);
     do
      {
       fscanf(Arq,"%s",&Linha);
      }while(strncmp(Linha, separador2, 40));
     fscanf(Arq,"%s",&Linha);
    }
  }

 fclose(Arq);
}
//------------------------------------------------------------------------------

/* =============================================================================
- Mtodo.....: Free
- Objetivo...: Destuir o objeto TEscDiaria e suas tripulaes.
- Retorno....: <-- Nenhum -->
- Parmetros.: <-- Nenhum -->
============================================================================= */
void TEscDiaria::Free()
{
 TTripED *T;
 for (int i = 0; i < this->LstTripulacoes->Count; i++)
  {
   T = (TTripED *)this->LstTripulacoes->Items[i];
   T->Free();
  }
 delete(this->LstTripulacoes);
 delete(this);
}
//------------------------------------------------------------------------------

// ----------------------------------- FIM ---------------------------------- \\
